/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.loader;

import java.io.IOException;
import org.apache.tools.ant.module.loader.AntProjectDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class AntProjectDataLoader
extends UniFileLoader {
    public static final String REQUIRED_MIME = "text/x-ant+xml";
    private static final String KNOWN_ANT_FILENAME = "build.xml";
    private static final long serialVersionUID = 3642056255958054115L;

    public AntProjectDataLoader() {
        super("org.apache.tools.ant.module.loader.AntProjectDataObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(AntProjectDataLoader.class, (String)"LBL_loader_name");
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(REQUIRED_MIME);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        FileObject fileObject2 = super.findPrimaryFile(fileObject);
        if (fileObject2 == null && fileObject.getNameExt().equals(KNOWN_ANT_FILENAME)) {
            fileObject2 = fileObject;
        }
        return fileObject2;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new AntProjectDataObject(fileObject, this);
    }

    protected String actionsContext() {
        return "Loaders/text/x-ant+xml/Actions";
    }
}

