/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.run.LastTargetExecuted;
import org.apache.tools.ant.module.run.StopBuildingAction;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TargetExecutor
implements Runnable {
    private static final Map<InputOutput, String> freeTabs = new WeakHashMap<InputOutput, String>();
    private static final Set<String> activeDisplayNames = new HashSet<String>();
    private AntProjectCookie pcookie;
    private InputOutput io;
    private OutputStream outputStream;
    private boolean ok = false;
    private int verbosity = AntSettings.getVerbosity();
    private Map<String, String> properties = AntSettings.getProperties();
    private List<String> targetNames;
    private String displayName;
    private static final Map<InputOutput, StopAction> stopActions = new HashMap<InputOutput, StopAction>();
    private static final Map<InputOutput, RerunAction> rerunActions = new HashMap<InputOutput, RerunAction>();

    public TargetExecutor(AntProjectCookie antProjectCookie, String[] stringArray) {
        this.pcookie = antProjectCookie;
        this.targetNames = stringArray == null ? null : Arrays.asList(stringArray);
    }

    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public synchronized void setProperties(Map<String, String> map) {
        this.properties = new HashMap<String, String>(map);
    }

    static String getProcessDisplayName(AntProjectCookie antProjectCookie, List<String> list) {
        Element element = antProjectCookie.getProjectElement();
        String string = element != null ? Actions.cutAmpersand((String)element.getAttribute("name")) : NbBundle.getMessage(TargetExecutor.class, (String)"LBL_unparseable_proj_name");
        String string2 = antProjectCookie.getFileObject() != null ? antProjectCookie.getFileObject().getNameExt() : (antProjectCookie.getFile() != null ? antProjectCookie.getFile().getName() : "");
        if (string.equals("")) {
            string = string2;
        }
        if (list != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator<String> iterator = list.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(NbBundle.getMessage(TargetExecutor.class, (String)"SEP_output_target"));
                stringBuffer.append(iterator.next());
            }
            return NbBundle.getMessage(TargetExecutor.class, (String)"TITLE_output_target", (Object)string, (Object)string2, (Object)stringBuffer);
        }
        return NbBundle.getMessage(TargetExecutor.class, (String)"TITLE_output_notarget", (Object)string, (Object)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute() throws IOException {
        ExecutorTask executorTask;
        Object object;
        Object object2 = TargetExecutor.getProcessDisplayName(this.pcookie, this.targetNames);
        if (activeDisplayNames.contains(object2)) {
            int n = 2;
            while (activeDisplayNames.contains(object = NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.uniquified", (Object)object2, (Object)n++))) {
            }
            object2 = object;
        }
        assert (!activeDisplayNames.contains(object2));
        this.displayName = object2;
        activeDisplayNames.add(this.displayName);
        object = this;
        synchronized (object) {
            Object object3;
            if (AntSettings.getAutoCloseTabs()) {
                object3 = freeTabs;
                synchronized (object3) {
                    for (Map.Entry entry : freeTabs.entrySet()) {
                        InputOutput inputOutput = (InputOutput)entry.getKey();
                        String string = (String)entry.getValue();
                        if (this.io == null && string.equals(this.displayName)) {
                            this.io = inputOutput;
                            this.io.getOut().reset();
                            continue;
                        }
                        inputOutput.closeInputOutput();
                        stopActions.remove(inputOutput);
                        rerunActions.remove(inputOutput);
                    }
                    freeTabs.clear();
                }
            }
            if (this.io == null) {
                object3 = new StopAction();
                RerunAction rerunAction = new RerunAction(this);
                this.io = IOProvider.getDefault().getIO(this.displayName, new Action[]{rerunAction, object3});
                stopActions.put(this.io, (StopAction)object3);
                rerunActions.put(this.io, rerunAction);
            }
            executorTask = ExecutionEngine.getDefault().execute(null, (Runnable)this, InputOutput.NULL);
        }
        object = new WrapperExecutorTask(executorTask, this.io);
        RequestProcessor.getDefault().post((Runnable)object);
        return object;
    }

    public ExecutorTask execute(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        ExecutorTask executorTask = ExecutionEngine.getDefault().execute(null, (Runnable)this, InputOutput.NULL);
        return new WrapperExecutorTask(executorTask, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void run() {
        RerunAction rerunAction;
        StopAction stopAction;
        Thread[] threadArray;
        block21: {
            block19: {
                Map<InputOutput, String> map;
                block20: {
                    threadArray = new Thread[1];
                    stopAction = stopActions.get(this.io);
                    assert (stopAction != null);
                    rerunAction = rerunActions.get(this.io);
                    assert (rerunAction != null);
                    try {
                        final boolean[] blArray = new boolean[]{AntSettings.getAlwaysShowOutput()};
                        if (this.outputStream == null && blArray[0]) {
                            this.io.select();
                        }
                        if (AntSettings.getSaveAll()) {
                            LifecycleManager.getDefault().saveAll();
                        }
                        if (this.outputStream != null) throw new RuntimeException("XXX No support for outputStream currently!");
                        OutputWriter outputWriter = this.io.getOut();
                        OutputWriter outputWriter2 = this.io.getErr();
                        File file = this.pcookie.getFile();
                        if (file == null) {
                            outputWriter2.println(NbBundle.getMessage(TargetExecutor.class, (String)"EXC_non_local_proj_file"));
                            Object var12_8 = null;
                            if (this.io == null) break block19;
                            map = freeTabs;
                            break block20;
                        }
                        LastTargetExecuted.record(file, this.verbosity, this.targetNames != null ? this.targetNames.toArray(new String[this.targetNames.size()]) : null, this.properties);
                        Thread.currentThread().setPriority(3);
                        final Runnable runnable = new Runnable(){

                            public void run() {
                                if (!blArray[0]) {
                                    blArray[0] = true;
                                    TargetExecutor.this.io.select();
                                }
                            }
                        };
                        ReaderInputStream readerInputStream = null;
                        if (this.outputStream == null) {
                            try {
                                readerInputStream = new ReaderInputStream(this.io.getIn()){

                                    public int read() throws IOException {
                                        runnable.run();
                                        return super.read();
                                    }

                                    public int read(byte[] byArray) throws IOException {
                                        runnable.run();
                                        return super.read(byArray);
                                    }

                                    public int read(byte[] byArray, int n, int n2) throws IOException {
                                        runnable.run();
                                        return super.read(byArray, n, n2);
                                    }

                                    public long skip(long l) throws IOException {
                                        runnable.run();
                                        return super.skip(l);
                                    }
                                };
                            }
                            catch (IOException iOException) {
                                AntModule.err.notify(1, (Throwable)iOException);
                            }
                        }
                        threadArray[0] = Thread.currentThread();
                        StopBuildingAction.registerProcess(threadArray[0], this.displayName);
                        stopAction.t = threadArray[0];
                        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)new Cancellable(){

                            public boolean cancel() {
                                stopAction.actionPerformed(null);
                                return true;
                            }
                        }, (Action)new AbstractAction(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                TargetExecutor.this.io.select();
                            }
                        });
                        progressHandle.setInitialDelay(0);
                        progressHandle.start();
                        stopAction.setEnabled(true);
                        rerunAction.setEnabled(false);
                        this.ok = AntBridge.getInterface().run(file, this.targetNames, (InputStream)readerInputStream, outputWriter, outputWriter2, this.properties, this.verbosity, this.displayName, runnable, progressHandle);
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var12_10 = null;
                        if (this.io != null) {
                            Map<InputOutput, String> map2 = freeTabs;
                            synchronized (map2) {
                                freeTabs.put(this.io, this.displayName);
                            }
                        }
                        if (threadArray[0] != null) {
                            StopBuildingAction.unregisterProcess(threadArray[0]);
                        }
                        stopAction.t = null;
                        stopAction.setEnabled(false);
                        rerunAction.setEnabled(true);
                        activeDisplayNames.remove(this.displayName);
                        throw throwable;
                    }
                }
                synchronized (map) {
                    freeTabs.put(this.io, this.displayName);
                }
            }
            if (threadArray[0] != null) {
                StopBuildingAction.unregisterProcess(threadArray[0]);
            }
            stopAction.t = null;
            stopAction.setEnabled(false);
            rerunAction.setEnabled(true);
            activeDisplayNames.remove(this.displayName);
            return;
        }
        Object var12_9 = null;
        if (this.io != null) {
            Map<InputOutput, String> map = freeTabs;
            synchronized (map) {
                freeTabs.put(this.io, this.displayName);
            }
        }
        if (threadArray[0] != null) {
            StopBuildingAction.unregisterProcess(threadArray[0]);
        }
        stopAction.t = null;
        stopAction.setEnabled(false);
        rerunAction.setEnabled(true);
        activeDisplayNames.remove(this.displayName);
    }

    static void stopProcess(Thread thread) {
        AntBridge.getInterface().stop(thread);
    }

    private static final class RerunAction
    extends AbstractAction
    implements FileChangeListener {
        private final AntProjectCookie pcookie;
        private final List<String> targetNames;
        private final int verbosity;
        private final Map<String, String> properties;

        public RerunAction(TargetExecutor targetExecutor) {
            this.pcookie = targetExecutor.pcookie;
            this.targetNames = targetExecutor.targetNames;
            this.verbosity = targetExecutor.verbosity;
            this.properties = targetExecutor.properties;
            this.setEnabled(false);
            FileObject fileObject = this.pcookie.getFileObject();
            if (fileObject != null) {
                fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
            }
        }

        public Object getValue(String string) {
            if (string.equals("SmallIcon")) {
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/rerun.png"));
            }
            if (string.equals("ShortDescription")) {
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.RerunAction.rerun");
            }
            return super.getValue(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            try {
                TargetExecutor targetExecutor = new TargetExecutor(this.pcookie, this.targetNames != null ? this.targetNames.toArray(new String[this.targetNames.size()]) : null);
                targetExecutor.setVerbosity(this.verbosity);
                targetExecutor.setProperties(this.properties);
                targetExecutor.execute();
            }
            catch (IOException iOException) {
                Logger.getLogger(TargetExecutor.class.getName()).log(Level.INFO, null, iOException);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.firePropertyChange("enabled", null, false);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public boolean isEnabled() {
            return super.isEnabled() && this.pcookie.getFileObject() != null && this.pcookie.getFileObject().isValid();
        }
    }

    private static final class StopAction
    extends AbstractAction {
        public Thread t;

        public StopAction() {
            this.setEnabled(false);
        }

        public Object getValue(String string) {
            if (string.equals("SmallIcon")) {
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/stop.gif"));
            }
            if (string.equals("ShortDescription")) {
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.StopAction.stop");
            }
            return super.getValue(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            if (this.t != null) {
                TargetExecutor.stopProcess(this.t);
            }
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;
        private InputOutput io;

        public WrapperExecutorTask(ExecutorTask executorTask, InputOutput inputOutput) {
            super((Runnable)new WrapperRunnable(executorTask));
            this.task = executorTask;
            this.io = inputOutput;
        }

        public void stop() {
            StopAction stopAction = (StopAction)stopActions.get(this.io);
            if (stopAction != null) {
                stopAction.actionPerformed(null);
            } else {
                this.task.stop();
            }
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return this.io;
        }
    }

    private static class WrapperRunnable
    implements Runnable {
        private final ExecutorTask task;

        public WrapperRunnable(ExecutorTask executorTask) {
            this.task = executorTask;
        }

        public void run() {
            this.task.waitFinished();
        }
    }
}

