/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class IntroPanel
extends JPanel {
    private IntroWizardPanel wiz;
    private JCheckBox customizeCheck;
    private JTextArea hintsArea;
    private JCheckBox keyboardCheck;
    private JCheckBox menuCheck;
    private JCheckBox toolbarCheck;

    public IntroPanel(IntroWizardPanel introWizardPanel) {
        this.wiz = introWizardPanel;
        this.initComponents();
        this.initAccessibility();
        this.setName(NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_cfg_basic_opts"));
    }

    public void requestFocus() {
        super.requestFocus();
        this.customizeCheck.requestFocus();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"IP_TEXT_select_how_to_install_shortcut"));
        this.menuCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_menu_item"));
        this.toolbarCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_toolbar_button"));
        this.keyboardCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_kbd_shortcut"));
        this.customizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_cust_code_checkbox"));
    }

    private void initComponents() {
        this.customizeCheck = new JCheckBox();
        this.menuCheck = new JCheckBox();
        this.toolbarCheck = new JCheckBox();
        this.keyboardCheck = new JCheckBox();
        this.hintsArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.customizeCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_cust_code_checkbox"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.customizeCheck, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.menuCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_menu_item"));
        this.menuCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.menuCheck, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.toolbarCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_toolbar_button"));
        this.toolbarCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.toolbarCheck, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.keyboardCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_kbd_shortcut"));
        this.keyboardCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.keyboardCheck, gridBagConstraints);
        this.hintsArea.setEditable(false);
        this.hintsArea.setFont(UIManager.getFont("Label.font"));
        this.hintsArea.setText(NbBundle.getMessage(IntroPanel.class, (String)"IP_TEXT_select_how_to_install_shortcut"));
        this.hintsArea.setBackground(new Color(204, 204, 204));
        this.hintsArea.setLineWrap(true);
        this.hintsArea.setForeground(new Color(102, 102, 153));
        this.hintsArea.setWrapStyleWord(true);
        this.hintsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.hintsArea.setOpaque(false);
        this.hintsArea.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.hintsArea, gridBagConstraints);
    }

    private void someCheckboxClicked(ActionEvent actionEvent) {
        this.wiz.fireChangeEvent();
    }

    public static class IntroWizardPanel
    implements WizardDescriptor.Panel {
        private IntroPanel panel = null;
        private ShortcutWizard wiz = null;
        private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

        public void initialize(ShortcutWizard shortcutWizard) {
            this.wiz = shortcutWizard;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        private IntroPanel getPanel() {
            if (this.panel == null) {
                this.panel = new IntroPanel(this);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid() {
            return this.getPanel().menuCheck.isSelected() || this.getPanel().toolbarCheck.isSelected() || this.getPanel().keyboardCheck.isSelected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addChangeListener(ChangeListener changeListener) {
            Set<ChangeListener> set = this.listeners;
            synchronized (set) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeChangeListener(ChangeListener changeListener) {
            Set<ChangeListener> set = this.listeners;
            synchronized (set) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void fireChangeEvent() {
            ChangeListener[] changeListenerArray;
            this.storeSettings((Object)this.wiz);
            Object object = this.listeners;
            synchronized (object) {
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (ChangeListener changeListener : changeListenerArray) {
                changeListener.stateChanged((ChangeEvent)object);
            }
        }

        public void readSettings(Object object) {
        }

        public void storeSettings(Object object) {
            WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
            wizardDescriptor.putProperty("wizdata.show.cust", (Object)(this.getPanel().customizeCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
            wizardDescriptor.putProperty("wizdata.show.menu", (Object)(this.getPanel().menuCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
            wizardDescriptor.putProperty("wizdata.show.tool", (Object)(this.getPanel().toolbarCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
            wizardDescriptor.putProperty("wizdata.show.keyb", (Object)(this.getPanel().keyboardCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        }
    }
}

