/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.util.FileCollection;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvsModuleConfig {
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_SEARCHHISTORY_FETCHTAGS = "searchHistory.fetchTags";
    public static final String PROP_EXCLUDE_NEW_FILES = "excludeNewFiles";
    public static final String ROOTS_CONFIG = "rootsConfig";
    public static final String PROP_ANNOTATIONS_VISIBLE = "textAnnotationsVisible";
    public static final String PROP_ANNOTATIONS_FORMAT = "annotationsFormat";
    private static final String PROP_WRAP_COMMIT_MESSAGE_LENGTH = "wrapCommitMessageLength";
    public static final String DEFAULT_ANNOTATIONS_FORMAT = "[{status}; {tag}]";
    private static final String FIELD_SEPARATOR = "<~>";
    private static final CvsModuleConfig INSTANCE = new CvsModuleConfig();
    private FileCollection excludedFiles = new FileCollection();
    private Map<String, RootSettings> rootsMap;

    public static CvsModuleConfig getDefault() {
        return INSTANCE;
    }

    public CvsModuleConfig() {
        this.excludedFiles.load(this.getPreferences(), PROP_COMMIT_EXCLUSIONS);
    }

    public int getWrapCommitMessagelength() {
        return this.getPreferences().getInt(PROP_WRAP_COMMIT_MESSAGE_LENGTH, 0);
    }

    public void setWrapCommitMessagelength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.getPreferences().putInt(PROP_WRAP_COMMIT_MESSAGE_LENGTH, n);
    }

    public Pattern[] getIgnoredFilePatterns() {
        return this.getDefaultFilePatterns();
    }

    public boolean isExcludedFromCommit(File file) {
        return this.excludedFiles.contains(file);
    }

    public void addExclusion(File file) {
        this.excludedFiles.add(file);
        this.excludedFiles.save(this.getPreferences(), PROP_COMMIT_EXCLUSIONS);
    }

    public void removeExclusion(File file) {
        this.excludedFiles.remove(file);
        this.excludedFiles.save(this.getPreferences(), PROP_COMMIT_EXCLUSIONS);
    }

    public synchronized boolean hasExtSettingsFor(CVSRoot cVSRoot) {
        String string;
        assert ("ext".equals(cVSRoot.getMethod()));
        Map<String, RootSettings> map = this.getRootsMap();
        RootSettings rootSettings = map.get(string = cVSRoot.toString());
        if (rootSettings != null) {
            ExtSettings extSettings = rootSettings.extSettings;
            return extSettings != null;
        }
        return false;
    }

    public synchronized ExtSettings getExtSettingsFor(CVSRoot cVSRoot) {
        ExtSettings extSettings;
        String string;
        assert ("ext".equals(cVSRoot.getMethod()));
        Map<String, RootSettings> map = this.getRootsMap();
        RootSettings rootSettings = map.get(string = cVSRoot.toString());
        if (rootSettings != null && (extSettings = rootSettings.extSettings) != null) {
            if (!extSettings.extUseInternalSsh && extSettings.extCommand == null) {
                extSettings.extCommand = System.getenv("CVS_RSH");
            }
            return extSettings;
        }
        extSettings = new ExtSettings();
        extSettings.extRememberPassword = false;
        extSettings.extCommand = System.getenv("CVS_RSH");
        extSettings.extUseInternalSsh = true;
        extSettings.extPassword = null;
        return extSettings;
    }

    public synchronized void setExtSettingsFor(CVSRoot cVSRoot, ExtSettings extSettings) {
        String string;
        assert ("ext".equals(cVSRoot.getMethod()));
        Map<String, RootSettings> map = this.getRootsMap();
        RootSettings rootSettings = map.get(string = cVSRoot.toString());
        if (rootSettings == null) {
            rootSettings = new RootSettings();
        }
        rootSettings.extSettings = extSettings;
        map.put(string, rootSettings);
        this.storeRootsMap();
    }

    private Map<String, RootSettings> getRootsMap() {
        if (this.rootsMap == null) {
            this.rootsMap = this.loadRootsMap();
        }
        return this.rootsMap;
    }

    private Map<String, RootSettings> loadRootsMap() {
        List list = Utils.getStringList((Preferences)this.getPreferences(), (String)"cvsRootSettings");
        HashMap<String, RootSettings> hashMap = new HashMap<String, RootSettings>(list.size());
        for (String string : list) {
            ExtSettings extSettings;
            RootSettings rootSettings;
            String[] stringArray = string.split(FIELD_SEPARATOR);
            if (stringArray.length >= 8) {
                rootSettings = new RootSettings();
                hashMap.put(stringArray[0], rootSettings);
                if (stringArray.length < 11) continue;
                extSettings = new ExtSettings();
                rootSettings.extSettings = extSettings;
                extSettings.extUseInternalSsh = Boolean.valueOf(stringArray[8]);
                extSettings.extRememberPassword = Boolean.valueOf(stringArray[9]);
                extSettings.extCommand = stringArray[10];
                if (stringArray.length < 12) continue;
                extSettings.extPassword = stringArray[11];
                continue;
            }
            if (stringArray.length < 4) continue;
            rootSettings = new RootSettings();
            hashMap.put(stringArray[0], rootSettings);
            extSettings = new ExtSettings();
            rootSettings.extSettings = extSettings;
            extSettings.extUseInternalSsh = Boolean.valueOf(stringArray[1]);
            extSettings.extRememberPassword = Boolean.valueOf(stringArray[2]);
            extSettings.extCommand = stringArray[3];
            if (stringArray.length < 5) continue;
            extSettings.extPassword = stringArray[4];
        }
        return hashMap;
    }

    private void storeRootsMap() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, RootSettings> entry : this.rootsMap.entrySet()) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(entry.getKey());
            RootSettings rootSettings = entry.getValue();
            if (rootSettings.extSettings != null) {
                stringBuffer.append(FIELD_SEPARATOR);
                stringBuffer.append(((RootSettings)rootSettings).extSettings.extUseInternalSsh);
                stringBuffer.append(FIELD_SEPARATOR);
                stringBuffer.append(((RootSettings)rootSettings).extSettings.extRememberPassword);
                stringBuffer.append(FIELD_SEPARATOR);
                stringBuffer.append(((RootSettings)rootSettings).extSettings.extCommand);
                if (((RootSettings)rootSettings).extSettings.extRememberPassword) {
                    stringBuffer.append(FIELD_SEPARATOR);
                    stringBuffer.append(((RootSettings)rootSettings).extSettings.extPassword);
                }
            }
            arrayList.add(stringBuffer.toString());
        }
        Utils.put((Preferences)this.getPreferences(), (String)"cvsRootSettings", arrayList);
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(CvsModuleConfig.class);
    }

    private Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }

    public static final class ExtSettings {
        public boolean extUseInternalSsh;
        public boolean extRememberPassword;
        public String extPassword;
        public String extCommand;
    }

    private static final class RootSettings {
        private ExtSettings extSettings;

        private RootSettings() {
        }
    }
}

