/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CommandReport;
import org.netbeans.modules.versioning.system.cvss.CommandRunnable;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.ui.UIUtils;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RootWizard;
import org.netbeans.modules.versioning.system.cvss.util.CommandDuplicator;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutorSupport
implements CVSListener,
ExecutorGroup.Groupable {
    private static final String[] ignoredMessagePrefixes = new String[]{"cvs server: Updating", "cvs server: New directory"};
    protected final FileStatusCache cache;
    protected List toRefresh = new ArrayList(10);
    protected final CvsVersioningSystem cvs;
    protected final Command cmd;
    private final GlobalOptions options;
    private RequestProcessor.Task task;
    private List taskListeners = new ArrayList(2);
    private Throwable internalError;
    private boolean terminated;
    private boolean commandFailed;
    private boolean finishedExecution;
    private boolean executed;
    private CommandRunnable commandRunnable;
    private StringBuffer message = new StringBuffer();
    private ClientRuntime clientRuntime;
    private List errorMessages = new ArrayList();
    private List warningMessages = new ArrayList();
    private ExecutorGroup group;
    boolean t9yRetryFlag;
    private boolean nonInteractive;

    protected ExecutorSupport(CvsVersioningSystem cvsVersioningSystem, Command command, GlobalOptions globalOptions) {
        this.cvs = cvsVersioningSystem;
        this.cmd = command;
        this.options = globalOptions;
        this.cache = cvsVersioningSystem.getStatusCache();
    }

    protected void setNonInteractive(boolean bl) {
        this.nonInteractive = bl;
    }

    @Override
    public void execute() {
        assert (!this.executed);
        this.executed = true;
        if (this.group == null) {
            this.group = new ExecutorGroup(this.getDisplayName());
            this.group.setNonInteractive(this.nonInteractive);
        }
        this.setup();
        this.executeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeImpl() {
        try {
            this.task = this.cvs.post(this.cmd, this.options, this);
        }
        catch (Throwable throwable) {
            this.internalError = throwable;
            this.group.fail();
            String string = NbBundle.getMessage(ExecutorSupport.class, (String)"BK1003", (Object)new Date(), (Object)this.getDisplayName());
            if (this.clientRuntime != null) {
                this.clientRuntime.log(string + "\n");
                this.clientRuntime.logError(throwable);
            }
            ErrorManager.getDefault().notify(1, throwable);
            ExecutorSupport executorSupport = this;
            synchronized (executorSupport) {
                this.finishedExecution = true;
                this.notifyAll();
            }
            this.cleanup();
        }
    }

    protected void setup() {
    }

    protected void cleanup() {
    }

    protected String getDisplayName() {
        String string;
        if (this.group != null) {
            string = this.group.getDisplayName();
        } else {
            string = this.cmd.getDisplayName();
            if (string == null) {
                string = this.cmd.getCVSCommand();
            }
        }
        return string;
    }

    protected boolean logCommandOutput() {
        return true;
    }

    @Override
    public void joinGroup(ExecutorGroup executorGroup) {
        assert (!this.executed);
        this.group = executorGroup;
    }

    public ExecutorGroup getGroup() {
        return this.group;
    }

    public Throwable getFailure() {
        return this.internalError;
    }

    public boolean isCancelled() {
        return this.group.isCancelled();
    }

    public boolean isSuccessful() {
        return this.internalError == null && !this.group.isCancelled() && !this.commandFailed;
    }

    public RequestProcessor.Task getTask() {
        return this.task;
    }

    public void messageSent(MessageEvent messageEvent) {
        String string;
        if (messageEvent.isError()) {
            string = messageEvent.getMessage();
            if (string == null) {
                RuntimeException runtimeException = new RuntimeException("Received null MessageEvent from:");
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                runtimeException.printStackTrace(printWriter);
                printWriter.close();
                string = stringWriter.getBuffer().toString();
            }
            this.errorMessages.add(string);
        } else if (messageEvent.getMessage().startsWith("W ")) {
            this.warningMessages.add(messageEvent.getMessage().substring(2));
        }
        if (messageEvent.isTagged()) {
            string = MessageEvent.parseTaggedMessage((StringBuffer)this.message, (String)messageEvent.getMessage());
            if (string != null) {
                this.clientRuntime.log(string + "\n");
                this.message.setLength(0);
            }
        } else {
            boolean bl = messageEvent.getMessage().indexOf("waiting for") != -1;
            if (((bl &= messageEvent.getMessage().indexOf("lock in") != -1) || this.logCommandOutput()) && messageEvent.getMessage().length() > 0 && this.shouldBeDisplayed(messageEvent.getMessage())) {
                this.clientRuntime.log(messageEvent.getMessage() + "\n");
            }
        }
    }

    private boolean shouldBeDisplayed(String string) {
        for (int i = 0; i < ignoredMessagePrefixes.length; ++i) {
            if (!string.startsWith(ignoredMessagePrefixes[i])) continue;
            return false;
        }
        return true;
    }

    public void messageSent(BinaryMessageEvent binaryMessageEvent) {
    }

    public void fileAdded(FileAddedEvent fileAddedEvent) {
    }

    public void fileRemoved(FileRemovedEvent fileRemovedEvent) {
    }

    public void fileUpdated(FileUpdatedEvent fileUpdatedEvent) {
    }

    public void fileToRemove(FileToRemoveEvent fileToRemoveEvent) {
    }

    public void fileInfoGenerated(FileInfoEvent fileInfoEvent) {
        assert (!this.terminated);
        FileInfoContainer fileInfoContainer = fileInfoEvent.getInfoContainer();
        if (fileInfoContainer.getFile() == null) {
            ErrorManager.getDefault().log(16, org.netbeans.modules.versioning.util.Utils.getStackTrace());
            return;
        }
        if (fileInfoContainer instanceof DefaultFileInfoContainer) {
            DefaultFileInfoContainer defaultFileInfoContainer = (DefaultFileInfoContainer)fileInfoContainer;
            defaultFileInfoContainer.setFile(FileUtil.normalizeFile((File)defaultFileInfoContainer.getFile()));
            Iterator iterator = this.toRefresh.iterator();
            while (iterator.hasNext()) {
                FileInfoContainer fileInfoContainer2 = (FileInfoContainer)iterator.next();
                if (!fileInfoContainer2.getFile().equals(fileInfoContainer.getFile())) continue;
                String string = ((DefaultFileInfoContainer)fileInfoContainer2).getType();
                String string2 = defaultFileInfoContainer.getType();
                if (this.importance(string2) <= this.importance(string)) {
                    return;
                }
                iterator.remove();
                break;
            }
        }
        this.toRefresh.add(fileInfoContainer);
    }

    private int importance(String string) {
        return "UC".indexOf(string);
    }

    public void commandEnqueued(CommandRunnable commandRunnable) {
        this.commandRunnable = commandRunnable;
        this.group.enqueued(this.cvs.getClientRuntime(this.cmd, this.options), this);
        this.group.addCancellable(commandRunnable);
    }

    public void commandStarted(CommandRunnable commandRunnable) {
        this.clientRuntime = this.cvs.getClientRuntime(this.cmd, this.options);
        this.group.started(this.clientRuntime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commandTerminated(TerminationEvent var1_1) {
        block27: {
            block28: {
                try {
                    if (!(var1_1.getSource() instanceof ClientRuntime.Result)) break block27;
                    if (!ExecutorSupport.$assertionsDisabled && this.terminated) {
                        throw new AssertionError();
                    }
                    this.terminated = true;
                    var2_2 = (ClientRuntime.Result)var1_1.getSource();
                    var3_3 = var2_2.getError();
                    if (var2_2.isAborted() || Thread.currentThread().isInterrupted()) {
                        this.toRefresh.clear();
                        var6_4 = null;
                        if (this.terminated == false) return;
                        this.cleanup();
                        var7_7 = this;
                        break block28;
                    }
                    if (var3_3 != null) {
                        this.toRefresh.clear();
                        if (var3_3 instanceof CommandException) {
                            this.internalError = var3_3;
                            ErrorManager.getDefault().notify(1, var3_3);
                            this.report(NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandFailed_Title"), NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandFailed_Prompt"), Arrays.asList(new String[]{var3_3.getMessage()}), 0);
                            break block27;
                        }
                        if (!this.nonInteractive && this.retryConnection(var3_3)) {
                            this.terminated = false;
                            var4_13 = NbBundle.getMessage(ExecutorSupport.class, (String)"BK1004", (Object)new Date(), (Object)this.getDisplayName());
                            this.clientRuntime = this.cvs.getClientRuntime(this.cmd, this.options);
                            this.clientRuntime.log(var4_13 + "\n");
                            this.executeImpl();
                            break block27;
                        } else {
                            if (!this.nonInteractive) {
                                var4_13 = NbBundle.getMessage(ExecutorSupport.class, (String)"BK1005", (Object)new Date(), (Object)this.getDisplayName());
                                this.clientRuntime.log(var4_13 + "\n");
                            }
                            this.internalError = var2_2.getError();
                            this.group.fail();
                            ErrorManager.getDefault().notify(1, this.internalError);
                        }
                        break block27;
                    }
                    this.commandFinished((ClientRuntime.Result)var1_1.getSource());
                    if (this.cmd.hasFailed()) {
                        this.commandFailed = true;
                        this.group.fail();
                        this.report(NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandFailed_Title"), NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandFailed_Prompt"), this.errorMessages, 0);
                    }
                    if (this.warningMessages.size() > 0) {
                        this.report(NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandWarning_Title"), NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandWarning_Prompt"), this.warningMessages, 2);
                    }
                    break block27;
                }
                catch (Throwable var5_14) {
                    var6_6 = null;
                    if (this.terminated == false) throw var5_14;
                    this.cleanup();
                    var7_9 = this;
                    synchronized (var7_9) {
                        this.finishedExecution = true;
                        this.notifyAll();
                    }
                    var8_12 = this.taskListeners;
                    synchronized (var8_12) {
                        var7_9 = new ArrayList<E>(this.taskListeners).iterator();
                    }
                    while (true) {
                        if (!var7_9.hasNext()) {
                            this.group.finished(this.clientRuntime, this);
                            throw var5_14;
                        }
                        try {
                            var8_12 = (TaskListener)var7_9.next();
                            var8_12.taskFinished((Task)this.task);
                        }
                        catch (RuntimeException var8_12) {
                            ErrorManager.getDefault().notify((Throwable)var8_12);
                        }
                    }
                }
            }
            synchronized (var7_7) {
                this.finishedExecution = true;
                this.notifyAll();
            }
            var8_10 = this.taskListeners;
            synchronized (var8_10) {
                var7_7 = new ArrayList<E>(this.taskListeners).iterator();
            }
            while (var7_7.hasNext()) {
                ** try [egrp 3[TRYBLOCK] [7 : 525->551)] { 
lbl78:
                // 1 sources

                var8_10 = (TaskListener)var7_7.next();
                var8_10.taskFinished((Task)this.task);
lbl81:
                // 1 sources

                catch (RuntimeException var8_10) {
                    ErrorManager.getDefault().notify((Throwable)var8_10);
                }
            }
            this.group.finished(this.clientRuntime, this);
            return;
        }
        var6_5 = null;
        if (this.terminated == false) return;
        this.cleanup();
        var7_8 = this;
        synchronized (var7_8) {
            this.finishedExecution = true;
            this.notifyAll();
        }
        var8_11 = this.taskListeners;
        synchronized (var8_11) {
            var7_8 = new ArrayList<E>(this.taskListeners).iterator();
        }
        while (var7_8.hasNext()) {
            ** try [egrp 3[TRYBLOCK] [7 : 525->551)] { 
lbl99:
            // 1 sources

            var8_11 = (TaskListener)var7_8.next();
            var8_11.taskFinished((Task)this.task);
lbl102:
            // 1 sources

            catch (RuntimeException var8_11) {
                ErrorManager.getDefault().notify((Throwable)var8_11);
            }
        }
        this.group.finished(this.clientRuntime, this);
    }

    protected void report(String string, String string2, List<String> list, int n) {
        if (this.nonInteractive) {
            return;
        }
        boolean bl = true;
        for (String object2 : list) {
            if (object2 == null || object2.length() <= 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        CommandReport commandReport = new CommandReport(string2, list);
        JButton jButton = new JButton(NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandReport_OK"));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)commandReport, string, -1, n, new Object[]{jButton}, (Object)jButton);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener taskListener) {
        List list = this.taskListeners;
        synchronized (list) {
            this.taskListeners.add(taskListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener taskListener) {
        List list = this.taskListeners;
        synchronized (list) {
            this.taskListeners.remove(taskListener);
        }
    }

    private boolean retryConnection(Throwable throwable) {
        String string;
        CVSRoot cVSRoot;
        Throwable throwable2 = throwable;
        String string2 = this.getCvsRoot();
        if (string2 == null) {
            return false;
        }
        try {
            cVSRoot = CVSRoot.parse((String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        final RootWizard rootWizard = RootWizard.configureRoot(cVSRoot.toString());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        StringBuffer stringBuffer = new StringBuffer("<ul>");
        while (throwable != null) {
            try {
                string = throwable.getLocalizedMessage();
                string = string == null ? throwable.getClass().getName() : XMLUtil.toElementContent((String)string);
                stringBuffer.append("<li>" + string + "</li>");
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            throwable = throwable.getCause();
        }
        stringBuffer.append("</ul>");
        string = NbBundle.getMessage(ExecutorSupport.class, (String)"BK0001", (Object)stringBuffer.toString(), (Object)string2);
        JLabel jLabel = new JLabel(string);
        int n = Math.max((int)((double)string2.length() * 1.1), 50);
        UIUtils.computePreferredSize(jLabel, n);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)rootWizard.getPanel(), "Center");
        String string3 = NbBundle.getMessage(ExecutorSupport.class, (String)"CTL_Password_Action_Ok");
        final JButton jButton = new JButton(string3);
        jButton.setEnabled(rootWizard.isValid());
        jButton.getAccessibleContext().setAccessibleDescription(string3);
        String string4 = NbBundle.getMessage(ExecutorSupport.class, (String)"CTL_Password_Action_Cancel");
        JButton jButton2 = new JButton(string4);
        jButton2.getAccessibleContext().setAccessibleDescription(string4);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(ExecutorSupport.class, (String)"BK0004", (Object)this.getDisplayName()), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        dialogDescriptor.setMessageType(2);
        dialogDescriptor.setClosingOptions(null);
        rootWizard.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jButton.setEnabled(rootWizard.isValid());
            }
        });
        ErrorManager.getDefault().notify(1, throwable2);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExecutorSupport.class, (String)"BK0005"));
        dialog.setVisible(true);
        boolean bl = false;
        if (dialogDescriptor.getValue() == jButton) {
            rootWizard.commit(false);
            bl = true;
        }
        return bl;
    }

    private String getCvsRoot() {
        if (this.cmd.getGlobalOptions() != null && this.cmd.getGlobalOptions().getCVSRoot() != null) {
            return this.cmd.getGlobalOptions().getCVSRoot();
        }
        if (this.options != null && this.options.getCVSRoot() != null) {
            return this.options.getCVSRoot();
        }
        try {
            return this.cvs.detectCvsRoot(this.cmd);
        }
        catch (NotVersionedException notVersionedException) {
            return null;
        }
    }

    protected abstract void commandFinished(ClientRuntime.Result var1);

    public void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
    }

    protected static BasicCommand[] prepareBasicCommand(BasicCommand basicCommand) throws IOException {
        String string = basicCommand.getDisplayName();
        File[] fileArray = basicCommand.getFiles();
        if (fileArray == null || fileArray.length < 2) {
            if (string != null) {
                basicCommand.setDisplayName(MessageFormat.format(string, fileArray == null ? "" : fileArray[0].getName()));
            }
            return new BasicCommand[]{basicCommand};
        }
        File[][] fileArray2 = ExecutorSupport.splitFiles(fileArray);
        if (fileArray2.length == 1) {
            String string2 = NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_ExecutorSupport_CommandFiles", (Object)Integer.toString(fileArray2[0].length));
            if (string != null) {
                basicCommand.setDisplayName(MessageFormat.format(string, string2));
            }
            return new BasicCommand[]{basicCommand};
        }
        BasicCommand[] basicCommandArray = new BasicCommand[fileArray2.length];
        CommandDuplicator commandDuplicator = CommandDuplicator.getDuplicator((Command)basicCommand);
        for (int i = 0; i < fileArray2.length; ++i) {
            BasicCommand basicCommand2 = (BasicCommand)commandDuplicator.duplicate();
            basicCommand2.setFiles(fileArray2[i]);
            basicCommandArray[i] = basicCommand2;
            String string3 = NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_ExecutorSupport_CommandFiles", (Object)Integer.toString(fileArray2[i].length));
            if (string == null) continue;
            basicCommandArray[i].setDisplayName(MessageFormat.format(string, string3));
        }
        return basicCommandArray;
    }

    protected static File[][] splitFiles(File[] fileArray) throws IOException {
        ArrayList<File[]> arrayList = new ArrayList<File[]>();
        File[][] fileArray2 = ExecutorSupport.splitByCvsRoot(fileArray);
        for (int i = 0; i < fileArray2.length; ++i) {
            File[] fileArray3 = fileArray2[i];
            File[][] fileArray4 = ExecutorSupport.splitByCommonParent(fileArray3);
            for (int j = 0; j < fileArray4.length; ++j) {
                arrayList.add(fileArray4[j]);
            }
        }
        return (File[][])arrayList.toArray((T[])new File[arrayList.size()][]);
    }

    protected static File[][] splitByCvsRoot(File[] fileArray) throws IOException {
        HashMap<Object, HashSet<File>> hashMap = new HashMap<Object, HashSet<File>>();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            String string = Utils.getCVSRootFor(file);
            HashSet<File> hashSet = (HashSet<File>)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<File>();
                hashMap.put(string, hashSet);
            }
            hashSet.add(file);
        }
        File[][] fileArray2 = new File[hashMap.size()][];
        int n = 0;
        for (HashSet<File> hashSet : hashMap.values()) {
            fileArray2[n++] = hashSet.toArray(new File[hashSet.size()]);
        }
        return fileArray2;
    }

    private static File[][] splitByCommonParent(File[] fileArray) {
        HashMap<File, HashSet<File>> hashMap = new HashMap<File, HashSet<File>>();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            File file2 = file.isDirectory() ? file : file.getParentFile();
            Set<File> set = null;
            Object object = null;
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                File file3 = (File)iterator.next();
                object = org.netbeans.modules.versioning.util.Utils.getCommonParent((File)file2, (File)file3);
                if (object == null) continue;
                set = (Set)hashMap.get(file3);
                iterator.remove();
                break;
            }
            if (object == null) {
                set = new HashSet<File>(1);
                object = file2;
            }
            set.add(file);
            hashMap.put((File)object, (HashSet<File>)set);
        }
        File[][] fileArray2 = new File[hashMap.size()][];
        int n = 0;
        for (Set<File> set : hashMap.values()) {
            fileArray2[n++] = set.toArray(new File[set.size()]);
        }
        return fileArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(ExecutorSupport[] executorSupportArray) {
        boolean bl = true;
        for (int i = 0; i < executorSupportArray.length; ++i) {
            ExecutorSupport executorSupport;
            ExecutorSupport executorSupport2 = executorSupport = executorSupportArray[i];
            synchronized (executorSupport2) {
                while (!executorSupport.finishedExecution) {
                    try {
                        executorSupport.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        executorSupport.getGroup().cancel();
                    }
                }
            }
            if (executorSupport.isSuccessful()) continue;
            bl = false;
        }
        return bl;
    }

    public void increaseDataCounter(long l) {
        this.group.increaseDataCounter(l);
    }
}

