/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.annotate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationMark;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationMarkInstaller;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.AnnotationMarkProvider;
import org.netbeans.modules.versioning.system.cvss.ui.actions.annotate.LinesReader;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.LogOutputListener;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

final class AnnotationBar
extends JComponent
implements Accessible,
PropertyChangeListener,
LogOutputListener,
DocumentListener,
ChangeListener,
ActionListener,
Runnable,
ComponentListener {
    private final JTextComponent textComponent;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument doc;
    private final Caret caret;
    private Timer caretTimer;
    private boolean annotated;
    private Map elementAnnotations;
    private Map commitMessages;
    private String elementAnnotationsSubstitute;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private Color selectedColor = Color.BLUE;
    private String recentStatusMessage;
    private String recentRevision;
    RequestProcessor requestProcessor = null;
    private RequestProcessor.Task latestAnnotationTask = null;

    public AnnotationBar(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.doc = this.editorUI.getDocument();
        this.caret = this.textComponent.getCaret();
    }

    public void annotate() {
        this.annotated = true;
        this.elementAnnotations = null;
        this.commitMessages = null;
        ResourceBundle resourceBundle = NbBundle.getBundle(AnnotationBar.class);
        this.elementAnnotationsSubstitute = resourceBundle.getString("CTL_AnnotationSubstitute");
        this.doc.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.editorUI.addPropertyChangeListener((PropertyChangeListener)this);
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationLines(File file, List list) {
        AnnotateLine annotateLine;
        Object object;
        Object object2;
        LinkedList linkedList = new LinkedList(list);
        int n = linkedList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i + 1;
        }
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffProvider != null) {
            object2 = new LinesReader(linkedList);
            object = Utils.getDocumentReader((Document)this.doc);
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                Difference difference;
                int n6;
                annotateLine = diffProvider.computeDiff((Reader)object2, (Reader)object);
                for (n6 = 0; n6 < ((Difference[])annotateLine).length; ++n6) {
                    difference = annotateLine[n6];
                    if (difference.getType() == 1) continue;
                    n5 = difference.getFirstEnd() - difference.getFirstStart() + 1;
                    if (difference.getType() == 2) {
                        n4 = difference.getFirstEnd() - difference.getFirstStart();
                        n3 = difference.getSecondEnd() - difference.getSecondStart();
                        if (n3 >= n4) continue;
                        n2 = difference.getSecondStart();
                        n5 = n4 - n3;
                    } else {
                        n2 = difference.getSecondStart() + 1;
                    }
                    n4 = n2 + n5 - 1;
                    while (n4 < n) {
                        int n7 = n4++;
                        nArray[n7] = nArray[n7] - n5;
                    }
                }
                for (n6 = ((Difference[])annotateLine).length - 1; n6 >= 0; --n6) {
                    difference = annotateLine[n6];
                    if (difference.getType() == 0) continue;
                    n5 = difference.getSecondEnd() - difference.getSecondStart() + 1;
                    if (difference.getType() == 2) {
                        n4 = difference.getFirstEnd() - difference.getFirstStart();
                        n3 = difference.getSecondEnd() - difference.getSecondStart();
                        if (n3 <= n4) continue;
                        n5 = n3 - n4;
                        n2 = difference.getFirstStart();
                    } else {
                        n2 = difference.getFirstStart() + 1;
                    }
                    n4 = n2 - 1;
                    while (n4 < n) {
                        int n8 = n4++;
                        nArray[n8] = nArray[n8] + n5;
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, "Cannot compute local diff required for annotations, ignoring...");
                errorManager.notify(1, (Throwable)iOException);
            }
        }
        try {
            this.doc.atomicLock();
            object2 = (StyledDocument)this.doc;
            object = linkedList.iterator();
            this.elementAnnotations = Collections.synchronizedMap(new HashMap(linkedList.size()));
            while (object.hasNext()) {
                annotateLine = (AnnotateLine)object.next();
                int n9 = nArray[annotateLine.getLineNum() - 1];
                try {
                    int n10 = NbDocument.findLineOffset((StyledDocument)object2, (int)(n9 - 1));
                    Element element = object2.getParagraphElement(n10);
                    this.elementAnnotations.put(element, annotateLine);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
                }
            }
        }
        finally {
            this.doc.atomicUnlock();
        }
        this.caret.addChangeListener(this);
        this.caretTimer = new Timer(500, this);
        this.caretTimer.setRepeats(false);
        this.onCurrentLine();
        this.revalidate();
        this.repaint();
    }

    public void commitMessages(Map map) {
        this.commitMessages = map;
    }

    private File getCurrentFile() {
        File file = null;
        DataObject dataObject = (DataObject)this.doc.getProperty((Object)"stream");
        if (dataObject != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            file = FileUtil.toFile((FileObject)fileObject);
        }
        return file;
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AnnotationBar.this.createPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.setToolTipText("");
    }

    private JPopupMenu createPopup() {
        Object object;
        Object object2;
        ResourceBundle resourceBundle = NbBundle.getBundle(AnnotationBar.class);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("CTL_MenuItem_DiffToRevision"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                String string;
                if (AnnotationBar.this.recentRevision != null && (string = org.netbeans.modules.versioning.system.cvss.util.Utils.previousRevision(AnnotationBar.this.recentRevision)) != null && (file = AnnotationBar.this.getCurrentFile()) != null) {
                    DiffExecutor diffExecutor = new DiffExecutor(file.getName());
                    diffExecutor.showDiff(file, string, AnnotationBar.this.recentRevision);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(resourceBundle.getString("CTL_MenuItem_RollbackToRevision"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = AnnotationBar.this.getCurrentFile();
                GetCleanAction.rollback(file, AnnotationBar.this.recentRevision);
            }
        });
        jPopupMenu.add(jMenuItem2);
        Project project = org.netbeans.modules.versioning.system.cvss.util.Utils.getProject(this.getCurrentFile());
        if (project != null) {
            object2 = ProjectUtils.getInformation((Project)project).getDisplayName();
            object = new JMenuItem(NbBundle.getMessage(AnnotationBar.class, (String)"CTL_MenuItem_FindCommitInProject", (Object)object2));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AnnotationBar.this.getCurrentLine();
                    if (n == -1) {
                        return;
                    }
                    AnnotateLine annotateLine = AnnotationBar.this.getAnnotateLine(n);
                    if (annotateLine == null || AnnotationBar.this.commitMessages == null) {
                        return;
                    }
                    String string = (String)AnnotationBar.this.commitMessages.get(annotateLine.getRevision());
                    File file = AnnotationBar.this.getCurrentFile();
                    Project project = org.netbeans.modules.versioning.system.cvss.util.Utils.getProject(file);
                    Context context = org.netbeans.modules.versioning.system.cvss.util.Utils.getProjectsContext(new Project[]{project});
                    SearchHistoryAction.openSearch(context, ProjectUtils.getInformation((Project)project).getDisplayName(), string, annotateLine.getAuthor(), annotateLine.getDate());
                }
            });
            jPopupMenu.add((JMenuItem)object);
        }
        object2 = new JMenuItem(resourceBundle.getString("CTL_MenuItem_FindCommitInProjects"));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AnnotationBar.this.getCurrentLine();
                if (n == -1) {
                    return;
                }
                AnnotateLine annotateLine = AnnotationBar.this.getAnnotateLine(n);
                if (annotateLine == null || AnnotationBar.this.commitMessages == null) {
                    return;
                }
                String string = (String)AnnotationBar.this.commitMessages.get(annotateLine.getRevision());
                Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
                int n2 = projectArray.length;
                SearchHistoryAction.openSearch(n2 == 1 ? ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName() : NbBundle.getMessage(AnnotationBar.class, (String)"CTL_FindAssociateChanges_OpenProjects_Title", (Object)Integer.toString(n2)), string, annotateLine.getAuthor(), annotateLine.getDate());
            }
        });
        jPopupMenu.add((JMenuItem)object2);
        object2 = new JMenuItem(resourceBundle.getString("CTL_MenuItem_CloseAnnotations"));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationBar.this.hideBar();
            }
        });
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add((JMenuItem)object2);
        jMenuItem.setVisible(false);
        jMenuItem2.setVisible(false);
        if (this.recentRevision != null) {
            String string;
            object = org.netbeans.modules.versioning.system.cvss.util.Utils.previousRevision(this.recentRevision);
            if (object != null) {
                string = resourceBundle.getString("CTL_MenuItem_DiffToRevision");
                jMenuItem.setText(MessageFormat.format(string, this.recentRevision, object));
                jMenuItem.setVisible(true);
            }
            string = resourceBundle.getString("CTL_MenuItem_RollbackToRevision");
            jMenuItem2.setText(MessageFormat.format(string, this.recentRevision));
            jMenuItem2.setVisible(true);
        }
        return jPopupMenu;
    }

    void hideBar() {
        this.annotated = false;
        this.revalidate();
        this.release();
    }

    private int getCurrentLine() {
        int n = 0;
        int n2 = this.caret.getDot();
        try {
            n = Utilities.getLineOffset((BaseDocument)this.doc, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            n = -1;
        }
        return n;
    }

    private RequestProcessor getRequestProcessor() {
        if (this.requestProcessor == null) {
            this.requestProcessor = new RequestProcessor("AnnotationBarRP", 1, true);
        }
        return this.requestProcessor;
    }

    private void onCurrentLine() {
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        this.latestAnnotationTask = this.getRequestProcessor().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        ResourceBundle resourceBundle = NbBundle.getBundle(AnnotationBar.class);
        StatusBar statusBar = this.editorUI.getStatusBar();
        this.recentStatusMessage = resourceBundle.getString("CTL_StatusBar_WaitFetchAnnotation");
        statusBar.setText("main", this.recentStatusMessage);
        int n = -1;
        int n2 = this.caret.getDot();
        try {
            n = Utilities.getLineOffset((BaseDocument)this.doc, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)badLocationException, "Can not get line for caret at offset " + n2);
            errorManager.notify((Throwable)badLocationException);
            this.clearRecentFeedback();
            return;
        }
        AnnotateLine annotateLine = this.getAnnotateLine(n);
        if (annotateLine == null) {
            AnnotationMarkProvider annotationMarkProvider = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (annotationMarkProvider != null) {
                annotationMarkProvider.setMarks(Collections.EMPTY_LIST);
            }
            this.clearRecentFeedback();
            if (this.recentRevision != null) {
                this.recentRevision = null;
                this.repaint();
            }
            return;
        }
        String string = annotateLine.getRevision();
        if (!string.equals(this.recentRevision)) {
            this.recentRevision = string;
            this.repaint();
            object = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (object != null) {
                Iterator iterator;
                ArrayList<AnnotationMark> arrayList = new ArrayList<AnnotationMark>(this.elementAnnotations.size());
                Map.Entry entry = this.elementAnnotations;
                synchronized (entry) {
                    iterator = new HashSet(this.elementAnnotations.entrySet()).iterator();
                }
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    AnnotateLine annotateLine2 = (AnnotateLine)entry.getValue();
                    if (string.equals(annotateLine2.getRevision())) {
                        Element element = (Element)entry.getKey();
                        if (!this.elementAnnotations.containsKey(element)) continue;
                        int n3 = element.getStartOffset();
                        int n4 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)n3);
                        AnnotationMark annotationMark = new AnnotationMark(n4, string);
                        arrayList.add(annotationMark);
                    }
                    if (!Thread.interrupted()) continue;
                    this.clearRecentFeedback();
                    return;
                }
                ((AnnotationMarkProvider)((Object)object)).setMarks(arrayList);
            }
        }
        if (this.commitMessages != null) {
            object = (String)this.commitMessages.get(string);
            if (object != null) {
                this.recentStatusMessage = object;
                statusBar.setText("main", annotateLine.getAuthor() + ": " + this.recentStatusMessage);
            } else {
                this.clearRecentFeedback();
            }
        } else {
            this.clearRecentFeedback();
        }
    }

    private void clearRecentFeedback() {
        StatusBar statusBar = this.editorUI.getStatusBar();
        if (statusBar.getText("main") == this.recentStatusMessage) {
            statusBar.setText("main", "");
        }
    }

    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = this.textComponent.getSize();
        dimension.width = n = this.annotated ? this.getBarWidth() : 0;
        dimension.height *= 2;
        return dimension;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBarWidth() {
        Object object;
        String string = "";
        if (this.elementAnnotations == null) {
            string = this.elementAnnotationsSubstitute;
        } else {
            object = this.elementAnnotations;
            synchronized (object) {
                for (AnnotateLine annotateLine : this.elementAnnotations.values()) {
                    String string2 = annotateLine.getRevision() + " " + annotateLine.getAuthor();
                    if (string2.length() <= string.length()) continue;
                    string = string2;
                }
            }
        }
        object = string.toCharArray();
        int n = this.getGraphics().getFontMetrics().charsWidth((char[])object, 0, ((Object)object).length);
        return n;
    }

    private void release() {
        AnnotationMarkProvider annotationMarkProvider;
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        this.textComponent.removeComponentListener(this);
        this.doc.removeDocumentListener((DocumentListener)this);
        this.caret.removeChangeListener(this);
        if (this.caretTimer != null) {
            this.caretTimer.removeActionListener(this);
        }
        this.commitMessages = null;
        this.elementAnnotations = null;
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        if ((annotationMarkProvider = AnnotationMarkInstaller.getMarkProvider(this.textComponent)) != null) {
            annotationMarkProvider.setMarks(Collections.EMPTY_LIST);
        }
        this.clearRecentFeedback();
    }

    private void paintView(View view, Graphics graphics, int n) {
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        Element element = baseTextUI.getRootView(jTextComponent).getElement();
        int n2 = element.getElementIndex(view.getStartOffset());
        String string = "";
        AnnotateLine annotateLine = null;
        if (this.elementAnnotations != null) {
            annotateLine = this.getAnnotateLine(n2);
            if (annotateLine != null) {
                string = annotateLine.getRevision() + " " + annotateLine.getAuthor();
            }
        } else {
            string = this.elementAnnotationsSubstitute;
        }
        if (annotateLine != null && annotateLine.getRevision().equals(this.recentRevision)) {
            graphics.setColor(this.selectedColor());
        } else {
            graphics.setColor(this.foregroundColor());
        }
        graphics.drawString(string, 0, n + this.editorUI.getLineAscent());
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.editorUI == null) {
            return null;
        }
        int n = this.getLineFromMouseEvent(mouseEvent);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.elementAnnotations != null) {
            AnnotateLine annotateLine = this.getAnnotateLine(n);
            if (annotateLine != null) {
                String string;
                Object object;
                String string2 = NbBundle.getMessage(AnnotationBar.class, (String)"BK0001");
                try {
                    string2 = XMLUtil.toElementContent((String)annotateLine.getAuthor());
                }
                catch (CharConversionException charConversionException) {
                    object = ErrorManager.getDefault();
                    object.annotate((Throwable)charConversionException, "CVS.AB: can not HTML escape: " + annotateLine.getAuthor());
                    object.notify(1, (Throwable)charConversionException);
                }
                stringBuffer.append("<html><!-- line=" + n++ + " -->" + annotateLine.getRevision() + " <b>" + string2 + "</b> " + annotateLine.getDateString());
                if (this.commitMessages != null && (string = (String)this.commitMessages.get(annotateLine.getRevision())) != null) {
                    object = null;
                    try {
                        object = XMLUtil.toElementContent((String)string);
                    }
                    catch (CharConversionException charConversionException) {
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.annotate((Throwable)charConversionException, "CVS.AB: can not HTML escape: " + string);
                        errorManager.notify(1, (Throwable)charConversionException);
                    }
                    if (object != null) {
                        String string3 = ((String)object).replaceAll(System.getProperty("line.separator"), "<br>");
                        stringBuffer.append("<p>" + string3);
                    }
                }
            }
        } else {
            stringBuffer.append(this.elementAnnotationsSubstitute);
        }
        return stringBuffer.toString();
    }

    private AnnotateLine getAnnotateLine(int n) {
        StyledDocument styledDocument = (StyledDocument)this.doc;
        int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        Element element = styledDocument.getParagraphElement(n2);
        AnnotateLine annotateLine = (AnnotateLine)this.elementAnnotations.get(element);
        if (annotateLine != null) {
            int n3 = element.getStartOffset();
            int n4 = element.getEndOffset();
            try {
                int n5 = n4 - n3;
                String string = this.doc.getText(n3, n5 - 1);
                String string2 = annotateLine.getContent();
                if (string.equals(string2)) {
                    return annotateLine;
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)badLocationException, "CVS.AB: can not locate line annotation.");
                errorManager.notify(1, (Throwable)badLocationException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        block11: {
            super.paintComponent(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            JTextComponent jTextComponent = this.editorUI.getComponent();
            if (jTextComponent == null) {
                return;
            }
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            View view = Utilities.getDocumentView((JTextComponent)jTextComponent);
            if (view == null) {
                return;
            }
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
            abstractDocument.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int n = baseTextUI.getPosFromY(rectangle.y);
                    int n2 = view.getViewIndex(n, Position.Bias.Forward);
                    int n3 = view.getViewCount();
                    if (n2 < 0 || n2 >= n3) break block11;
                    Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, view.getView(n2).getStartOffset());
                    int n4 = rectangle2 == null ? 0 : rectangle2.y;
                    int n5 = rectangle.y + rectangle.height;
                    for (int i = n2; i < n3; ++i) {
                        View view2 = view.getView(i);
                        this.paintView(view2, graphics, n4);
                        if ((n4 += this.editorUI.getLineHeight()) < n5) continue;
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Color foregroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.foregroundColor;
    }

    private Color selectedColor() {
        if (this.backgroundColor == this.backgroundColor()) {
            return this.selectedColor;
        }
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.selectedColor;
    }

    private int getLineFromMouseEvent(MouseEvent mouseEvent) {
        int n = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent jTextComponent = this.editorUI.getComponent();
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                int n2 = baseTextUI.viewToModel(jTextComponent, new Point(0, mouseEvent.getY()));
                n = Utilities.getLineOffset((BaseDocument)this.doc, (int)n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return n;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string) && propertyChangeEvent.getNewValue() == null) {
            this.release();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.elementAnnotations != null) {
            Element[] elementArray = documentEvent.getDocument().getRootElements();
            Map map = this.elementAnnotations;
            synchronized (map) {
                for (int i = 0; i < elementArray.length; ++i) {
                    Element element;
                    Object v;
                    Element[] elementArray2;
                    Element element2 = elementArray[i];
                    DocumentEvent.ElementChange elementChange = documentEvent.getChange(element2);
                    if (elementChange == null) continue;
                    Element[] elementArray3 = elementChange.getChildrenRemoved();
                    if (elementArray3.length == (elementArray2 = elementChange.getChildrenAdded()).length) {
                        for (int j = 0; j < elementArray3.length; ++j) {
                            v = this.elementAnnotations.get(elementArray3[j]);
                            if (v == null) continue;
                            this.elementAnnotations.remove(elementArray3[j]);
                            this.elementAnnotations.put(elementArray2[j], v);
                        }
                        continue;
                    }
                    if (elementArray3.length != 1 || elementArray2.length <= 0 || (v = this.elementAnnotations.get(element = elementArray3[0])) == null) continue;
                    this.elementAnnotations.remove(element);
                    this.elementAnnotations.put(elementArray2[0], v);
                }
            }
        }
        this.repaint();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() == 0) {
            this.hideBar();
        }
        this.repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        assert (changeEvent.getSource() == this.caret);
        this.caretTimer.restart();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (actionEvent.getSource() == this.caretTimer);
        this.onCurrentLine();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.revalidate();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private static class CvsAnnotation
    extends Annotation {
        private final String text;
        private Line line;

        public CvsAnnotation(String string, Line line) {
            this.text = string;
            this.line = line;
        }

        public void attach() {
            this.attach((Annotatable)this.line);
            this.line = null;
        }

        public String getShortDescription() {
            return this.text;
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-versioning-system-cvss-Annotation";
        }
    }
}

