/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GetCleanAction
extends AbstractSystemAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_GetClean";
    }

    protected boolean enable(Node[] nodeArray) {
        return CvsVersioningSystem.getInstance().getFileTableModel(Utils.getCurrentContext(nodeArray), 6612).getNodes().length > 0;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(final Node[] nodeArray) {
        if (!GetCleanAction.confirmed(null, null)) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                GetCleanAction.this.revertModifications(nodeArray);
            }
        });
    }

    private static boolean confirmed(File file, String string) {
        String string2 = file == null || string == null ? NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_Prompt") : NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_Prompt2", (Object)file.getName(), (Object)string);
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string2, NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_Title"), 0, 2, null, null);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        return object == NotifyDescriptor.YES_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertModifications(Node[] nodeArray) {
        ExecutorGroup executorGroup = new ExecutorGroup(NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_Progress"));
        try {
            int n;
            executorGroup.progress(NbBundle.getMessage(GetCleanAction.class, (String)"CTL_RevertModifications_ProgressPrepare"));
            FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
            File[] fileArray = fileStatusCache.listFiles(this.getContext(nodeArray), 2512);
            for (n = 0; n < fileArray.length; ++n) {
                File file = fileArray[n];
                GetCleanAction.rollback(file, "*", executorGroup);
            }
            for (n = 0; n < fileArray.length; ++n) {
                GetCleanAction.refresh(fileArray[n]);
            }
        }
        finally {
            executorGroup.executed();
        }
    }

    public static void rollback(File file, String string) {
        if (!GetCleanAction.confirmed(file, string)) {
            return;
        }
        GetCleanAction.rollback(file, string, null);
        GetCleanAction.refresh(file);
    }

    private static void refresh(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            fileObject.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rollback(File file, String string, ExecutorGroup executorGroup) {
        block27: {
            FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
            AdminHandler adminHandler = CvsVersioningSystem.getInstance().getAdminHandler();
            Entry entry = null;
            try {
                entry = adminHandler.getEntry(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ((entry == null || entry.isNewUserFile()) && string.equals("*")) {
                GetCleanAction.backup(file, entry);
                file.delete();
                return;
            }
            try {
                File file2 = VersionsCache.getInstance().getRemoteFile(file, string, executorGroup);
                if (file2 != null) {
                    FileObject fileObject;
                    Object object;
                    Object object2;
                    GetCleanAction.backup(file, entry);
                    if (!file.exists()) {
                        object2 = file.getParentFile();
                        object = Utils.mkfolders((File)object2);
                        fileObject = object.createData(file.getName());
                    } else {
                        fileObject = FileUtil.toFileObject((File)file);
                    }
                    object2 = null;
                    object = null;
                    FileLock fileLock = null;
                    try {
                        object2 = new FileInputStream(file2);
                        fileLock = fileObject.lock();
                        object = fileObject.getOutputStream(fileLock);
                        GetCleanAction.copyStream((InputStream)object2, (OutputStream)object);
                    }
                    finally {
                        if (object2 != null) {
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (object != null) {
                            try {
                                ((OutputStream)object).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                    if (entry != null && entry.isUserFileToBeRemoved()) {
                        entry.setRevision(entry.getRevision().substring(1));
                        adminHandler.setEntry(file, entry);
                    }
                    fileStatusCache.refresh(file, string == "*" ? 65536 : 0);
                    break block27;
                }
                if (executorGroup.isCancelled()) {
                    return;
                }
                Logger.getLogger(GetCleanAction.class.getName()).severe("Unable to revert changes in " + file.getName() + "; checkout failed");
            }
            catch (Exception exception) {
                if (exception.getCause() instanceof InterruptedException) break block27;
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray, 0, 4096)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    private static void backup(File file, Entry entry) {
        if (!file.isFile()) {
            return;
        }
        try {
            File file2 = entry != null ? new File(file.getParentFile(), ".#" + file.getName() + "." + entry.getRevision()) : new File(file.getParentFile(), ".#" + file.getName() + "." + "LOCAL");
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

