/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateResultNode
extends AbstractNode {
    private DefaultFileInfoContainer info;
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PATH = "path";
    static final String COLUMN_NAME_STATUS = "status";
    private final MessageFormat conflictFormat = new MessageFormat("<font color=\"#FF0000\">{0}</font>");
    private final MessageFormat mergedFormat = new MessageFormat("<font color=\"#0000FF\">{0}</font>");
    private final MessageFormat removedFormat = new MessageFormat("<font color=\"#999999\">{0}</font>");
    private String statusDisplayName;
    private String htmlDisplayName;
    private final String[] zeros = new String[]{"", "00", "0", ""};

    public UpdateResultNode(DefaultFileInfoContainer defaultFileInfoContainer) {
        super(Children.LEAF);
        this.info = defaultFileInfoContainer;
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    public DefaultFileInfoContainer getInfo() {
        return this.info;
    }

    public String getName() {
        return this.info.getFile().getName();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        FileObject fileObject = FileUtil.toFileObject((File)this.info.getFile());
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (fileObject.equals(dataObject.getPrimaryFile())) {
                    return (T)dataObject.getCookie(clazz);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return (T)super.getCookie(clazz);
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty());
        set.put((Node.Property)new PathProperty());
        set.put((Node.Property)new StatusProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        if (this.isConflict()) {
            this.htmlDisplayName = this.conflictFormat.format(new Object[]{this.getName()});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Conflict");
        } else if (this.isRemoved()) {
            this.htmlDisplayName = this.removedFormat.format(new Object[]{this.getName()});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Removed");
        } else if (this.isMerged()) {
            this.htmlDisplayName = this.mergedFormat.format(new Object[]{this.getName()});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Merged");
        } else if (this.isUpdated()) {
            this.htmlDisplayName = this.getName();
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Updated");
        } else {
            throw new IllegalStateException("Unhandled update type: " + this.info.getType());
        }
        this.fireDisplayNameChange(this.htmlDisplayName, this.htmlDisplayName);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    private boolean isUpdated() {
        return "UP".indexOf(this.info.getType()) != -1;
    }

    private boolean isMerged() {
        return "G".equals(this.info.getType());
    }

    private boolean isRemoved() {
        return "Y".equals(this.info.getType());
    }

    private boolean isConflict() {
        return "C".equals(this.info.getType());
    }

    public void refresh() {
        this.refreshHtmlDisplayName();
    }

    private class NameProperty
    extends SyncFileProperty {
        public NameProperty() {
            super(UpdateResultNode.COLUMN_NAME_NAME, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Name_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Name_Desc"));
            this.setValue("sortkey", UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return UpdateResultNode.this.getDisplayName();
        }
    }

    private class PathProperty
    extends SyncFileProperty {
        private String shortPath;

        public PathProperty() {
            super(UpdateResultNode.COLUMN_NAME_PATH, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Path_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Path_Desc"));
            this.shortPath = Utils.getRelativePath(UpdateResultNode.this.info.getFile());
            this.setValue("sortkey", this.shortPath + "\t" + UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.shortPath;
        }
    }

    private class StatusProperty
    extends SyncFileProperty {
        public StatusProperty() {
            super(UpdateResultNode.COLUMN_NAME_STATUS, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Desc"));
            String string = Utils.getRelativePath(UpdateResultNode.this.info.getFile());
            String string2 = UpdateResultNode.this.info.getType();
            this.setValue("sortkey", UpdateResultNode.this.zeros[string2.length()] + string2 + "\t" + string + "\t" + UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return UpdateResultNode.this.statusDisplayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SyncFileProperty
    extends PropertySupport.ReadOnly<String> {
        protected SyncFileProperty(String string, Class<String> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                return (String)this.getValue();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return exception.getLocalizedMessage();
            }
        }
    }
}

