/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateResultNode;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.OpenInEditorAction;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.TableSorter;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

class UpdateResultsTable
implements MouseListener,
ListSelectionListener,
AncestorListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private UpdateResultNode[] nodes = new UpdateResultNode[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            Node.Property property = (Node.Property)object;
            Node.Property property2 = (Node.Property)object2;
            String string = (String)property.getValue("sortkey");
            if (string != null) {
                String string2 = (String)property2.getValue("sortkey");
                return string.compareToIgnoreCase(string2);
            }
            try {
                String string3 = (String)property.getValue();
                String string4 = (String)property2.getValue();
                return string3.compareToIgnoreCase(string4);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                return 0;
            }
        }
    };

    public UpdateResultsTable() {
        ResourceBundle resourceBundle = NbBundle.getBundle(UpdateResultsTable.class);
        this.columnLabels.put("name", new String[]{resourceBundle.getString("CTL_UpdateResults_Column_File_Title"), resourceBundle.getString("CTL_UpdateResults_Column_File_Desc")});
        this.columnLabels.put("status", new String[]{resourceBundle.getString("CTL_UpdateResults_Column_Status_Title"), resourceBundle.getString("CTL_UpdateResults_Column_Status_Desc")});
        this.columnLabels.put("path", new String[]{resourceBundle.getString("CTL_UpdateResults_Column_Path_Title"), resourceBundle.getString("CTL_UpdateResults_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable((TableModel)this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        int n = new JLabel((String)"FONTSIZE").getPreferredSize().height * 6 / 5;
        this.table.setRowHeight(n);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color color = UIManager.getColor("scrollpane_border");
        if (color == null) {
            color = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UpdateResultsTable.class, (String)"ACSN_UpdateResults"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateResultsTable.class, (String)"ACSD_UpdateResults"));
        this.setColumns(new String[]{"name", "status", "path"});
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = UpdateResultsTable.this.table.getWidth();
                for (int i = 0; i < UpdateResultsTable.this.tableColumns.length; ++i) {
                    if ("path".equals(UpdateResultsTable.this.tableColumns[i])) {
                        UpdateResultsTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 60 / 100);
                        continue;
                    }
                    UpdateResultsTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 20 / 100);
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public UpdateResultNode[] getDisplayedNodes() {
        int n = this.sorter.getRowCount();
        UpdateResultNode[] updateResultNodeArray = new UpdateResultNode[n];
        for (int i = 0; i < n; ++i) {
            updateResultNodeArray[i] = this.nodes[this.sorter.modelIndex(i)];
        }
        return updateResultNodeArray;
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] stringArray) {
        if (Arrays.equals(stringArray, this.tableColumns)) {
            return;
        }
        this.setDefaultColumnSizes();
        this.setModelProperties(stringArray);
        this.tableColumns = stringArray;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
    }

    private void setModelProperties(String[] stringArray) {
        Node.Property[] propertyArray = new Node.Property[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = this.columnLabels.get(string);
            propertyArray[i] = new ColumnDescriptor(string, String.class, stringArray2[0], stringArray2[1]);
        }
        this.tableModel.setProperties(propertyArray);
    }

    void setTableModel(UpdateResultNode[] updateResultNodeArray) {
        this.nodes = updateResultNodeArray;
        this.tableModel.setNodes((Node[])updateResultNodeArray);
    }

    void focus() {
        this.table.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            Action action = this.nodes[n = this.sorter.modelIndex(n)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ArrayList<UpdateResultNode> arrayList = new ArrayList<UpdateResultNode>();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (topComponent == null) {
            return;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        if (n == -1) {
            topComponent.setActivatedNodes(new Node[0]);
        }
        int n2 = listSelectionModel.getMaxSelectionIndex();
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            int n3 = this.sorter.modelIndex(i);
            arrayList.add(this.nodes[n3]);
        }
        topComponent.setActivatedNodes(arrayList.toArray(new Node[arrayList.size()]));
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component;
            Object object2;
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 0) {
                object2 = UpdateResultsTable.this.nodes[UpdateResultsTable.this.sorter.modelIndex(n)];
                if (!bl) {
                    object = "<html>" + object2.getHtmlDisplayName();
                }
            }
            if ((component = n3 == 2 ? this.pathRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JComponent) {
                object2 = UpdateResultsTable.this.nodes[UpdateResultsTable.this.sorter.modelIndex(n)].getInfo().getFile().getAbsolutePath();
                ((JComponent)component).setToolTipText((String)object2);
            }
            return component;
        }
    }
}

