/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffStreamSource;
import org.netbeans.modules.versioning.system.cvss.ui.history.DiffTreeTable;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffResultsView
implements AncestorListener,
PropertyChangeListener {
    private final SearchHistoryPanel parent;
    private DiffTreeTable treeView;
    private JSplitPane diffView;
    private ShowDiffTask currentTask;
    private RequestProcessor.Task currentShowDiffTask;
    private DiffView currentDiff;
    private int currentDifferenceIndex;
    private int currentIndex;
    private boolean dividerSet;
    private boolean onSelectionshowLastDifference;

    public DiffResultsView(SearchHistoryPanel searchHistoryPanel, List list) {
        this.parent = searchHistoryPanel;
        this.treeView = new DiffTreeTable();
        this.treeView.setResults(list);
        this.treeView.addAncestorListener(this);
        this.diffView = new JSplitPane(0);
        this.diffView.setTopComponent((Component)((Object)this.treeView));
        this.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions")));
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this.treeView));
        explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        if (!this.dividerSet) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffResultsView.this.dividerSet = true;
                    DiffResultsView.this.diffView.setDividerLocation(0.33);
                }
            });
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this.treeView));
        explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        this.cancelBackgroundTasks();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            final Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            this.currentDifferenceIndex = 0;
            if (nodeArray.length == 0) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            if (nodeArray.length > 2) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_TooManyRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    if (DiffResultsView.this.treeView.getSelection().length == 0) {
                        return;
                    }
                    SearchHistoryPanel.ResultsContainer resultsContainer = (SearchHistoryPanel.ResultsContainer)nodeArray[0].getLookup().lookup(SearchHistoryPanel.ResultsContainer.class);
                    SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)nodeArray[0].getLookup().lookup(SearchHistoryPanel.DispRevision.class);
                    try {
                        if (dispRevision == null || !dispRevision.isBranchRoot()) {
                            DiffResultsView.this.currentIndex = DiffResultsView.this.treeView.getSelection()[0];
                            if (nodeArray.length == 1) {
                                if (resultsContainer != null) {
                                    DiffResultsView.this.showContainerDiff(resultsContainer, DiffResultsView.this.onSelectionshowLastDifference);
                                } else if (dispRevision != null) {
                                    DiffResultsView.this.showRevisionDiff(dispRevision, DiffResultsView.this.onSelectionshowLastDifference);
                                }
                            } else if (nodeArray.length == 2) {
                                String string;
                                SearchHistoryPanel.DispRevision dispRevision2 = (SearchHistoryPanel.DispRevision)nodeArray[1].getLookup().lookup(SearchHistoryPanel.DispRevision.class);
                                if (dispRevision2.isBranchRoot()) {
                                    throw new Exception();
                                }
                                if (dispRevision2.getRevision().getLogInfoHeader() != dispRevision.getRevision().getLogInfoHeader()) {
                                    throw new Exception();
                                }
                                String string2 = dispRevision.getRevision().getNumber();
                                if (SearchHistoryPanel.compareRevisions(string2, string = dispRevision2.getRevision().getNumber()) == 1) {
                                    string = dispRevision.getRevision().getNumber();
                                    string2 = dispRevision2.getRevision().getNumber();
                                }
                                DiffResultsView.this.showDiff(dispRevision.getRevision().getLogInfoHeader(), string2, string, false);
                            }
                        } else {
                            DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
                        }
                    }
                    catch (Exception exception) {
                        DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
                        DiffResultsView.this.parent.refreshComponents(false);
                        return;
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void showDiffError(String string) {
        this.setBottomComponent((Component)new NoContentPanel(string));
    }

    private void setBottomComponent(Component component) {
        int n = this.diffView.getDividerLocation();
        this.diffView.setBottomComponent(component);
        this.diffView.setDividerLocation(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDiff(LogInformation logInformation, String string, String string2, boolean bl) {
        DiffResultsView diffResultsView = this;
        synchronized (diffResultsView) {
            this.cancelBackgroundTasks();
            this.currentTask = new ShowDiffTask(logInformation, string, string2, bl);
            this.currentShowDiffTask = RequestProcessor.getDefault().create((Runnable)this.currentTask);
            this.currentShowDiffTask.schedule(0);
        }
    }

    private synchronized void cancelBackgroundTasks() {
        if (this.currentShowDiffTask != null && !this.currentShowDiffTask.isFinished()) {
            this.currentShowDiffTask.cancel();
            this.currentTask.cancel();
        }
    }

    private void setDiffIndex(int n, boolean bl) {
        this.currentIndex = n;
        this.onSelectionshowLastDifference = bl;
        this.treeView.setSelection(n);
    }

    private void showRevisionDiff(SearchHistoryPanel.DispRevision dispRevision, boolean bl) {
        String string;
        String string2 = dispRevision.getRevision().getNumber();
        if (string2 == "") {
            SearchHistoryPanel.ResultsContainer resultsContainer = this.findParent(dispRevision);
            SearchHistoryPanel.DispRevision dispRevision2 = resultsContainer.getRevisions().get(1);
            string = dispRevision2.getRevision().getNumber();
        } else {
            string = Utils.previousRevision(string2);
        }
        this.showDiff(dispRevision.getRevision().getLogInfoHeader(), string, string2, bl);
    }

    private SearchHistoryPanel.ResultsContainer findParent(SearchHistoryPanel.DispRevision dispRevision) {
        List list = this.parent.getDispResults();
        for (Object e : list) {
            SearchHistoryPanel.ResultsContainer resultsContainer;
            if (!(e instanceof SearchHistoryPanel.ResultsContainer) || !(resultsContainer = (SearchHistoryPanel.ResultsContainer)e).getRevisions().contains(dispRevision)) continue;
            return resultsContainer;
        }
        return null;
    }

    private void showContainerDiff(SearchHistoryPanel.ResultsContainer resultsContainer, boolean bl) {
        List<SearchHistoryPanel.DispRevision> list = resultsContainer.getRevisions();
        SearchHistoryPanel.DispRevision dispRevision = list.get(1);
        this.showDiff(dispRevision.getRevision().getLogInfoHeader(), resultsContainer.getEldestRevision(), dispRevision.getRevision().getNumber(), bl);
    }

    void onNextButton() {
        if (this.currentDiff != null) {
            if (++this.currentDifferenceIndex >= this.currentDiff.getDifferenceCount()) {
                if (++this.currentIndex >= this.treeView.getRowCount()) {
                    this.currentIndex = 0;
                }
                this.setDiffIndex(this.currentIndex, false);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.treeView.getRowCount()) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, false);
        }
    }

    void onPrevButton() {
        if (this.currentDiff != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    this.currentIndex = this.treeView.getRowCount() - 1;
                }
                this.setDiffIndex(this.currentIndex, true);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.treeView.getRowCount() - 1;
            }
            this.setDiffIndex(this.currentIndex, true);
        }
    }

    boolean isNextEnabled() {
        if (this.currentDiff != null) {
            return this.currentIndex < this.treeView.getRowCount() - 1 || this.currentDifferenceIndex < this.currentDiff.getDifferenceCount() - 1;
        }
        return false;
    }

    boolean isPrevEnabled() {
        return this.currentIndex > 0 || this.currentDifferenceIndex > 0;
    }

    void select(SearchHistoryPanel.DispRevision dispRevision) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(dispRevision);
    }

    void select(SearchHistoryPanel.ResultsContainer resultsContainer) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(resultsContainer);
    }

    List<Object> getSelection() {
        Node[] nodeArray = ExplorerManager.find((Component)((Object)this.treeView)).getSelectedNodes();
        ArrayList<Object> arrayList = new ArrayList<Object>(nodeArray.length);
        for (Node node : nodeArray) {
            RevisionNode revisionNode = (RevisionNode)node;
            if (revisionNode.getContainer() != null) {
                arrayList.add(revisionNode.getContainer());
                continue;
            }
            arrayList.add(revisionNode.getDispRevision());
        }
        return arrayList;
    }

    JComponent getCurrentDiffComponent() {
        return (JComponent)(this.currentDiff == null ? null : this.currentDiff.getComponent());
    }

    public JComponent getComponent() {
        return this.diffView;
    }

    private class ShowDiffTask
    implements Runnable,
    Cancellable {
        private final LogInformation header;
        private final String revision1;
        private final String revision2;
        private boolean showLastDifference;
        private volatile boolean cancelled;
        private Thread thread;

        public ShowDiffTask(LogInformation logInformation, String string, String string2, boolean bl) {
            this.header = logInformation;
            this.revision1 = string;
            this.revision2 = string2;
            this.showLastDifference = bl;
        }

        public void run() {
            DiffResultsView.this.parent.getUndoRedo().setDiffView(null);
            this.thread = Thread.currentThread();
            final Diff diff = Diff.getDefault();
            final DiffStreamSource diffStreamSource = new DiffStreamSource(this.header.getFile(), this.revision1, this.revision1 == "" ? NbBundle.getMessage(DiffResultsView.class, (String)"LBL_DiffPanel_LocalCopy") : this.revision1);
            final DiffStreamSource diffStreamSource2 = new DiffStreamSource(this.header.getFile(), this.revision2, this.revision2 == "" ? NbBundle.getMessage(DiffResultsView.class, (String)"LBL_DiffPanel_LocalCopy") : this.revision2);
            diffStreamSource.getMIMEType();
            if (this.cancelled) {
                return;
            }
            diffStreamSource2.getMIMEType();
            if (this.cancelled) {
                return;
            }
            if (DiffResultsView.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (ShowDiffTask.this.cancelled) {
                            return;
                        }
                        DiffView diffView = diff.createDiff((StreamSource)diffStreamSource, (StreamSource)diffStreamSource2);
                        if (DiffResultsView.this.currentTask == ShowDiffTask.this) {
                            DiffResultsView.this.currentDiff = diffView;
                            DiffResultsView.this.parent.getUndoRedo().setDiffView((JComponent)DiffResultsView.this.currentDiff.getComponent());
                            DiffResultsView.this.setBottomComponent(DiffResultsView.this.currentDiff.getComponent());
                            if (DiffResultsView.this.currentDiff.getDifferenceCount() > 0) {
                                DiffResultsView.this.currentDifferenceIndex = ShowDiffTask.this.showLastDifference ? DiffResultsView.this.currentDiff.getDifferenceCount() - 1 : 0;
                                DiffResultsView.this.currentDiff.setCurrentDifference(DiffResultsView.this.currentDifferenceIndex);
                            }
                            DiffResultsView.this.parent.refreshComponents(false);
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
            });
        }

        public boolean cancel() {
            this.cancelled = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            return true;
        }
    }
}

