/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ViewRevisionPanel
extends JPanel {
    private final String VIEW_TRUNK_HEAD = "ViewRevisionPanel.ViewTrunkHEAD";
    private final String VIEW_BRANCH = "ViewRevisionPanel.ViewBranch";
    private final String VIEW_BRANCH_NAME = "ViewRevisionPanel.ViewBranchName";
    private final VCSContext ctx;
    private JButton bBrowse;
    private ButtonGroup buttonGroup1;
    private JRadioButton rbBranch;
    private JRadioButton rbTrunk;
    private JTextField tfTagName;

    public ViewRevisionPanel(VCSContext vCSContext) {
        this.ctx = vCSContext;
        this.initComponents();
        this.rbBranch.setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("ViewRevisionPanel.ViewBranch", true));
        this.rbTrunk.setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("ViewRevisionPanel.ViewTrunkHEAD", false));
        this.tfTagName.setText(CvsModuleConfig.getDefault().getPreferences().get("ViewRevisionPanel.ViewBranchName", ""));
        this.refreshComponents();
    }

    String getRevision() {
        return this.rbTrunk.isSelected() ? "HEAD" : this.tfTagName.getText();
    }

    void saveSettings() {
        CvsModuleConfig.getDefault().getPreferences().putBoolean("ViewRevisionPanel.ViewTrunkHEAD", this.rbTrunk.isSelected());
        CvsModuleConfig.getDefault().getPreferences().putBoolean("ViewRevisionPanel.ViewBranch", this.rbBranch.isSelected());
        CvsModuleConfig.getDefault().getPreferences().put("ViewRevisionPanel.ViewBranchName", this.tfTagName.getText());
    }

    void refreshComponents() {
        this.tfTagName.setEnabled(this.rbBranch.isSelected());
        this.bBrowse.setEnabled(this.rbBranch.isSelected());
    }

    private String browseBranches() {
        Set set = this.ctx.getRootFiles();
        for (File file : set) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(file));
                BranchSelector branchSelector = new BranchSelector();
                return branchSelector.selectTag(file);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.rbTrunk = new JRadioButton();
        this.rbBranch = new JRadioButton();
        this.tfTagName = new JTextField();
        this.bBrowse = new JButton();
        this.buttonGroup1.add(this.rbTrunk);
        Mnemonics.setLocalizedText((AbstractButton)this.rbTrunk, (String)NbBundle.getMessage(ViewRevisionPanel.class, (String)"ViewRevisionPanel.rbTrunk.text"));
        this.rbTrunk.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbTrunk.setMargin(new Insets(0, 0, 0, 0));
        this.rbTrunk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewRevisionPanel.this.rbTrunkActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.rbBranch);
        Mnemonics.setLocalizedText((AbstractButton)this.rbBranch, (String)NbBundle.getMessage(ViewRevisionPanel.class, (String)"ViewRevisionPanel.rbBranch.text"));
        this.rbBranch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbBranch.setMargin(new Insets(0, 0, 0, 0));
        this.rbBranch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewRevisionPanel.this.rbBranchActionPerformed(actionEvent);
            }
        });
        this.tfTagName.setText(NbBundle.getMessage(ViewRevisionPanel.class, (String)"ViewRevisionPanel.tfTagName.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(ViewRevisionPanel.class, (String)"ViewRevisionPanel.bBrowse.text"));
        this.bBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewRevisionPanel.this.bBrowseActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbBranch).addPreferredGap(0).add((Component)this.tfTagName, -1, 183, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bBrowse)).add((Component)this.rbTrunk)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.rbBranch).add((Component)this.bBrowse).add((Component)this.tfTagName, -2, -1, -2)).addPreferredGap(0).add((Component)this.rbTrunk).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void rbBranchActionPerformed(ActionEvent actionEvent) {
        this.refreshComponents();
    }

    private void rbTrunkActionPerformed(ActionEvent actionEvent) {
        this.refreshComponents();
    }

    private void bBrowseActionPerformed(ActionEvent actionEvent) {
        String string = this.browseBranches();
        if (string != null) {
            this.tfTagName.setText(string);
        }
    }
}

