/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.NbPreferences;

public class GlobalVisibilityQueryImpl
implements VisibilityQueryImplementation {
    static GlobalVisibilityQueryImpl INSTANCE;
    private final List listeners = new ArrayList();
    private static final String PROP_IGNORED_FILES = "IgnoredFiles";
    private static Method mIgnoredFiles;
    private Pattern ignoreFilesPattern = null;

    public GlobalVisibilityQueryImpl() {
        INSTANCE = this;
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/core");
    }

    public boolean isVisible(FileObject fileObject) {
        return this.isVisible(fileObject.getNameExt());
    }

    boolean isVisible(String string) {
        Pattern pattern = this.getIgnoreFilesPattern();
        return pattern != null ? !pattern.matcher(string).find() : true;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    private Pattern getIgnoreFilesPattern() {
        if (this.ignoreFilesPattern == null) {
            String string = this.getIgnoredFiles();
            this.ignoreFilesPattern = string != null && string.length() > 0 ? Pattern.compile(string) : null;
        }
        return this.ignoreFilesPattern;
    }

    protected String getIgnoredFiles() {
        String string = GlobalVisibilityQueryImpl.getPreferences().get(PROP_IGNORED_FILES, "^(CVS|SCCS|vssver\\.scc|#.*#|%.*%|\\.(cvsignore|svn|DS_Store)|_svn)$|~$|^\\..*$");
        GlobalVisibilityQueryImpl.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if (GlobalVisibilityQueryImpl.PROP_IGNORED_FILES.equals(preferenceChangeEvent.getKey())) {
                    GlobalVisibilityQueryImpl.this.ignoreFilesPattern = null;
                    GlobalVisibilityQueryImpl.this.fireChange();
                }
            }
        });
        return string;
    }
}

