/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class MasterURLMapper
extends URLMapper {
    public FileObject[] getFileObjects(URL uRL) {
        MasterFileSystem masterFileSystem = MasterFileSystem.getDefault();
        if (!uRL.getProtocol().equals("file")) {
            return null;
        }
        FileObject fileObject = null;
        String string = null;
        try {
            string = FileUtil.normalizeFile((File)new File(new URI(uRL.toExternalForm()))).getAbsolutePath();
        }
        catch (URISyntaxException uRISyntaxException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(uRISyntaxException.getLocalizedMessage()).append(" [").append(uRL.toExternalForm()).append(']');
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
            if (Utilities.isWindows() && uRL.getAuthority() != null) {
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)"; might be because your user directory is on a Windows UNC path (issue #46813)? If so, try using mapped drive letters.");
            }
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
            return null;
        }
        fileObject = masterFileSystem.findResource(string);
        if (!(fileObject instanceof MasterFileObject)) {
            return null;
        }
        if (!fileObject.isValid()) {
            return null;
        }
        return new FileObject[]{fileObject};
    }

    public URL getURL(FileObject fileObject, int n) {
        if (n == 2 || !(fileObject instanceof MasterFileObject)) {
            return null;
        }
        MasterFileObject masterFileObject = (MasterFileObject)fileObject;
        File file = masterFileObject != null ? masterFileObject.getResource().getFile() : null;
        try {
            return file != null ? MasterURLMapper.fileToURL(file, fileObject) : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static boolean isWindowsDriveRoot(File file) {
        return (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && file.getParent() == null;
    }

    static URL fileToURL(File file, FileObject fileObject) throws MalformedURLException {
        URL uRL = null;
        if (MasterURLMapper.isWindowsDriveRoot(file)) {
            uRL = new URL("file:/" + file.getAbsolutePath());
        } else {
            String string;
            String string2;
            if (fileObject.isFolder() && (!fileObject.isValid() || fileObject.isVirtual()) && !(string2 = file.toURI().toURL().toExternalForm()).endsWith(string = "/")) {
                uRL = new URL(string2 + string);
            }
            uRL = uRL == null ? file.toURI().toURL() : uRL;
        }
        return uRL;
    }
}

