/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.ReplaceForSerialization;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLock;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.Attributes;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;

public abstract class BaseFileObj
extends FileObject {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNC_PREFIX = '\\';
    private static final String PATH_SEPARATOR = "/";
    private static final char EXT_SEP = '.';
    static final long serialVersionUID = -1244650210876356809L;
    static final Attributes attribs;
    private EventListenerList eventSupport;
    private final FileNaming fileName;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BaseFileObj(File file) {
        this.fileName = NamingFactory.fromFile(file);
    }

    protected BaseFileObj(File file, FileNaming fileNaming) {
        this.fileName = fileNaming;
    }

    public final String toString() {
        return this.getFileName().toString();
    }

    public final String getNameExt() {
        File file = this.getFileName().getFile();
        String string = BaseFileObj.getNameExt(file);
        return string;
    }

    static String getNameExt(File file) {
        String string;
        String string2 = string = file.getParentFile() == null ? file.getAbsolutePath() : file.getName();
        if (string.endsWith(String.valueOf('\\')) || string.endsWith(PATH_SEPARATOR)) {
            boolean bl;
            if (!$assertionsDisabled && file.getParentFile() != null) {
                throw new AssertionError((Object)(file.getAbsolutePath() + " exists: " + file.exists()));
            }
            boolean bl2 = bl = file.getParentFile() != null || !new FileInfo(file).isUNCFolder();
            if (bl) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public final String getName() {
        return FileInfo.getName(this.getNameExt());
    }

    public final String getExt() {
        return FileInfo.getExt(this.getNameExt());
    }

    public final String getPath() {
        return this.isRoot() ? "" : this.getFileName().getFile().getAbsolutePath().replace('\\', '/');
    }

    public final FileSystem getFileSystem() throws FileStateInvalidException {
        return this.getLocalFileSystem();
    }

    public final boolean isRoot() {
        return false;
    }

    public void move(FileLock fileLock, FolderObj folderObj, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        iOHandler.handle();
        String string3 = FileInfo.composeName(string, string2);
        folderObj.getChildrenCache().getChild(string3, true);
        BaseFileObj baseFileObj = (BaseFileObj)FileBasedFileSystem.getFileObject(new File(folderObj.getFileName().getFile(), string3));
        if (!$assertionsDisabled && baseFileObj == null) {
            throw new AssertionError();
        }
        baseFileObj.fireFileDataCreatedEvent(false);
        this.fireFileDeletedEvent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(FileLock fileLock, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        Object object;
        String string3;
        Object object2;
        if (!this.checkLock(fileLock)) {
            FSException.io("EXC_InvalidLock", fileLock, this.getPath());
        }
        File file = this.getFileName().getFile();
        File file2 = file.getParentFile();
        File file3 = BaseFileObj.getFile(file2, string, string2);
        if (file2 == null || !file2.exists()) {
            object2 = this.getExistingParent();
            string3 = object2 != null ? object2.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), string3, file3.getName());
        }
        if (file3.exists() && !file3.equals(file)) {
            object2 = this.getExistingParent();
            string3 = object2 != null ? object2.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), string3, file3.getName());
        }
        object2 = this.getName();
        string3 = this.getExt();
        FileNaming[] fileNamingArray = NamingFactory.rename(this.getFileName(), file3.getName(), iOHandler);
        if (fileNamingArray == null) {
            object = this.getExistingParent();
            String string4 = object != null ? object.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), string4, file3.getName());
        }
        object = this.getLocalFileSystem();
        ((FileBasedFileSystem)((Object)object)).getFactory().rename();
        attribs.renameAttributes(file.getAbsolutePath().replace('\\', '/'), file3.getAbsolutePath().replace('\\', '/'));
        for (int i = 0; i < fileNamingArray.length; ++i) {
            Mutex.Privileged privileged;
            FolderObj folderObj;
            FolderObj folderObj2 = folderObj = fileNamingArray[i].getParent() != null ? (FolderObj)((FileBasedFileSystem)((Object)object)).getFactory().get(fileNamingArray[i].getParent().getFile()) : null;
            if (folderObj == null) continue;
            ChildrenCache childrenCache = folderObj.getChildrenCache();
            Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
            if (privileged != null) {
                privileged.enterWriteAccess();
            }
            try {
                childrenCache.removeChild(fileNamingArray[i]);
                childrenCache.getChild(fileNamingArray[i].getName(), true);
                continue;
            }
            finally {
                if (privileged != null) {
                    privileged.exitWriteAccess();
                }
            }
        }
        WriteLock.relock(file, file3);
        this.fireFileRenamedEvent((String)object2, string3);
    }

    public final void rename(FileLock fileLock, String string, String string2) throws IOException {
        this.rename(fileLock, string, string2, null);
    }

    public Object getAttribute(String string) {
        return attribs.readAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string);
    }

    public final void setAttribute(String string, Object object) throws IOException {
        Object object2 = attribs.readAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string);
        attribs.writeAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), string, object);
        this.fireFileAttributeChangedEvent(string, object2, object);
    }

    public final Enumeration getAttributes() {
        return attribs.attributes(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'));
    }

    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getEventSupport().add(FileChangeListener.class, fileChangeListener);
    }

    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getEventSupport().remove(FileChangeListener.class, fileChangeListener);
    }

    private Enumeration getListeners() {
        if (this.eventSupport == null) {
            return Enumerations.empty();
        }
        return Enumerations.array((Object[])this.getEventSupport().getListeners(FileChangeListener.class));
    }

    public final long getSize() {
        return this.getFileName().getFile().length();
    }

    public final void setImportant(boolean bl) {
    }

    public boolean isReadOnly() {
        File file = this.getFileName().getFile();
        return !file.canWrite() && file.exists();
    }

    public final FileObject getParent() {
        FileObject fileObject;
        FileNaming fileNaming = this.getFileName().getParent();
        if (fileNaming != null) {
            FileBasedFileSystem fileBasedFileSystem = this.getLocalFileSystem();
            File file = fileNaming.getFile();
            fileObject = fileBasedFileSystem.getFactory().get(file);
            fileObject = fileObject == null ? fileBasedFileSystem.findFileObject(file) : fileObject;
        } else {
            fileObject = this.getLocalFileSystem().getRoot();
        }
        return fileObject;
    }

    static File getFile(File file, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append('.');
            stringBuffer.append(string2);
        }
        File file2 = new File(file, stringBuffer.toString());
        return file2;
    }

    final FileBasedFileSystem getLocalFileSystem() {
        return FileBasedFileSystem.getInstance(this.getFileName().getFile());
    }

    final void fireFileDataCreatedEvent(boolean bl) {
        Enumeration enumeration;
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration enumeration2 = enumeration = folderObj != null ? super.getListeners() : null;
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)this.toString());
        }
        this.fireFileDataCreatedEvent(this.getListeners(), new FileEvent((FileObject)this, (FileObject)this, bl));
        if (folderObj != null && enumeration != null) {
            if (!$assertionsDisabled && !folderObj.isValid()) {
                throw new AssertionError((Object)folderObj.toString());
            }
            folderObj.fireFileDataCreatedEvent(enumeration, new FileEvent((FileObject)folderObj, (FileObject)this, bl));
        }
        stopWatch.stop();
    }

    final void fireFileFolderCreatedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration enumeration = folderObj != null ? super.getListeners() : null;
        this.fireFileFolderCreatedEvent(this.getListeners(), new FileEvent((FileObject)this, (FileObject)this, bl));
        if (folderObj != null && enumeration != null) {
            folderObj.fireFileFolderCreatedEvent(enumeration, new FileEvent((FileObject)folderObj, (FileObject)this, bl));
        }
        stopWatch.stop();
    }

    FolderObj getExistingParent() {
        File file = this.getFileName().getParent() == null ? null : this.getFileName().getParent().getFile();
        FolderObj folderObj = file == null ? null : (FolderObj)this.getLocalFileSystem().getFactory().get(file);
        return folderObj;
    }

    public final void fireFileChangedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FileObject fileObject = this.getParent();
        BaseFileObj baseFileObj = (BaseFileObj)((Object)(fileObject instanceof BaseFileObj ? fileObject : null));
        Enumeration enumeration = baseFileObj != null ? baseFileObj.getListeners() : null;
        this.fireFileChangedEvent(this.getListeners(), new FileEvent((FileObject)this, (FileObject)this, bl));
        if (baseFileObj != null && enumeration != null) {
            baseFileObj.fireFileChangedEvent(enumeration, new FileEvent((FileObject)baseFileObj, (FileObject)this, bl));
        }
        stopWatch.stop();
    }

    final void fireFileDeletedEvent(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FileObject fileObject = this.getParent();
        BaseFileObj baseFileObj = (BaseFileObj)((Object)(fileObject instanceof BaseFileObj ? fileObject : null));
        Enumeration enumeration = baseFileObj != null ? baseFileObj.getListeners() : null;
        this.fireFileDeletedEvent(this.getListeners(), new FileEvent((FileObject)this, (FileObject)this, bl));
        if (baseFileObj != null && enumeration != null) {
            baseFileObj.fireFileDeletedEvent(enumeration, new FileEvent((FileObject)baseFileObj, (FileObject)this, bl));
        }
        stopWatch.stop();
    }

    private void fireFileRenamedEvent(String string, String string2) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj folderObj = this.getExistingParent();
        Enumeration enumeration = folderObj != null ? super.getListeners() : null;
        this.fireFileRenamedEvent(this.getListeners(), new FileRenameEvent((FileObject)this, string, string2));
        if (folderObj != null && enumeration != null) {
            folderObj.fireFileRenamedEvent(enumeration, new FileRenameEvent((FileObject)folderObj, (FileObject)this, string, string2));
        }
        stopWatch.stop();
    }

    private void fireFileAttributeChangedEvent(String string, Object object, Object object2) {
        FolderObj folderObj = this.getExistingParent();
        Enumeration enumeration = folderObj != null ? super.getListeners() : null;
        this.fireFileAttributeChangedEvent(this.getListeners(), new FileAttributeEvent((FileObject)this, (FileObject)this, string, object, object2));
        if (folderObj != null && enumeration != null) {
            folderObj.fireFileAttributeChangedEvent(enumeration, new FileAttributeEvent((FileObject)folderObj, (FileObject)this, string, object, object2));
        }
    }

    public final FileNaming getFileName() {
        return this.fileName;
    }

    public final void delete(FileLock fileLock) throws IOException {
        this.delete(fileLock, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileLock fileLock, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        Mutex.Privileged privileged;
        File file = this.getFileName().getFile();
        FolderObj folderObj = this.getExistingParent();
        ChildrenCache childrenCache = folderObj != null ? folderObj.getChildrenCache() : null;
        Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
        if (privileged != null) {
            privileged.enterWriteAccess();
        }
        try {
            boolean bl;
            if (!this.checkLock(fileLock)) {
                FSException.io("EXC_InvalidLock", fileLock, this.getPath());
            }
            boolean bl2 = bl = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
            if (!bl) {
                FolderObj folderObj2 = this.getExistingParent();
                String string = folderObj2 != null ? folderObj2.getPath() : file.getParentFile().getAbsolutePath();
                FSException.io("EXC_CannotDelete", file.getName(), string);
            }
            attribs.deleteAttributes(file.getAbsolutePath().replace('\\', '/'));
            if (childrenCache != null) {
                if (deleteHandler != null) {
                    childrenCache.removeChild(this.getFileName());
                } else {
                    childrenCache.getChild(BaseFileObj.getNameExt(file), true);
                }
            }
        }
        finally {
            if (privileged != null) {
                privileged.exitWriteAccess();
            }
            this.setValid(false);
        }
        this.fireFileDeletedEvent(false);
    }

    abstract boolean checkLock(FileLock var1) throws IOException;

    public Object writeReplace() {
        return new ReplaceForSerialization(this.getFileName().getFile());
    }

    protected abstract void setValid(boolean var1);

    public abstract void refresh(boolean var1, boolean var2);

    private synchronized EventListenerList getEventSupport() {
        if (this.eventSupport == null) {
            this.eventSupport = new EventListenerList();
        }
        return this.eventSupport;
    }

    static {
        $assertionsDisabled = !BaseFileObj.class.desiredAssertionStatus();
        BridgeForAttributes bridgeForAttributes = new BridgeForAttributes();
        attribs = new Attributes(bridgeForAttributes, bridgeForAttributes, bridgeForAttributes);
    }

    private static final class BridgeForAttributes
    implements AbstractFileSystem.List,
    AbstractFileSystem.Change,
    AbstractFileSystem.Info {
        private BridgeForAttributes() {
        }

        public final Date lastModified(String string) {
            File file = new File(string);
            return new Date(file.lastModified());
        }

        public final boolean folder(String string) {
            File file = new File(string);
            return file.isDirectory();
        }

        public final boolean readOnly(String string) {
            File file = new File(string);
            return !file.canWrite();
        }

        public final String mimeType(String string) {
            return "content/unknown";
        }

        public final long size(String string) {
            File file = new File(string);
            return file.length();
        }

        public final InputStream inputStream(String string) throws FileNotFoundException {
            File file = new File(string);
            return new FileInputStream(file);
        }

        public final OutputStream outputStream(String string) throws IOException {
            File file = new File(string);
            return new FileOutputStream(file);
        }

        public final void lock(String string) throws IOException {
        }

        public final void unlock(String string) {
        }

        public final void markUnimportant(String string) {
        }

        public final String[] children(String string) {
            File file = new File(string);
            return file.list();
        }

        public final void createFolder(String string) throws IOException {
            File file = new File(string);
            if (!file.mkdirs()) {
                IOException iOException = new IOException(string);
                throw iOException;
            }
        }

        public final void createData(String string) throws IOException {
            File file = new File(string);
            if (!file.createNewFile()) {
                throw new IOException(string);
            }
        }

        public final void rename(String string, String string2) throws IOException {
            File file = new File(string);
            File file2 = new File(string2);
            if (!file.renameTo(file2)) {
                FSException.io("EXC_CannotRename", file.getName(), "", file2.getName());
            }
        }

        public final void delete(String string) throws IOException {
            boolean bl;
            File file = new File(string);
            boolean bl2 = bl = file.isFile() ? file.delete() : this.deleteFolder(file);
            if (bl) {
                FSException.io("EXC_CannotDelete", file.getName(), "");
            }
        }

        private boolean deleteFolder(File file) throws IOException {
            boolean bl = file.delete();
            if (bl) {
                return true;
            }
            if (!file.exists()) {
                return false;
            }
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (this.deleteFolder(file2)) continue;
                    return false;
                }
            }
            return file.delete();
        }
    }
}

