/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

final class ExternalUtil {
    private static Repository repository;
    private static Logger LOG;

    ExternalUtil() {
    }

    public static Repository getRepository() {
        ExternalUtil.initialize();
        return repository;
    }

    public static void exception(Exception exception) {
        Logger.getLogger(ExternalUtil.class.getName()).log(Level.WARNING, null, exception);
    }

    public static Throwable copyAnnotation(Throwable throwable, Throwable throwable2) {
        return throwable.initCause(throwable2);
    }

    public static void annotate(Throwable throwable, String string) {
        Exceptions.attachLocalizedMessage((Throwable)throwable, (String)string);
    }

    public static Throwable annotate(Throwable throwable, Throwable throwable2) {
        Throwable throwable3 = throwable;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        throwable.initCause(throwable2);
        return throwable3;
    }

    public static void log(String string) {
        LOG.fine(string);
    }

    public static Class findClass(String string) throws ClassNotFoundException {
        ExternalUtil.initialize();
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            return Class.forName(string);
        }
        return Class.forName(string, true, classLoader);
    }

    private static void initialize() {
        if (!ExternalUtil.isInitialized()) {
            Lookup lookup = Lookup.getDefault();
            Repository repository = (Repository)lookup.lookup(Repository.class);
            ExternalUtil.setRepository(repository);
        }
    }

    private static synchronized boolean isInitialized() {
        return repository != null;
    }

    private static synchronized void setRepository(Repository repository) {
        ExternalUtil.repository = repository;
        if (ExternalUtil.repository == null) {
            ExternalUtil.repository = new Repository(new MainFS());
        }
    }

    static {
        LOG = Logger.getLogger("org.openide.filesystems");
    }

    private static final class MainFS
    extends MultiFileSystem
    implements LookupListener {
        private static final Lookup.Result<FileSystem> ALL = Lookup.getDefault().lookupResult(FileSystem.class);
        private static final FileSystem MEMORY = FileUtil.createMemoryFileSystem();

        public MainFS() {
            ALL.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        private static FileSystem[] computeDelegates() {
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
            arrayList.add(MEMORY);
            arrayList.addAll(ALL.allInstances());
            return arrayList.toArray(new FileSystem[0]);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.setDelegates(MainFS.computeDelegates());
        }
    }
}

