/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import java.util.regex.Pattern;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class Copy {
    private int maxItems;
    private int items;
    private int timeDev;

    Copy() {
    }

    public static void copyDeep(FileObject fileObject, FileObject fileObject2, Set set) throws IOException {
        Copy.copyDeep(fileObject, fileObject2, set, null);
    }

    private static void copyDeep(FileObject fileObject, FileObject fileObject2, Set set, String string) throws IOException {
        FileObject fileObject3 = string == null ? fileObject : FileUtil.createFolder((FileObject)fileObject, (String)string);
        FileObject[] fileObjectArray = fileObject3.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject4;
            String string2 = string == null ? fileObjectArray[i].getNameExt() : string + "/" + fileObjectArray[i].getNameExt();
            if (fileObjectArray[i].isData() && !set.contains(string2)) continue;
            if (fileObjectArray[i].isFolder()) {
                Copy.copyDeep(fileObject, fileObject2, set, string2);
                if (!set.contains(string2) || !fileObjectArray[i].getAttributes().hasMoreElements()) continue;
                fileObject4 = FileUtil.createFolder((FileObject)fileObject2, (String)string2);
                FileUtil.copyAttributes((FileObject)fileObjectArray[i], (FileObject)fileObject4);
                continue;
            }
            fileObject4 = string == null ? fileObject2 : FileUtil.createFolder((FileObject)fileObject2, (String)string);
            FileObject fileObject5 = fileObject4.getFileObject(fileObjectArray[i].getNameExt());
            try {
                if (fileObject5 == null) {
                    fileObject5 = FileUtil.copyFile((FileObject)fileObjectArray[i], (FileObject)fileObject4, (String)fileObjectArray[i].getName(), (String)fileObjectArray[i].getExt());
                }
            }
            catch (IOException iOException) {
                if (fileObjectArray[i].getNameExt().endsWith("_hidden")) continue;
                throw iOException;
            }
            FileUtil.copyAttributes((FileObject)fileObjectArray[i], (FileObject)fileObject5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void appendSelectedLines(File var0, File var1_1, String[] var2_2) throws IOException {
        if (!var0.exists()) {
            return;
        }
        var3_3 = new Pattern[var2_2.length];
        for (var4_4 = 0; var4_4 < var3_3.length; ++var4_4) {
            var3_3[var4_4] = Pattern.compile(var2_2[var4_4]);
        }
        var4_5 = new ByteArrayOutputStream();
        var5_6 = new File(var1_1, var0.getName());
        if (!var1_1.exists()) {
            var1_1.mkdirs();
        }
        if (!Copy.$assertionsDisabled && !var1_1.exists()) {
            throw new AssertionError();
        }
        if (!var5_6.exists()) {
            var5_6.createNewFile();
        } else {
            var6_7 = new FileInputStream(var5_6);
            try {
                FileUtil.copy((InputStream)var6_7, (OutputStream)var4_5);
            }
            finally {
                var6_7.close();
            }
        }
        if (!Copy.$assertionsDisabled && !var5_6.exists()) {
            throw new AssertionError();
        }
        var6_7 = null;
        var7_9 = new BufferedReader(new FileReader(var0));
lbl30:
        // 2 sources

        try {
            block10: while ((var6_7 = var7_9.readLine()) != null) {
                block21: {
                    if (var3_3 == null) break block21;
                    for (var8_10 = 0; var8_10 < var3_3.length; ++var8_10) {
                        var9_12 = var3_3[var8_10].matcher((CharSequence)var6_7);
                        if (!var9_12.matches()) continue;
                        var4_5.write(var6_7.getBytes());
                        var4_5.write(10);
                        continue block10;
                    }
                    ** GOTO lbl30
                }
                var4_5.write(var6_7.getBytes());
                var4_5.write(10);
            }
        }
        finally {
            var7_9.close();
        }
        var8_11 = new ByteArrayInputStream(var4_5.toByteArray());
        var9_12 = new FileOutputStream(var5_6);
        try {
            FileUtil.copy((InputStream)var8_11, (OutputStream)var9_12);
        }
        finally {
            var8_11.close();
            var9_12.close();
        }
    }

    private void recursiveCopy(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject3 = fileObjectArray[i];
            FileObject fileObject4 = null;
            if (fileObject3.isFolder()) {
                fileObject4 = fileObject2.getFileObject(fileObject3.getName());
                if (fileObject4 == null) {
                    fileObject4 = fileObject2.createFolder(fileObject3.getName());
                }
                Copy.copyAttributes(fileObject3, fileObject4);
                this.recursiveCopy(fileObject3, fileObject4);
                continue;
            }
            fileObject4 = fileObject2.getFileObject(fileObject3.getNameExt());
            if (fileObject4 == null) {
                fileObject4 = Utilities.getOperatingSystem() == 16384 && fileObject3.getNameExt().equalsIgnoreCase("_nbattrs.") ? FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)fileObject3.getNameExt(), (String)fileObject3.getExt()) : FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)fileObject3.getName(), (String)fileObject3.getExt());
            }
            Copy.copyAttributes(fileObject3, fileObject4);
        }
    }

    private void message(String string) {
    }

    private void progress(int n, int n2) {
    }

    private void recursiveCopyWithFilter(FileObject fileObject, FileObject fileObject2, Object[] objectArray, long l) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (!fileObject.isFolder()) {
            this.message(Copy.getString("MSG_IS_NOT_FOLDER", fileObject.getName()));
        }
        this.maxItems += fileObjectArray.length;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject3 = fileObjectArray[i];
            ++this.items;
            this.progress(this.items, this.maxItems);
            if (!this.canCopy(fileObject3, objectArray, l)) continue;
            FileObject fileObject4 = null;
            if (fileObject3.isFolder()) {
                fileObject4 = fileObject2.getFileObject(fileObject3.getNameExt());
                if (fileObject4 == null) {
                    fileObject4 = fileObject2.createFolder(fileObject3.getNameExt());
                }
                Copy.copyAttributes(fileObject3, fileObject4);
                this.recursiveCopyWithFilter(fileObject3, fileObject4, objectArray, l);
                continue;
            }
            fileObject4 = fileObject2.getFileObject(fileObject3.getName(), fileObject3.getExt());
            if (fileObject4 != null) {
                FileLock fileLock = fileObject4.lock();
                fileObject4.delete(fileLock);
                fileLock.releaseLock();
            }
            fileObject4 = Utilities.getOperatingSystem() == 16384 && fileObject3.getNameExt().equalsIgnoreCase("_nbattrs.") ? this.copyFile(fileObject3, fileObject2, fileObject3.getNameExt()) : this.copyFile(fileObject3, fileObject2, fileObject3.getName());
            Copy.copyAttributes(fileObject3, fileObject4);
        }
    }

    private FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        return FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string);
    }

    private static void copyAttributes(FileObject fileObject, FileObject fileObject2) throws IOException {
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = fileObject.getAttribute(string);
            if (object == null) continue;
            fileObject2.setAttribute(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCopy(FileObject fileObject, Object[] objectArray, long l) throws IOException {
        boolean bl;
        Object[] objectArray2 = (String[])objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        String string = fileObject.getPath();
        if (fileObject.isFolder()) {
            return Arrays.binarySearch(objectArray2, string + "/*") < 0;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return false;
        }
        long l2 = fileObject.lastModified().getTime();
        boolean bl2 = bl = Arrays.binarySearch(objectArray2, string) < 0 && l + (long)this.timeDev <= l2;
        if (!bl) {
            return false;
        }
        if (fileObject.getExt().equals("settings")) {
            boolean bl3 = false;
            boolean bl4 = false;
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
                while (null != (string2 = bufferedReader.readLine())) {
                    if (string2.indexOf("<module name=") != -1) {
                        if (string2.indexOf("<module name=\"org.netbeans.modules.java/1\"") == -1) break;
                        bl3 = true;
                    }
                    if (string2.indexOf("<serialdata class=") == -1) continue;
                    if (string2.indexOf("<serialdata class=\"org.netbeans.modules.java.FastJavacCompilerType\">") != -1) {
                        bl4 = true;
                        if (!bl3) continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            if (bl3 && bl4) {
                return false;
            }
        }
        return true;
    }

    public static String getIdeVersion(File file) {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        if (new File(file, "system").exists()) {
            return "3.6";
        }
        return null;
    }

    protected static String getString(String string) {
        return NbBundle.getMessage(Copy.class, (String)string);
    }

    protected static String getString(String string, String string2) {
        return NbBundle.getMessage(Copy.class, (String)string, (Object)string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttrslessLocalFileSystem
    extends AbstractFileSystem
    implements AbstractFileSystem.Attr {
        public AttrslessLocalFileSystem(LocalFileSystem localFileSystem) {
            this.change = new LocalFileSystem.Impl(localFileSystem);
            this.info = (AbstractFileSystem.Info)this.change;
            this.list = (AbstractFileSystem.List)this.change;
            this.attr = this;
        }

        public boolean isReadOnly() {
            return false;
        }

        public String getDisplayName() {
            return ((Object)((Object)this)).getClass().toString();
        }

        public void deleteAttributes(String string) {
        }

        public Enumeration<String> attributes(String string) {
            return Enumerations.empty();
        }

        public void renameAttributes(String string, String string2) {
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
        }

        public Object readAttribute(String string, String string2) {
            return null;
        }
    }
}

