/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class LibraryManager {
    public static final String PROP_LIBRARIES = "libraries";
    private static LibraryManager instance;
    private Lookup.Result<LibraryProvider> result;
    private Collection<LibraryProvider> currentStorages = new ArrayList<LibraryProvider>();
    private PropertyChangeListener plistener;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Collection<Library> cache;

    private LibraryManager() {
    }

    public Library getLibrary(String string) {
        assert (string != null);
        Library[] libraryArray = this.getLibraries();
        for (int i = 0; i < libraryArray.length; ++i) {
            if (!string.equals(libraryArray[i].getName())) continue;
            return libraryArray[i];
        }
        return null;
    }

    public synchronized Library[] getLibraries() {
        if (this.cache == null) {
            if (this.result == null) {
                this.plistener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        LibraryManager.this.resetCache();
                    }
                };
                this.result = Lookup.getDefault().lookupResult(LibraryProvider.class);
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        LibraryManager.this.resetCache();
                    }
                });
            }
            ArrayList<Library> arrayList = new ArrayList<Library>();
            Collection collection = this.result.allInstances();
            HashSet hashSet = new HashSet(collection);
            hashSet.removeAll(this.currentStorages);
            HashSet<LibraryProvider> hashSet2 = new HashSet<LibraryProvider>(this.currentStorages);
            hashSet2.removeAll(collection);
            this.currentStorages.clear();
            for (LibraryProvider libraryProvider : collection) {
                this.currentStorages.add(libraryProvider);
                for (LibraryImplementation libraryImplementation : libraryProvider.getLibraries()) {
                    arrayList.add(LibraryFactory.createLibrary(libraryImplementation));
                }
            }
            for (LibraryProvider libraryProvider : hashSet2) {
                libraryProvider.removePropertyChangeListener(this.plistener);
            }
            for (LibraryProvider libraryProvider : hashSet) {
                libraryProvider.addPropertyChangeListener(this.plistener);
            }
            this.cache = arrayList;
        }
        return this.cache.toArray(new Library[this.cache.size()]);
    }

    public void addLibrary(Library library) throws IOException, IllegalArgumentException {
        assert (library != null);
        if (LibrariesSupport.getLibraryTypeProvider(library.getType()) == null) {
            throw new IllegalArgumentException("Trying to add a library of unknown type: " + library.getType());
        }
        String string = library.getName();
        if (string == null || this.getLibrary(string) != null) {
            throw new IllegalArgumentException("Library hasn't name or the name is already used: " + string);
        }
        Collection collection = Lookup.getDefault().lookupAll(WritableLibraryProvider.class);
        assert (collection.size() == 1);
        ((WritableLibraryProvider)collection.iterator().next()).addLibrary(library.getLibraryImplementation());
    }

    public void removeLibrary(Library library) throws IOException, IllegalArgumentException {
        assert (library != null);
        Collection collection = Lookup.getDefault().lookupAll(WritableLibraryProvider.class);
        assert (collection.size() == 1);
        ((WritableLibraryProvider)collection.iterator().next()).removeLibrary(library.getLibraryImplementation());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (propertyChangeListener != null);
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (propertyChangeListener != null);
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    private synchronized void resetCache() {
        this.cache = null;
        this.listeners.firePropertyChange(PROP_LIBRARIES, null, null);
    }

    public static synchronized LibraryManager getDefault() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }
}

