/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.project.libraries.LibraryImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultLibraryImplementation
implements LibraryImplementation {
    private String description;
    private Map<String, List<URL>> contents;
    private String name;
    private String libraryType;
    private String localizingBundle;
    private List<PropertyChangeListener> listeners;

    public DefaultLibraryImplementation(String string, String[] stringArray) {
        assert (string != null && stringArray != null);
        this.libraryType = string;
        this.contents = new HashMap<String, List<URL>>();
        for (String string2 : stringArray) {
            this.contents.put(string2, Collections.emptyList());
        }
    }

    @Override
    public String getType() {
        return this.libraryType;
    }

    @Override
    public void setName(String string) throws UnsupportedOperationException {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange("name", string2, this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<URL> getContent(String string) throws IllegalArgumentException {
        List<URL> list = this.contents.get(string);
        if (list == null) {
            throw new IllegalArgumentException();
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public void setContent(String string, List<URL> list) throws IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        if (!this.contents.keySet().contains(string)) {
            throw new IllegalArgumentException("Volume '" + string + "' is not support by this library. The only acceptable values are: " + this.contents.keySet());
        }
        this.contents.put(string, new ArrayList<URL>(list));
        this.firePropertyChange("content", null, null);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.firePropertyChange("description", string2, this.description);
    }

    @Override
    public String getLocalizingBundle() {
        return this.localizingBundle;
    }

    @Override
    public void setLocalizingBundle(String string) {
        this.localizingBundle = string;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(propertyChangeListener);
    }

    public String toString() {
        return "LibraryImplementation[Name=" + this.name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String string, Object object, Object object2) {
        ArrayList<PropertyChangeListener> arrayList;
        Object object3 = this;
        synchronized (object3) {
            if (this.listeners == null) {
                return;
            }
            arrayList = new ArrayList<PropertyChangeListener>(this.listeners);
        }
        object3 = new PropertyChangeEvent(this, string, object, object2);
        for (PropertyChangeListener propertyChangeListener : arrayList) {
            propertyChangeListener.propertyChange((PropertyChangeEvent)object3);
        }
    }
}

