/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.lib.editor.bookmarks.actions.BookmarksKitInstallAction;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.bookmarks.PersistentBookmarks;
import org.openide.modules.ModuleInstall;

public class EditorBookmarksModule
extends ModuleInstall {
    private PropertyChangeListener openProjectsListener;
    private static List listeners = new ArrayList();
    private PropertyChangeListener annotationTypesListener;
    private List lastOpenProjects;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;

    public void restored() {
        Settings.addInitializer((Settings.Initializer)new BookmarksSettingsInitializer());
        this.openProjectsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                List<Project> list = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
                EditorBookmarksModule.this.lastOpenProjects.removeAll(list);
                Iterator iterator = EditorBookmarksModule.this.lastOpenProjects.iterator();
                while (iterator.hasNext()) {
                    Project project = (Project)iterator.next();
                    PersistentBookmarks.saveProjectBookmarks(project);
                }
                EditorBookmarksModule.this.lastOpenProjects = new ArrayList<Project>(list);
            }
        };
        OpenProjects openProjects = OpenProjects.getDefault();
        this.lastOpenProjects = new ArrayList<Project>(Arrays.asList(openProjects.getOpenProjects()));
        openProjects.addPropertyChangeListener(this.openProjectsListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final Iterator iterator = Registry.getDocumentIterator();
                if (!iterator.hasNext()) {
                    return;
                }
                AnnotationType annotationType = AnnotationTypes.getTypes().getType("editor-bookmark");
                if (annotationType == null) {
                    AnnotationTypes.getTypes().addPropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener = new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            AnnotationType annotationType = AnnotationTypes.getTypes().getType("editor-bookmark");
                            if (annotationType != null) {
                                AnnotationTypes.getTypes().removePropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener);
                                while (iterator.hasNext()) {
                                    Document document = (Document)iterator.next();
                                    BookmarkList.get(document);
                                }
                            }
                        }
                    });
                } else {
                    while (iterator.hasNext()) {
                        Document document = (Document)iterator.next();
                        BookmarkList.get(document);
                    }
                }
            }
        });
    }

    public void close() {
        this.finish();
    }

    public void uninstalled() {
        this.finish();
    }

    private void finish() {
        OpenProjects.getDefault().removePropertyChangeListener(this.openProjectsListener);
        Settings.removeInitializer((String)"bookmarks-settings-initializer");
        Settings.reset();
        PersistentBookmarks.saveAllProjectBookmarks();
        EditorBookmarksModule.fireChange();
    }

    public static synchronized void addChangeListener(ChangeListener changeListener) {
        listeners.add(changeListener);
    }

    public static synchronized void removeChangeListener(ChangeListener changeListener) {
        listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChange() {
        ChangeListener[] changeListenerArray;
        ChangeEvent changeEvent = new ChangeEvent(EditorBookmarksModule.class);
        Class clazz = EditorBookmarksModule.class;
        synchronized (clazz) {
            changeListenerArray = listeners.toArray(new ChangeListener[listeners.size()]);
        }
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(changeEvent);
        }
    }

    private static final class BookmarksSettingsInitializer
    extends Settings.AbstractInitializer {
        static final String NAME = "bookmarks-settings-initializer";

        BookmarksSettingsInitializer() {
            super(NAME);
        }

        public void updateSettingsMap(Class clazz, Map map) {
            if (clazz == (class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = EditorBookmarksModule.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)) {
                SettingsUtil.updateListSetting((Map)map, (String)"custom-action-list", (Object[])new Object[]{BookmarksKitInstallAction.INSTANCE});
                SettingsUtil.updateListSetting((Map)map, (String)"kit-install-action-name-list", (Object[])new Object[]{BookmarksKitInstallAction.INSTANCE.getValue("Name")});
            }
        }
    }
}

