/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.java.lexer;

import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocLexer
implements Lexer<JavadocTokenId> {
    private static final int EOF = -1;
    private LexerInput input;
    private TokenFactory<JavadocTokenId> tokenFactory;

    public JavadocLexer(LexerRestartInfo<JavadocTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        assert (lexerRestartInfo.state() == null);
    }

    public Object state() {
        return null;
    }

    public Token<JavadocTokenId> nextToken() {
        int n = this.input.read();
        if (n == -1) {
            return null;
        }
        if (Character.isJavaIdentifierStart(n)) {
            while (Character.isJavaIdentifierPart(this.input.read())) {
            }
            this.input.backup(1);
            return this.token(JavadocTokenId.IDENT);
        }
        if ("@<.#".indexOf(n) == -1) {
            n = this.input.read();
            while (!Character.isJavaIdentifierStart(n) && "@<.#".indexOf(n) == -1 && n != -1) {
                n = this.input.read();
            }
            if (n != -1) {
                this.input.backup(1);
            }
            return this.token(JavadocTokenId.OTHER_TEXT);
        }
        switch (n) {
            case 64: {
                while (Character.isLetter(n = this.input.read())) {
                }
                this.input.backup(1);
                return this.tokenFactory.createToken((TokenId)JavadocTokenId.TAG, this.input.readLength());
            }
            case 60: {
                while ((n = this.input.read()) != 62 && n != -1) {
                }
                return this.token(JavadocTokenId.HTML_TAG);
            }
            case 46: {
                return this.token(JavadocTokenId.DOT);
            }
            case 35: {
                return this.token(JavadocTokenId.HASH);
            }
        }
        assert (false);
        return null;
    }

    private Token<JavadocTokenId> token(JavadocTokenId javadocTokenId) {
        return this.tokenFactory.createToken((TokenId)javadocTokenId);
    }

    public void release() {
    }
}

