/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.util.Arrays;

final class SparseIntList {
    private int[] keys;
    private int[] values;
    private int used = 0;
    private int lastAdded = Integer.MIN_VALUE;
    private int lastIndex = Integer.MIN_VALUE;
    private int lastGet = -1;
    private int lastResult;

    SparseIntList(int n) {
        this.allocArrays(n);
    }

    public synchronized void add(int n, int n2) {
        if (n <= this.lastAdded) {
            throw new IllegalArgumentException("Contents must be presorted - added value " + n + " is less than preceding " + "value " + this.lastAdded);
        }
        if (n2 <= this.lastIndex) {
            throw new IllegalArgumentException("Contents must be presorted - added index " + n2 + " is less than preceding " + "index " + this.lastIndex);
        }
        if (this.used >= this.keys.length) {
            this.growArrays();
        }
        this.values[this.used] = n;
        this.keys[this.used++] = n2;
        this.lastAdded = n;
        this.lastIndex = n2;
    }

    int lastAdded() {
        return this.lastAdded;
    }

    int lastIndex() {
        return this.lastIndex;
    }

    private void allocArrays(int n) {
        this.keys = new int[n];
        this.values = new int[n];
        Arrays.fill(this.keys, Integer.MAX_VALUE);
        Arrays.fill(this.values, -1);
    }

    public synchronized int get(int n) {
        int n2;
        if (n < 0) {
            return 0;
        }
        if (this.used == 0 || this.used > 0 && n < this.keys[0]) {
            return n;
        }
        if (n == this.lastGet) {
            return this.lastResult;
        }
        this.lastGet = n;
        int n3 = Arrays.binarySearch(this.keys, n);
        if (n3 < 0) {
            int n4 = this.findInRange(n, 0, this.used);
            if (this.keys[n4] > n) {
                --n4;
            }
            n2 = n4 == -1 ? n : this.values[n4] + (n - this.keys[n4]);
        } else {
            n2 = n3 == 0 ? n : this.values[n3 - 1] + (n - this.keys[n3 - 1]);
        }
        this.lastResult = n2;
        return n2;
    }

    private int findInRange(int n, int n2, int n3) {
        if (n3 - n2 <= 1) {
            return n2;
        }
        int n4 = n2 + (n3 - n2 >> 1);
        int n5 = this.keys[n4];
        if (n5 > n) {
            return this.findInRange(n, n2, n2 + (n3 - n2 >> 1));
        }
        return this.findInRange(n, n2 + (n3 - n2 >> 1), n3);
    }

    private void growArrays() {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        this.allocArrays(Math.round((float)this.keys.length * 1.5f));
        System.arraycopy(nArray, 0, this.keys, 0, nArray.length);
        System.arraycopy(nArray2, 0, this.values, 0, nArray2.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SparseIntList [");
        stringBuffer.append("used=");
        stringBuffer.append(this.used);
        stringBuffer.append(" capacity=");
        stringBuffer.append(this.keys.length);
        stringBuffer.append(" keyValuePairs:");
        for (int i = 0; i < this.used; ++i) {
            stringBuffer.append(this.keys[i]);
            stringBuffer.append(':');
            stringBuffer.append(this.values[i]);
            if (i == this.used - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

