/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.util.Exceptions;

public abstract class AbstractOutputPane
extends JScrollPane
implements DocumentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ChangeListener,
MouseWheelListener,
Runnable {
    private boolean locked = true;
    private int fontHeight = -1;
    private int fontWidth = -1;
    protected JEditorPane textView = this.createTextView();
    int lastCaretLine = 0;
    boolean hadSelection = false;
    boolean recentlyReset = false;
    private boolean enqueued = false;
    private int lastLength = -1;
    private int pendingCaretLine = -1;
    private boolean pendingCaretSelect = false;
    private boolean inSendCaretToLine = false;
    private int mouseLine = -1;

    public AbstractOutputPane() {
        this.init();
    }

    public void requestFocus() {
        this.textView.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.textView.requestFocusInWindow();
    }

    protected abstract JEditorPane createTextView();

    protected void documentChanged() {
        this.lastLength = -1;
        if (this.pendingCaretLine != -1) {
            if (!this.sendCaretToLine(this.pendingCaretLine, this.pendingCaretSelect)) {
                this.ensureCaretPosition();
            }
        } else {
            this.ensureCaretPosition();
        }
        if (this.recentlyReset && this.isShowing()) {
            this.recentlyReset = false;
        }
        if (this.locked) {
            this.setMouseLine(-1);
        }
        if (this.isWrapped()) {
            this.getViewport().revalidate();
            this.getViewport().repaint();
        }
    }

    public abstract boolean isWrapped();

    public abstract void setWrapped(boolean var1);

    public boolean hasSelection() {
        return this.textView.getSelectionStart() != this.textView.getSelectionEnd();
    }

    boolean isScrollLocked() {
        return this.locked;
    }

    public final void ensureCaretPosition() {
        if (this.locked && !this.enqueued) {
            SwingUtilities.invokeLater(this);
            this.enqueued = true;
        }
    }

    public void run() {
        this.enqueued = false;
        this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getModel().getMaximum());
        this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getModel().getMinimum());
    }

    public int getSelectionStart() {
        return this.textView.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textView.getSelectionEnd();
    }

    public void setSelection(int n, int n2) {
        int n3;
        int n4 = Math.min(n, n2);
        if (n4 == (n3 = Math.max(n, n2))) {
            this.getCaret().setDot(n4);
        } else {
            this.textView.setSelectionStart(n4);
            this.textView.setSelectionEnd(n3);
        }
    }

    public void selectAll() {
        this.unlockScroll();
        this.getCaret().setVisible(true);
        this.textView.setSelectionStart(0);
        this.textView.setSelectionEnd(this.getLength());
    }

    public boolean isAllSelected() {
        return this.textView.getSelectionStart() == 0 && this.textView.getSelectionEnd() == this.getLength();
    }

    protected void init() {
        Serializable serializable;
        this.setViewportView(this.textView);
        this.textView.setEditable(false);
        this.textView.addMouseListener(this);
        this.textView.addMouseWheelListener(this);
        this.textView.addMouseMotionListener(this);
        this.textView.addKeyListener(this);
        this.textView.setCaret(new OCaret());
        this.getCaret().setVisible(true);
        this.getCaret().setBlinkRate(0);
        this.getCaret().setSelectionVisible(true);
        this.getVerticalScrollBar().getModel().addChangeListener(this);
        this.getVerticalScrollBar().addMouseMotionListener(this);
        this.getViewport().addMouseListener(this);
        this.getVerticalScrollBar().addMouseListener(this);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(22);
        this.addMouseListener(this);
        this.getCaret().addChangeListener(this);
        Integer n = (Integer)UIManager.get("customFontSize");
        int n2 = n != null ? n : ((serializable = (Font)UIManager.get("controlFont")) != null ? serializable.getSize() : 11);
        this.textView.setFont(new Font("Monospaced", 0, n2));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        serializable = UIManager.getColor("nb.output.selectionBackground");
        if (serializable != null) {
            this.textView.setSelectionColor((Color)serializable);
        }
    }

    public final Document getDocument() {
        return this.textView.getDocument();
    }

    public final JTextComponent getTextView() {
        return this.textView;
    }

    public final void copy() {
        if (this.getCaret().getDot() != this.getCaret().getMark()) {
            this.textView.copy();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void setDocument(Document document) {
        if (this.hasSelection()) {
            this.hasSelectionChanged(false);
        }
        this.hadSelection = false;
        this.lastCaretLine = 0;
        this.lastLength = -1;
        Document document2 = this.textView.getDocument();
        document2.removeDocumentListener(this);
        if (document != null) {
            this.textView.setDocument(document);
            document.addDocumentListener(this);
            this.lockScroll();
            this.recentlyReset = true;
            this.pendingCaretLine = -1;
        } else {
            this.textView.setDocument(new PlainDocument());
            this.textView.setEditorKit(new DefaultEditorKit());
        }
    }

    protected void setEditorKit(EditorKit editorKit) {
        Document document = this.textView.getDocument();
        this.textView.setEditorKit(editorKit);
        this.textView.setDocument(document);
        this.updateKeyBindings();
        this.getCaret().setVisible(true);
        this.getCaret().setBlinkRate(0);
    }

    protected final void updateKeyBindings() {
        Keymap keymap = this.textView.getKeymap();
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(27, 0));
    }

    protected EditorKit getEditorKit() {
        return this.textView.getEditorKit();
    }

    public final int getLineCount() {
        return this.textView.getDocument().getDefaultRootElement().getElementCount();
    }

    public final int getLength() {
        if (this.lastLength == -1) {
            this.lastLength = this.textView.getDocument().getLength();
        }
        return this.lastLength;
    }

    public final boolean sendCaretToLine(int n, boolean bl) {
        int n2 = this.getLineCount();
        if (n2 - n < 3) {
            this.pendingCaretLine = n;
            this.pendingCaretSelect = bl;
            return false;
        }
        this.inSendCaretToLine = true;
        this.pendingCaretLine = -1;
        this.unlockScroll();
        this.getCaret().setVisible(true);
        this.getCaret().setSelectionVisible(true);
        Element element = this.textView.getDocument().getDefaultRootElement().getElement(Math.min(n, this.getLineCount() - 1));
        int n3 = element.getStartOffset();
        if (bl) {
            this.getCaret().setDot(element.getEndOffset() - 1);
            this.getCaret().moveDot(n3);
            this.getCaret().setSelectionVisible(true);
            this.textView.repaint();
        } else {
            this.getCaret().setDot(n3);
        }
        if (n + 3 < this.getLineCount()) {
            try {
                Rectangle rectangle = this.textView.modelToView(this.textView.getDocument().getDefaultRootElement().getElement(n + 3).getStartOffset());
                if (rectangle != null) {
                    this.textView.scrollRectToVisible(rectangle);
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        this.inSendCaretToLine = false;
        return true;
    }

    public final void lockScroll() {
        if (!this.locked) {
            this.locked = true;
        }
    }

    public final void unlockScroll() {
        if (this.locked) {
            this.locked = false;
        }
    }

    protected abstract void caretEnteredLine(int var1);

    protected abstract void lineClicked(int var1, Point var2);

    protected abstract void postPopupMenu(Point var1, Component var2);

    public final int getCaretLine() {
        int n = -1;
        int n2 = this.getCaret().getDot();
        if (n2 > 0) {
            n = this.textView.getDocument().getDefaultRootElement().getElementIndex(n2);
        }
        return n;
    }

    public final int getCaretPos() {
        return this.getCaret().getDot();
    }

    public final void paint(Graphics graphics) {
        if (this.fontHeight == -1) {
            this.fontHeight = graphics.getFontMetrics(this.textView.getFont()).getHeight();
            this.fontWidth = graphics.getFontMetrics(this.textView.getFont()).charWidth('m');
        }
        super.paint(graphics);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JViewport) {
            if (this.locked) {
                this.ensureCaretPosition();
            }
        } else if (changeEvent.getSource() == this.getVerticalScrollBar().getModel()) {
            BoundedRangeModel boundedRangeModel;
            if (!this.locked && (boundedRangeModel = this.getVerticalScrollBar().getModel()).getValue() + boundedRangeModel.getExtent() == boundedRangeModel.getMaximum()) {
                this.lockScroll();
            }
        } else {
            boolean bl;
            if (!this.locked) {
                this.maybeSendCaretEnteredLine();
            }
            boolean bl2 = bl = this.textView.getSelectionStart() != this.textView.getSelectionEnd();
            if (bl != this.hadSelection) {
                this.hadSelection = bl;
                this.hasSelectionChanged(bl);
            }
        }
    }

    private boolean caretLineChanged() {
        int n = this.getCaretLine();
        boolean bl = n != this.lastCaretLine;
        this.lastCaretLine = n;
        return bl;
    }

    private void maybeSendCaretEnteredLine() {
        if (EventQueue.getCurrentEvent() instanceof MouseEvent) {
            return;
        }
        if (!this.locked && this.caretLineChanged() && !this.inSendCaretToLine) {
            boolean bl;
            int n = this.getCaretLine();
            boolean bl2 = bl = this.textView.getSelectionStart() != this.textView.getSelectionEnd();
            if (n != -1 && !bl) {
                this.caretEnteredLine(this.getCaretLine());
            }
            if (bl != this.hadSelection) {
                this.hadSelection = bl;
                this.hasSelectionChanged(bl);
            }
        }
    }

    private void hasSelectionChanged(boolean bl) {
        ((AbstractOutputTab)this.getParent()).hasSelectionChanged(bl);
    }

    public final void changedUpdate(DocumentEvent documentEvent) {
        documentEvent.getLength();
        this.documentChanged();
    }

    public final void insertUpdate(DocumentEvent documentEvent) {
        documentEvent.getLength();
        this.documentChanged();
    }

    public final void removeUpdate(DocumentEvent documentEvent) {
        documentEvent.getLength();
        this.documentChanged();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setMouseLine(-1);
    }

    public void setMouseLine(int n, Point point) {
        if (this.mouseLine != n) {
            this.mouseLine = n;
        }
    }

    public final void setMouseLine(int n) {
        this.setMouseLine(n, null);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.textView.viewToModel(point);
        if (n < this.getLength()) {
            int n2 = this.getDocument().getDefaultRootElement().getElementIndex(n);
            int n3 = this.getDocument().getDefaultRootElement().getElement(n2).getStartOffset();
            int n4 = this.getDocument().getDefaultRootElement().getElement(n2).getEndOffset() - n3;
            try {
                boolean bl;
                Rectangle rectangle = this.textView.modelToView(n3 + n4 - 1);
                int n5 = rectangle.x + rectangle.width;
                boolean bl2 = bl = point.x <= n5;
                if (this.isWrapped()) {
                    Rectangle rectangle2 = this.textView.modelToView(n3);
                    if (rectangle2.y <= rectangle.y && point.y < rectangle.y) {
                        bl = true;
                    }
                }
                if (bl) {
                    this.setMouseLine(n2, point);
                } else {
                    this.setMouseLine(-1);
                }
            }
            catch (BadLocationException badLocationException) {
                this.setMouseLine(-1);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getSource() == this.getVerticalScrollBar() && (n = mouseEvent.getY()) > this.getVerticalScrollBar().getHeight()) {
            this.lockScroll();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (this.locked && !mouseEvent.isPopupTrigger()) {
            object = this.getDocument().getDefaultRootElement().getElement(this.getLineCount() - 1);
            this.getCaret().setDot(object.getStartOffset());
            this.unlockScroll();
            if (mouseEvent.getSource() == this.textView) {
                this.getCaret().setDot(this.textView.viewToModel(mouseEvent.getPoint()));
            }
        }
        if (mouseEvent.isPopupTrigger()) {
            object = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this);
            this.postPopupMenu((Point)object, this);
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (mouseEvent.getSource() == this.textView && SwingUtilities.isLeftMouseButton(mouseEvent) && (n2 = this.textView.viewToModel(mouseEvent.getPoint())) != -1 && (n = this.textView.getDocument().getDefaultRootElement().getElementIndex(n2)) >= 0) {
            this.lineClicked(n, mouseEvent.getPoint());
            mouseEvent.consume();
        }
        if (mouseEvent.isPopupTrigger()) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this);
            this.postPopupMenu(point, this);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 35) {
            this.lockScroll();
        } else {
            this.unlockScroll();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        BoundedRangeModel boundedRangeModel = this.getVerticalScrollBar().getModel();
        int n = boundedRangeModel.getMaximum();
        int n2 = boundedRangeModel.getExtent();
        int n3 = boundedRangeModel.getValue();
        if (mouseWheelEvent.getSource() == this.textView) {
            int n4 = Math.max(0, Math.min(boundedRangeModel.getMaximum(), n3 + mouseWheelEvent.getUnitsToScroll() * this.textView.getFontMetrics(this.textView.getFont()).getHeight()));
            boundedRangeModel.setValue(n4);
            if (n4 + n2 >= n) {
                this.lockScroll();
                return;
            }
        }
        this.unlockScroll();
    }

    Caret getCaret() {
        return this.textView.getCaret();
    }

    private class OCaret
    extends DefaultCaret {
        private OCaret() {
        }

        public void setSelectionVisible(boolean bl) {
            super.setSelectionVisible(true);
            super.setBlinkRate(0);
        }

        public boolean isSelectionVisible() {
            return true;
        }

        public void setBlinkRate(int n) {
            super.setBlinkRate(0);
        }

        public boolean isVisible() {
            return true;
        }

        public void paint(Graphics graphics) {
            JEditorPane jEditorPane = AbstractOutputPane.this.textView;
            if (this.isVisible() && this.y >= 0) {
                try {
                    TextUI textUI = jEditorPane.getUI();
                    Rectangle rectangle = textUI.modelToView(jEditorPane, this.getDot(), Position.Bias.Forward);
                    if (rectangle == null || rectangle.width == 0 && rectangle.height == 0) {
                        return;
                    }
                    if (this.width > 0 && this.height > 0 && !this._contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                        Rectangle rectangle2 = graphics.getClipBounds();
                        if (rectangle2 != null && !rectangle2.contains(this)) {
                            this.repaint();
                        }
                        this.damage(rectangle);
                    }
                    graphics.setColor(jEditorPane.getCaretColor());
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private boolean _contains(int n, int n2, int n3, int n4) {
            int n5 = this.width;
            int n6 = this.height;
            if ((n5 | n6 | n3 | n4) < 0) {
                return false;
            }
            int n7 = this.x;
            int n8 = this.y;
            if (n < n7 || n2 < n8) {
                return false;
            }
            if (n3 > 0) {
                n5 += n7;
                if ((n3 += n) <= n) {
                    if (n5 >= n7 || n3 > n5) {
                        return false;
                    }
                } else if (n5 >= n7 && n3 > n5) {
                    return true;
                }
            } else if (n7 + n5 < n) {
                return false;
            }
            if (n4 > 0) {
                n6 += n8;
                if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
                    return false;
                }
            } else if (n8 + n6 < n2) {
                return false;
            }
            return true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                super.mouseReleased(mouseEvent);
            }
        }
    }
}

