/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.updater.Localization;
import org.netbeans.updater.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterFrame;

public final class ModuleUpdater
extends Thread {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String UPDATE_DIR = "update";
    static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    private static final String BACKUP_DIR = "update" + FILE_SEPARATOR + "backup";
    private static final String NB_LIB_DIR = "lib";
    public static final String UPDATE_NETBEANS_DIR = "netbeans";
    public static final String UPDATE_JAVA_EXT_DIR = "java_ext";
    public static final String UPDATE_MAIN_DIR = "main";
    private static final String JVM_PARAMS_FILE = "main.properties";
    public static final String NBM_EXTENSION = "nbm";
    public static final String LOG_FILE_NAME = "update.log";
    public static final String LATER_FILE_NAME = "install_later.xml";
    public static final char SPACE = ' ';
    public static final char QUOTE = '\"';
    private File downloadDirectory = null;
    private Set installOnly;
    private Set installFiles;
    private volatile boolean stop = false;
    private volatile boolean suspend = false;
    private long totalLength;
    private static boolean fromInstall = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.getDownloadDirectory();
            this.checkStop();
            if (this.downloadDirectory == null) {
                this.endRun();
            }
            this.checkStop();
            this.installFiles = new HashSet();
            for (File file : UpdateTracking.clusters(true)) {
                UpdateTracking updateTracking = UpdateTracking.getTracking(file);
                if (updateTracking != null) {
                    this.installFiles.addAll(updateTracking.getModulesToInstall());
                }
                this.deleteInstall_Later(file);
            }
            if (this.installOnly != null) {
                this.installFiles.retainAll(this.installOnly);
            }
            if (this.installFiles.isEmpty()) {
                this.endRun();
            }
            this.checkStop();
            this.totalLength();
            this.checkStop();
            this.unpack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            UpdaterFrame.getUpdaterFrame().unpackingFinished();
        }
    }

    private void deleteInstall_Later(File file) {
        File file2 = new File(file, FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME);
        if (file2.exists()) {
            file2.delete();
        }
    }

    void endRun() {
        this.stop = true;
    }

    private void checkStop() {
        if (this.suspend) {
            while (this.suspend) {
            }
        }
        if (this.stop) {
            UpdaterFrame.getUpdaterFrame();
            if (UpdaterFrame.isFromIDE()) {
                UpdaterFrame.getUpdaterFrame().unpackingFinished();
            } else {
                System.exit(0);
            }
        }
    }

    public void setInstallOnly(File[] fileArray) {
        this.installOnly = new HashSet();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.installOnly.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void totalLength() {
        this.totalLength = 0L;
        UpdaterFrame.setLabel(Localization.getBrandedString("CTL_PreparingUnpack"));
        UpdaterFrame.setProgressRange(0L, this.installFiles.size());
        Iterator iterator = this.installFiles.iterator();
        for (int i = 0; i < this.installFiles.size(); ++i) {
            ZipFile zipFile = null;
            try {
                UpdaterFrame.setProgressValue(i + 1);
                zipFile = new JarFile((File)iterator.next());
                Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    this.checkStop();
                    if (!jarEntry.getName().startsWith(UPDATE_NETBEANS_DIR) && !jarEntry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !jarEntry.getName().startsWith(UPDATE_MAIN_DIR) || jarEntry.isDirectory()) continue;
                    this.totalLength += jarEntry.getSize();
                }
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpack() {
        UpdateTracking.Version version;
        UpdateTracking.Module module;
        long l = 0L;
        UpdaterFrame.setLabel("");
        UpdaterFrame.setProgressRange(0L, this.totalLength);
        fromInstall = true;
        ArrayList<UpdateTracking> arrayList = new ArrayList<UpdateTracking>();
        HashMap<ModuleUpdate, UpdateTracking.Version> hashMap = new HashMap<ModuleUpdate, UpdateTracking.Version>();
        List list = UpdateTracking.clusters(true);
        for (Object object : list) {
            UpdateTracking updateTracking = UpdateTracking.getTracking((File)object, false);
            if (updateTracking == null) continue;
            arrayList.add(updateTracking);
            HashSet hashSet = new HashSet(updateTracking.getModulesToInstall());
            hashSet.retainAll(this.installFiles);
            File[] fileArray = hashSet.toArray(new File[0]);
            for (int moduleUpdate = 0; moduleUpdate < fileArray.length; ++moduleUpdate) {
                ModuleUpdate moduleUpdate2 = null;
                try {
                    moduleUpdate2 = new ModuleUpdate(fileArray[moduleUpdate], fromInstall);
                }
                catch (RuntimeException runtimeException) {
                    if (!fileArray[moduleUpdate].exists() || fileArray[moduleUpdate].delete()) continue;
                    System.out.println("Error: File " + fileArray[moduleUpdate] + " cannot be deleted. Propably file lock on the file.");
                    assert (false) : "Error: File " + fileArray[moduleUpdate] + " cannot be deleted. Propably file lock on the file.";
                    fileArray[moduleUpdate].deleteOnExit();
                    continue;
                }
                assert (moduleUpdate2 != null) : "Module update is not null for file: " + fileArray[moduleUpdate];
                if (moduleUpdate2.isL10n()) {
                    module = null;
                    version = updateTracking.createVersion("0");
                    hashMap.put(moduleUpdate2, version);
                } else {
                    module = updateTracking.readModuleTracking(!fromInstall, moduleUpdate2.getCodenamebase(), true);
                    version = module.addNewVersion(moduleUpdate2.getSpecification_version());
                }
                System.gc();
                boolean bl = false;
                UpdaterFrame.setLabel(Localization.getBrandedString("CTL_UnpackingFile") + "  " + fileArray[moduleUpdate].getName());
                UpdaterFrame.setProgressValue(l);
                JarFile jarFile = null;
                try {
                    Object object2;
                    Object object3;
                    Object object4;
                    jarFile = new JarFile(fileArray[moduleUpdate]);
                    Enumeration<JarEntry> iOException = jarFile.entries();
                    while (iOException.hasMoreElements()) {
                        object4 = iOException.nextElement();
                        this.checkStop();
                        if (((ZipEntry)object4).getName().startsWith(UPDATE_NETBEANS_DIR)) {
                            if (((ZipEntry)object4).isDirectory()) continue;
                            object3 = ((ZipEntry)object4).getName().substring(UPDATE_NETBEANS_DIR.length() + 1);
                            if (moduleUpdate2.isL10n()) {
                                version.addL10NFileWithCrc((String)object3, Long.toString(((ZipEntry)object4).getCrc()), moduleUpdate2.getSpecification_version());
                            } else {
                                version.addFileWithCrc((String)object3, Long.toString(((ZipEntry)object4).getCrc()));
                            }
                            object2 = new File((File)object, ((ZipEntry)object4).getName().substring(UPDATE_NETBEANS_DIR.length()));
                            if (((File)object2).exists()) {
                                File file = new File(this.getBackupDirectory((File)object), ((ZipEntry)object4).getName());
                                file.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream((File)object2), new FileOutputStream(file), -1L);
                            } else {
                                ((File)object2).getParentFile().mkdirs();
                            }
                            l = this.copyStreams(jarFile.getInputStream((ZipEntry)object4), new FileOutputStream((File)object2), l);
                            UpdaterFrame.setProgressValue(l);
                            continue;
                        }
                        if (!((ZipEntry)object4).getName().startsWith(UPDATE_MAIN_DIR) || ((ZipEntry)object4).isDirectory()) continue;
                        object3 = new File(this.getMainDirectory((File)object), ((ZipEntry)object4).getName().substring(UPDATE_MAIN_DIR.length() + 1));
                        ((File)object3).getParentFile().mkdirs();
                        bl = true;
                        l = this.copyStreams(jarFile.getInputStream((ZipEntry)object4), new FileOutputStream((File)object3), l);
                        UpdaterFrame.setProgressValue(l);
                    }
                    if (bl && ((MainConfig)(object4 = new MainConfig(this.getMainDirString((File)object) + FILE_SEPARATOR + JVM_PARAMS_FILE, (File)object))).isValid()) {
                        object3 = System.getProperty("java.home") + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "java";
                        object3 = ModuleUpdater.quoteString((String)object3);
                        object2 = (String)object3 + " -cp " + ModuleUpdater.quoteString(this.getMainDirString((File)object) + ((MainConfig)object4).getClasspath()) + ((MainConfig)object4).getCommand();
                        this.startCommand((String)object2);
                        this.deleteDir(this.getMainDirectory((File)object));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (!fileArray[moduleUpdate].delete()) {
                        System.out.println("Error: Cannot delete " + fileArray[moduleUpdate]);
                        assert (false) : "Cannot delete " + fileArray[moduleUpdate];
                        fileArray[moduleUpdate].deleteOnExit();
                    }
                }
                if (moduleUpdate2.isL10n()) continue;
                module.write();
                module.writeConfigModuleXMLIfMissing();
            }
        }
        for (UpdateTracking updateTracking : arrayList) {
            for (Map.Entry entry : hashMap.entrySet()) {
                ModuleUpdate moduleUpdate = (ModuleUpdate)entry.getKey();
                version = (UpdateTracking.Version)entry.getValue();
                module = updateTracking.readModuleTracking(!moduleUpdate.isFromInstall(), moduleUpdate.getCodenamebase(), true);
                module.addL10NVersion(version);
                module.write();
            }
            updateTracking.deleteUnusedFiles();
        }
    }

    private File getDownloadDirectory() {
        if (this.downloadDirectory == null) {
            this.downloadDirectory = new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + DOWNLOAD_DIR);
        }
        return this.downloadDirectory;
    }

    private void startCommand(String string) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process;
            final Process process2 = process = runtime.exec(ModuleUpdater.parseParameters(string));
            new Thread(){

                public void run() {
                    try {
                        String string;
                        InputStreamReader inputStreamReader = new InputStreamReader(process2.getErrorStream());
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        do {
                            if ((string = bufferedReader.readLine()) == null) continue;
                            System.out.println(string);
                        } while (string != null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.start();
            int n = process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File getBackupDirectory(File file) {
        File file2 = new File(file, BACKUP_DIR);
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        return file2;
    }

    private File getMainDirectory(File file) {
        File file2 = new File(file, FILE_SEPARATOR + UPDATE_DIR + FILE_SEPARATOR + UPDATE_MAIN_DIR);
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        return file2;
    }

    private String getMainDirString(File file) {
        return this.getMainDirectory(file).getPath();
    }

    public static final String quoteString(String string) {
        if (string.indexOf(32) > -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '\"') {
                    stringBuffer.deleteCharAt(n);
                    continue;
                }
                ++n;
            }
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyStreams(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = 0;
        try {
            int n2;
            while ((n2 = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(n2);
                if (++n <= 8500) continue;
                if (l >= 0L) {
                    UpdaterFrame.setProgressValue(l += (long)n);
                }
                n = 0;
                this.checkStop();
            }
            if (l >= 0L) {
                l += (long)n;
            }
        }
        finally {
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        return l;
    }

    private static boolean canWrite(File file, boolean bl) {
        if (!file.exists() && bl) {
            file.mkdirs();
        }
        if (!file.isDirectory() || !file.canWrite()) {
            return false;
        }
        File file2 = null;
        try {
            file2 = File.createTempFile("test", "access", file);
        }
        catch (IOException iOException) {
            return false;
        }
        if (file2 == null) {
            return false;
        }
        boolean bl2 = file2.canWrite();
        if (bl2) {
            file2.delete();
        }
        return bl2;
    }

    private void deleteDir(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            this.deleteDir(fileArray[i]);
            if (fileArray[i].delete()) continue;
            System.out.println("Error: Cannot delete " + fileArray[i]);
            assert (false) : "Cannot delete " + fileArray[i];
        }
    }

    private static String[] parseParameters(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        Vector<String> vector = new Vector<String>(5, 5);
        int n6 = n;
        StringBuffer stringBuffer = new StringBuffer(20);
        int n7 = string.length();
        for (int i = 0; i < n7; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (n6 == n) {
                    if (stringBuffer.length() <= 0) continue;
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                if (n6 == n4) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    n6 = n;
                    continue;
                }
                if (n6 == n5) {
                    stringBuffer.append('\\');
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    n6 = n;
                    continue;
                }
                if (n6 == n3) {
                    n6 = n2;
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c == '\\') {
                if (n6 == n) {
                    if (++i < n7) {
                        char c2 = string.charAt(i);
                        if (c2 == '\"' || c2 == '\\') {
                            stringBuffer.append(c2);
                            continue;
                        }
                        if (Character.isWhitespace(c2)) {
                            stringBuffer.append(c);
                            --i;
                            continue;
                        }
                        stringBuffer.append(c);
                        stringBuffer.append(c2);
                        continue;
                    }
                    stringBuffer.append('\\');
                    break;
                }
                if (n6 == n2) {
                    n6 = n3;
                    continue;
                }
                if (n6 == n3) {
                    stringBuffer.append('\\');
                    n6 = n2;
                    continue;
                }
                if (n6 == n4) {
                    n6 = n5;
                    continue;
                }
                if (n6 != n5) continue;
                stringBuffer.append('\\');
                n6 = n4;
                continue;
            }
            if (c == '\"') {
                if (n6 == n) {
                    n6 = n2;
                    continue;
                }
                if (n6 == n2) {
                    n6 = n4;
                    continue;
                }
                if (n6 == n4) {
                    n6 = n2;
                    continue;
                }
                if (n6 == n5) {
                    stringBuffer.append('\"');
                    n6 = n4;
                    continue;
                }
                stringBuffer.append('\"');
                n6 = n2;
                continue;
            }
            if (n6 == n3) {
                stringBuffer.append('\\');
                n6 = n2;
            } else if (n6 == n5) {
                stringBuffer.append('\\');
                n6 = n4;
            }
            stringBuffer.append(c);
        }
        if (n6 == n2) {
            vector.addElement(stringBuffer.toString());
        } else if ((n6 & (n3 | n5)) != 0) {
            stringBuffer.append('\\');
            vector.addElement(stringBuffer.toString());
        } else if (stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    class MainConfig {
        private final String PAR_MAIN = "mainClass";
        private final String PAR_RELCP = "relativeClassPath";
        private final String PAR_JVMPAR = "jvm.parameters";
        private final String PAR_MAINARGS = "mainClass.arguments";
        private final String VAR_IDE_HOME = "%IDE_HOME%";
        private final String VAR_IDE_USER = "%IDE_USER%";
        private final String VAR_FILE_SEPARATOR = "%FS%";
        private final String VAR_JAVA_HOME = "%JAVA_HOME%";
        private final String VAR_ICON_ROOT = "%ICON_ROOT%";
        private final String ICON_ROOT = "Forte for Java";
        private final String VAR_LOGFILE = "%UPDATE_LOGFILE%";
        private String parameters = "";
        private String classpath = "";
        private boolean valid = false;
        private final File activeCluster;

        public MainConfig(String string, File file) {
            this.valid = this.readParms(string);
            this.activeCluster = file;
        }

        public String getCommand() {
            return this.parameters;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readParms(String string) {
            String string2;
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String string3 = properties.getProperty("relativeClassPath", null);
            if (string3 != null) {
                string3 = this.replaceVars(string3);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, PATH_SEPARATOR, false);
                while (stringTokenizer.hasMoreTokens()) {
                    this.classpath = this.classpath + PATH_SEPARATOR + this.changeRelative(stringTokenizer.nextToken());
                }
            }
            this.parameters = "";
            String string4 = properties.getProperty("jvm.parameters", null);
            if (string4 != null) {
                this.parameters = this.parameters + " " + string4;
            }
            if ((string2 = properties.getProperty("mainClass", null)) == null) {
                return false;
            }
            this.parameters = this.parameters + " " + string2;
            String string5 = properties.getProperty("mainClass.arguments", null);
            if (string5 != null) {
                this.parameters = this.parameters + " " + string5;
            }
            this.parameters = this.replaceVars(this.parameters);
            return true;
        }

        private String replaceVars(String string) {
            string = this.replaceAll(string, "%IDE_HOME%", UpdateTracking.getPlatformDir().getPath());
            string = this.replaceAll(string, "%IDE_USER%", UpdateTracking.getPlatformDir().getPath());
            MainConfig mainConfig = this;
            string = this.replaceAll(string, "%FS%", FILE_SEPARATOR);
            string = this.replaceAll(string, "%JAVA_HOME%", System.getProperty("java.home"));
            return string;
        }

        private String changeRelative(String string) {
            if (new File(string).isAbsolute()) {
                return string;
            }
            return ModuleUpdater.this.getMainDirString(this.activeCluster) + FILE_SEPARATOR + string;
        }

        private String replaceAll(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.toString().indexOf(string2);
            int n2 = string2.length();
            while (n > -1) {
                stringBuffer.replace(n, n + n2, string3);
                n = stringBuffer.toString().indexOf(string2, n + 1);
            }
            return stringBuffer.toString();
        }
    }
}

