/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class UpdateTracking {
    private static final String ELEMENT_MODULES = "installed_modules";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codename";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_VERSION = "specification_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_INSTALL = "install_time";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_FILE_NAME = "name";
    private static final String ATTR_CRC = "crc";
    private static final String NBM_ORIGIN = "nbm";
    private static final String INST_ORIGIN = "updater";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String LOCALE_DIR = FILE_SEPARATOR + "locale" + FILE_SEPARATOR;
    public static final String TRACKING_FILE_NAME = "update_tracking";
    private static final String XML_EXT = ".xml";
    private static final Map trackings = new HashMap();
    private LinkedHashMap installedModules = new LinkedHashMap();
    private boolean pError = false;
    private boolean fromUser = false;
    private final File directory;
    private final File trackingFile;
    private String origin = "nbm";

    public UpdateTracking() {
        this(null);
    }

    private UpdateTracking(File file) {
        assert (file != null) : "Path cannot be null";
        this.trackingFile = new File(file + FILE_SEPARATOR + TRACKING_FILE_NAME);
        this.directory = file;
        this.origin = INST_ORIGIN;
    }

    static UpdateTracking getTracking(boolean bl) {
        UpdateTracking updateTracking = UpdateTracking.getTracking(System.getProperty(bl ? "netbeans.user" : "netbeans.home"), bl);
        return updateTracking;
    }

    private static UpdateTracking getTracking(String string, boolean bl) {
        File file = new File(string);
        UpdateTracking updateTracking = UpdateTracking.getTracking(file, bl);
        return updateTracking;
    }

    public static UpdateTracking getTracking(File file) {
        file = new File(file.toURI().normalize()).getAbsoluteFile();
        File file2 = new File(System.getProperty("netbeans.user"));
        file2 = new File(file2.toURI().normalize()).getAbsoluteFile();
        return UpdateTracking.getTracking(file, file.toString().equals(file2.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateTracking getTracking(File file, boolean bl) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException(iOException.getMessage());
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
        Map map = trackings;
        synchronized (map) {
            UpdateTracking updateTracking = (UpdateTracking)trackings.get(file);
            if (updateTracking == null) {
                File file2 = new File(file, TRACKING_FILE_NAME);
                if (!bl && !file2.isDirectory()) {
                    return null;
                }
                File file3 = new File(file, ".noautoupdate");
                if (file3.exists()) {
                    return null;
                }
                updateTracking = new UpdateTracking(file);
                trackings.put(file, updateTracking);
                updateTracking.read();
                updateTracking.scanDir();
            }
            return updateTracking;
        }
    }

    public static File getPlatformDir() {
        return new File(System.getProperty("netbeans.home"));
    }

    public static List clusters(boolean bl) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            object2 = new File(System.getProperty("netbeans.user"));
            arrayList.add(object2);
        }
        if ((object2 = System.getProperty("netbeans.dirs")) != null) {
            object = new StringTokenizer((String)object2, File.pathSeparator);
            while (object.hasMoreElements()) {
                File file = new File((String)object.nextElement());
                arrayList.add(file);
            }
        }
        object = UpdateTracking.getPlatformDir();
        arrayList.add(object);
        return Collections.unmodifiableList(arrayList);
    }

    public boolean isModuleInstalled(String string) {
        for (Module module : this.installedModules.values()) {
            String string2 = module.codenamebase;
            int n = string2.indexOf(47);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public List getModulesToInstall() {
        File file = new File(this.directory, ModuleUpdater.DOWNLOAD_DIR);
        class NbmFilter
        implements FilenameFilter {
            NbmFilter() {
            }

            public boolean accept(File file, String string) {
                return string.endsWith(UpdateTracking.NBM_ORIGIN);
            }
        }
        File[] fileArray = file.listFiles(new NbmFilter());
        if (fileArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(fileArray);
    }

    private void read() {
        Document document;
        Object object;
        try {
            File file = this.trackingFile;
            if (!file.isFile()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)object, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("Bad update_tracking");
            sAXException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Missing update_tracking");
            iOException.printStackTrace();
            return;
        }
        object = document.getDocumentElement();
        if (object != null && object.getTagName().equals(ELEMENT_MODULES)) {
            this.scanElement_installed_modules((Element)object, this.fromUser);
        }
    }

    void scanElement_installed_modules(Element element, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(ELEMENT_MODULE)) continue;
            throw new IllegalStateException("What now!?");
        }
    }

    Module scanElement_module(Element element, boolean bl) {
        Module module = new Module(bl);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getName().startsWith(ATTR_CODENAMEBASE)) continue;
            module.setCodenamebase(attr.getValue());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(ELEMENT_VERSION)) continue;
            this.scanElement_module_version(element2, module);
        }
        return module;
    }

    void scanElement_module_version(Element element, Module module) {
        Version version = new Version();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getName().equals(ATTR_VERSION)) {
                version.setVersion(attr.getValue());
            }
            if (attr.getName().equals(ATTR_ORIGIN)) {
                version.setOrigin(attr.getValue());
            }
            if (attr.getName().equals(ATTR_LAST)) {
                version.setLast(Boolean.valueOf(attr.getValue()));
            }
            if (!attr.getName().equals(ATTR_INSTALL)) continue;
            long l = 0L;
            try {
                l = Long.parseLong(attr.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            version.setInstall_time(l);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(ELEMENT_FILE)) continue;
            this.scanElement_file(element2, version);
        }
        module.addOldVersion(version);
    }

    void scanElement_file(Element element, Version version) {
        ModuleFile moduleFile = new ModuleFile();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getName().equals(ATTR_FILE_NAME)) {
                moduleFile.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_CRC)) {
                moduleFile.setCrc(attr.getValue());
            }
            if (!attr.getName().equals(ATTR_VERSION)) continue;
            moduleFile.setLocaleversion(attr.getValue());
        }
        version.addFile(moduleFile);
    }

    Module readModuleTracking(boolean bl, String string, boolean bl2) {
        new File(this.directory, TRACKING_FILE_NAME).mkdirs();
        File file = new File(new File(this.directory, TRACKING_FILE_NAME), UpdateTracking.getTrackingName(string) + XML_EXT);
        try {
            if (file.exists() && file.length() == 0L) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!file.exists()) {
            if (bl2) {
                return new Module(string, file, bl);
            }
            return null;
        }
        return this.readModuleFromFile(file, string, bl, bl2);
    }

    Version createVersion(String string) {
        Version version = new Version();
        version.setVersion(string);
        return version;
    }

    private Module readModuleFromFile(File file, String string, boolean bl, boolean bl2) {
        Document document;
        Object object;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)object, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("Bad update_tracking");
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            if (bl2) {
                return new Module(string, file, bl);
            }
            return null;
        }
        object = document.getDocumentElement();
        if (object != null && object.getTagName().equals(ELEMENT_MODULE)) {
            Module module = this.scanElement_module((Element)object, bl);
            module.setFile(file);
            this.installedModules.put(file, module);
            return module;
        }
        if (bl2) {
            return new Module(string, file, bl);
        }
        return null;
    }

    private static String getTrackingName(String string) {
        String string2 = string;
        int n = string2.indexOf(47);
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        return string2.replace('.', '-');
    }

    public static void convertOldFormat(File file, String string, boolean bl) {
        new File(string + FILE_SEPARATOR + TRACKING_FILE_NAME).mkdirs();
        UpdateTracking updateTracking = UpdateTracking.getTracking(bl);
        for (Module module : updateTracking.installedModules.values()) {
            File file2 = new File(string + FILE_SEPARATOR + TRACKING_FILE_NAME + FILE_SEPARATOR + UpdateTracking.getTrackingName(module.getCodenamebase()) + XML_EXT);
            module.setFile(file2);
            module.write();
        }
        file.delete();
    }

    public String getL10NSpecificationVersion(String string, boolean bl, String string2) {
        Module module = this.readModuleTracking(bl, string, false);
        if (module == null) {
            return null;
        }
        return module.getL10NSpecificationVersion(string2);
    }

    void deleteUnusedFiles() {
        ArrayList arrayList = new ArrayList(this.installedModules.values());
        for (Module module : arrayList) {
            module.deleteUnusedFiles();
        }
        this.scanDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileCRC(File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        CRC32 cRC32 = new CRC32();
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read()) != -1) {
                cRC32.update((byte)n);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        return cRC32.getValue();
    }

    private void scanDir() {
        File file = new File(this.directory, TRACKING_FILE_NAME);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().toUpperCase().endsWith(".XML");
            }
        });
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.installedModules.containsKey(fileArray[i])) continue;
            this.readModuleFromFile(fileArray[i], null, this.fromUser, true);
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }

        public void error(SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }
    }

    class Module {
        private String codenamebase;
        private List versions = new ArrayList();
        private File file = null;
        private boolean fromUser = true;
        private Version lastVersion = null;
        private Version newVersion = null;

        public Module() {
        }

        public Module(boolean bl) {
            this.fromUser = bl;
        }

        public Module(String string, File file, boolean bl) {
            this.codenamebase = string;
            this.file = file;
            this.fromUser = bl;
        }

        String getCodenamebase() {
            return this.codenamebase;
        }

        void setCodenamebase(String string) {
            this.codenamebase = string;
        }

        List getVersions() {
            return this.versions;
        }

        void setVersions(List list) {
            this.versions = list;
        }

        boolean isFromUser() {
            return this.fromUser;
        }

        void setFromUser(boolean bl) {
            this.fromUser = bl;
        }

        private Version getNewOrLastVersion() {
            if (this.newVersion != null) {
                return this.newVersion;
            }
            return this.lastVersion;
        }

        boolean hasNewVersion() {
            return this.newVersion != null;
        }

        void setFile(File file) {
            this.file = file;
        }

        public Version addNewVersion(String string) {
            Version version;
            if (this.lastVersion != null) {
                this.lastVersion.setLast(false);
            }
            this.newVersion = version = new Version();
            version.setVersion(string);
            version.setOrigin(UpdateTracking.this.origin);
            version.setLast(true);
            version.setInstall_time(System.currentTimeMillis());
            this.versions.add(version);
            return version;
        }

        void addOldVersion(Version version) {
            if (version.isLast()) {
                this.lastVersion = version;
            }
            this.versions.add(version);
        }

        void addL10NVersion(Version version) {
            if (this.lastVersion != null) {
                this.lastVersion.addL10NFiles(version.getFiles());
            } else {
                version.setOrigin(UpdateTracking.this.origin);
                version.setLast(true);
                version.setInstall_time(System.currentTimeMillis());
                this.versions.add(version);
            }
        }

        void writeConfigModuleXMLIfMissing() {
            ModuleFile moduleFile;
            String string;
            File file = new File(new File(UpdateTracking.this.directory, "config"), "Modules");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = this.codenamebase;
            int n = string5.indexOf(47);
            if (n > 0) {
                string5 = string5.substring(0, n);
            }
            String string6 = (string = string5.replace('.', '-')).indexOf("modules") > 0 ? string + ".jar" : string.substring(string.lastIndexOf(45) > 0 ? string.lastIndexOf(45) + 1 : 0) + ".jar";
            String string7 = string5.replace('.', '-');
            File file2 = new File(file, string7 + UpdateTracking.XML_EXT);
            if (file2.isFile()) {
                return;
            }
            file2.getParentFile().mkdirs();
            Boolean bl = null;
            Boolean bl2 = null;
            Iterator iterator = this.newVersion.getFiles().iterator();
            boolean bl3 = false;
            while (iterator.hasNext()) {
                moduleFile = (ModuleFile)iterator.next();
                String string8 = moduleFile.getName();
                String string9 = new File(moduleFile.getName()).getParentFile().getName();
                boolean bl4 = bl3 = bl3 || string8.indexOf("modules") >= 0;
                if (string8.endsWith(".jar")) {
                    string2 = moduleFile.getName();
                    if (string6.endsWith(string2) || string2.endsWith(string6)) {
                        string4 = string2;
                        string3 = null;
                        bl = "autoload".equals(string9) ? Boolean.TRUE : Boolean.FALSE;
                        bl2 = "eager".equals(string9) ? Boolean.TRUE : Boolean.FALSE;
                    } else if (string4 == null) {
                        string3 = (string3 == null ? "" : string3 + ", ") + string2;
                    }
                }
                if (bl == null && "autoload".equals(string9)) {
                    bl = Boolean.TRUE;
                }
                if (bl2 != null || !"eager".equals(string9)) continue;
                bl2 = Boolean.TRUE;
            }
            if (!bl3) {
                System.out.println("Warning: No config file written for module " + this.codenamebase + ". No jar file present in \"modules\" directory.");
                return;
            }
            assert (string4 != null || string3 != null) : "No jar file present!";
            if (string4 == null) {
                assert (string3.equals(string2)) : "More files look as module: " + string3;
                if (!string3.equals(string2)) {
                    System.out.println("NBM Error: More files look as module: " + string3);
                    string3 = string2;
                }
            }
            moduleFile = string4 == null ? string3 : string4;
            boolean bl5 = bl != null && bl != false;
            boolean bl6 = bl2 != null && bl2 != false;
            boolean bl7 = !bl5 && !bl6;
            String string10 = this.newVersion.getVersion();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                printWriter.println("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"");
                printWriter.println("                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">");
                printWriter.println("<module name=\"" + string5 + "\">");
                printWriter.println("    <param name=\"autoload\">" + bl5 + "</param>");
                printWriter.println("    <param name=\"eager\">" + bl6 + "</param>");
                if (bl7) {
                    printWriter.println("    <param name=\"enabled\">" + bl7 + "</param>");
                }
                printWriter.println("    <param name=\"jar\">" + (String)((Object)moduleFile) + "</param>");
                printWriter.println("    <param name=\"reloadable\">false</param>");
                printWriter.println("    <param name=\"specversion\">" + string10 + "</param>");
                printWriter.println("</module>");
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        void write() {
            Document document = XMLUtil.createDocument(UpdateTracking.ELEMENT_MODULE);
            Element element = document.getDocumentElement();
            Element element2 = null;
            Element element3 = null;
            element.setAttribute(UpdateTracking.ATTR_CODENAMEBASE, this.getCodenamebase());
            for (Object object : this.getVersions()) {
                element2 = document.createElement(UpdateTracking.ELEMENT_VERSION);
                if (((Version)object).getVersion() != null) {
                    element2.setAttribute(UpdateTracking.ATTR_VERSION, ((Version)object).getVersion());
                }
                element2.setAttribute(UpdateTracking.ATTR_ORIGIN, ((Version)object).getOrigin());
                element2.setAttribute(UpdateTracking.ATTR_LAST, new Boolean(((Version)object).isLast()).toString());
                element2.setAttribute(UpdateTracking.ATTR_INSTALL, Long.toString(((Version)object).getInstall_time()));
                element.appendChild(element2);
                for (ModuleFile moduleFile : ((Version)object).getFiles()) {
                    element3 = document.createElement(UpdateTracking.ELEMENT_FILE);
                    element3.setAttribute(UpdateTracking.ATTR_FILE_NAME, moduleFile.getName());
                    element3.setAttribute(UpdateTracking.ATTR_CRC, moduleFile.getCrc());
                    if (moduleFile.getLocaleversion() != null) {
                        element3.setAttribute(UpdateTracking.ATTR_VERSION, moduleFile.getLocaleversion());
                    }
                    element2.appendChild(element3);
                }
            }
            document.getDocumentElement().normalize();
            try {
                Object object;
                object = new FileOutputStream(this.file);
                XMLUtil.write(document, (OutputStream)object);
                ((OutputStream)object).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void deleteUnusedFiles() {
            if (this.lastVersion == null || this.newVersion == null) {
                return;
            }
            for (ModuleFile moduleFile : this.lastVersion.getFiles()) {
                if (this.newVersion.containsFile(moduleFile) || moduleFile.getName().indexOf(LOCALE_DIR) != -1) continue;
                this.safeDelete(moduleFile);
            }
        }

        private void safeDelete(ModuleFile moduleFile) {
            File file = new File(this.file.getParentFile().getParent() + FILE_SEPARATOR + moduleFile.getName());
            if (file.exists()) {
                try {
                    if (!Long.toString(UpdateTracking.getFileCRC(file)).equals(moduleFile.getCrc())) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    return;
                }
                UpdateTracking.this.scanDir();
                boolean bl = false;
                Iterator iterator = UpdateTracking.this.installedModules.values().iterator();
                while (!bl && iterator.hasNext()) {
                    Version version;
                    Module module = (Module)iterator.next();
                    if (module.equals(this) || (version = module.getNewOrLastVersion()) == null || !version.containsFile(moduleFile)) continue;
                    bl = true;
                }
                if (!bl) {
                    file.delete();
                }
            }
        }

        String getL10NSpecificationVersion(String string) {
            String string2 = null;
            Collections.sort(this.versions);
            for (Version version : this.versions) {
                string2 = version.getLocaleVersion(string);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }
    }

    class ModuleFile {
        private String name;
        private String crc;
        private String localeversion = null;

        ModuleFile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }

        String getCrc() {
            return this.crc;
        }

        void setCrc(String string) {
            this.crc = string;
        }

        public String getLocaleversion() {
            return this.localeversion;
        }

        public void setLocaleversion(String string) {
            this.localeversion = string;
        }
    }

    public class Version
    implements Comparable {
        private String version;
        private String origin;
        private boolean last;
        private long install_time = 0L;
        private List files = new ArrayList();

        String getVersion() {
            return this.version;
        }

        void setVersion(String string) {
            this.version = string;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String string) {
            this.origin = string;
        }

        boolean isLast() {
            return this.last;
        }

        void setLast(boolean bl) {
            this.last = bl;
        }

        long getInstall_time() {
            return this.install_time;
        }

        void setInstall_time(long l) {
            this.install_time = l;
        }

        List getFiles() {
            return this.files;
        }

        void addL10NFiles(List list) {
            for (ModuleFile moduleFile : list) {
                String string = moduleFile.getName();
                for (int i = this.files.size() - 1; i >= 0; --i) {
                    ModuleFile moduleFile2 = (ModuleFile)this.files.get(i);
                    if (!moduleFile2.getName().equals(string)) continue;
                    this.files.remove(i);
                }
            }
            this.files.addAll(list);
        }

        void addFile(ModuleFile moduleFile) {
            this.files.add(moduleFile);
        }

        public void addFileWithCrc(String string, String string2) {
            ModuleFile moduleFile = new ModuleFile();
            moduleFile.setName(string);
            moduleFile.setCrc(string2);
            this.files.add(moduleFile);
        }

        public void addL10NFileWithCrc(String string, String string2, String string3) {
            ModuleFile moduleFile = new ModuleFile();
            moduleFile.setName(string);
            moduleFile.setCrc(string2);
            moduleFile.setLocaleversion(string3);
            this.files.add(moduleFile);
        }

        boolean containsFile(ModuleFile moduleFile) {
            for (ModuleFile moduleFile2 : this.files) {
                if (!moduleFile2.getName().equals(moduleFile.getName())) continue;
                return true;
            }
            return false;
        }

        ModuleFile findFile(String string) {
            for (ModuleFile moduleFile : this.files) {
                if (!moduleFile.getName().equals(string)) continue;
                return moduleFile;
            }
            return null;
        }

        String getLocaleVersion(String string) {
            String string2 = null;
            ModuleFile moduleFile = this.findFile(string);
            if (moduleFile != null && (string2 = moduleFile.getLocaleversion()) == null) {
                string2 = this.version;
            }
            return string2;
        }

        public int compareTo(Object object) {
            Version version = (Version)object;
            if (this.install_time < version.getInstall_time()) {
                return 1;
            }
            if (this.install_time > version.getInstall_time()) {
                return -1;
            }
            return 0;
        }
    }
}

