/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.EditorKit;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AdvancedActionPanel
extends JPanel {
    private static final String ATTR_TARGETS = "org.apache.tools.ant.module.preferredTargets";
    private static final String ATTR_PROPERTIES = "org.apache.tools.ant.module.preferredProperties";
    private static final String ATTR_VERBOSITY = "org.apache.tools.ant.module.preferredVerbosity";
    private static final String[] VERBOSITIES = new String[]{NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_warn"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_info"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_verbose"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_debug")};
    private static final int[] VERBOSITY_LEVELS = new int[]{1, 2, 3, 4};
    private final AntProjectCookie project;
    private final Set<TargetLister.Target> allTargets;
    private String defaultTarget = null;
    private JLabel propertiesLabel;
    private JEditorPane propertiesPane;
    private JScrollPane propertiesScrollPane;
    private JComboBox targetComboBox;
    private JTextField targetDescriptionField;
    private JLabel targetDescriptionLabel;
    private JLabel targetLabel;
    private JComboBox verbosityComboBox;
    private JLabel verbosityLabel;

    public AdvancedActionPanel(AntProjectCookie antProjectCookie, Set<TargetLister.Target> set) {
        this.project = antProjectCookie;
        this.allTargets = set;
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.targetLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.targetDescriptionLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.targetDescriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.propertiesLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.propertiesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.verbosityLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.verbosityLabel.text"));
        EditorKit editorKit = this.propertiesPane.getEditorKit();
        String string = editorKit.getClass().getName();
        if (string.equals("javax.swing.text.DefaultEditorKit") || string.equals("javax.swing.JEditorPane$PlainEditorKit")) {
            this.propertiesPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        }
        this.targetComboBox.getInputMap().remove(KeyStroke.getKeyStroke("ENTER"));
        this.initializeFields();
    }

    /*
     * WARNING - void declaration
     */
    private void initializeFields() {
        Object object;
        FileObject fileObject;
        block9: {
            fileObject = this.project.getFileObject();
            assert (fileObject != null) : "No file found for " + this.project;
            String string = (String)fileObject.getAttribute(ATTR_TARGETS);
            TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
            for (TargetLister.Target object22 : this.allTargets) {
                if (object22.isOverridden() || object22.isInternal()) continue;
                treeSet.add(object22.getName());
                if (this.defaultTarget != null || !object22.isDefault()) continue;
                this.defaultTarget = object22.getName();
            }
            this.targetComboBox.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
            if (string != null) {
                this.targetComboBox.setSelectedItem(string);
            } else {
                this.targetComboBox.setSelectedItem(this.defaultTarget);
            }
            this.targetComboBoxActionPerformed(null);
            object = (String)fileObject.getAttribute(ATTR_PROPERTIES);
            if (object == null) {
                Properties properties = new Properties();
                properties.putAll(AntSettings.getProperties());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    properties.store(byteArrayOutputStream, null);
                    String string2 = byteArrayOutputStream.toString("ISO-8859-1");
                    object = string2.replaceFirst("^#.*\n", "");
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)iOException);
                }
            }
        }
        this.propertiesPane.setText((String)object);
        Integer n = (Integer)fileObject.getAttribute(ATTR_VERBOSITY);
        if (n == null) {
            Integer n2 = AntSettings.getVerbosity();
        }
        this.verbosityComboBox.setModel(new DefaultComboBoxModel<String>(VERBOSITIES));
        for (int i = 0; i < VERBOSITY_LEVELS.length; ++i) {
            void var5_10;
            if (VERBOSITY_LEVELS[i] != var5_10.intValue()) continue;
            this.verbosityComboBox.setSelectedItem(VERBOSITIES[i]);
            break;
        }
    }

    private void initComponents() {
        this.targetLabel = new JLabel();
        this.targetComboBox = new JComboBox();
        this.targetDescriptionLabel = new JLabel();
        this.targetDescriptionField = new JTextField();
        this.propertiesLabel = new JLabel();
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesPane = new JEditorPane();
        this.verbosityLabel = new JLabel();
        this.verbosityComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.targetLabel.setText("Select target(s) to run:");
        this.targetLabel.setLabelFor(this.targetComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.targetLabel, gridBagConstraints);
        this.targetComboBox.setEditable(true);
        this.targetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"sampleTarget1", "sampleTarget2", "sampleTarget3"}));
        this.targetComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedActionPanel.this.targetComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.targetComboBox, gridBagConstraints);
        this.targetDescriptionLabel.setText("Target description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.targetDescriptionLabel, gridBagConstraints);
        this.targetDescriptionField.setEditable(false);
        this.targetDescriptionField.setText("Sample description here.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.targetDescriptionField, gridBagConstraints);
        this.propertiesLabel.setText("Special Ant properties:");
        this.propertiesLabel.setLabelFor(this.propertiesPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 12;
        this.add((Component)this.propertiesLabel, gridBagConstraints);
        this.propertiesScrollPane.setPreferredSize(new Dimension(400, 150));
        this.propertiesScrollPane.setMinimumSize(new Dimension(400, 150));
        this.propertiesPane.setText("# This is sample text for GUI design.\nsomeprop1=someval1\nsomeprop2=someval2\nsomeprop3=someval3\n");
        this.propertiesPane.setContentType("text/x-properties");
        this.propertiesScrollPane.setViewportView(this.propertiesPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
        this.verbosityLabel.setText("Verbosity level:");
        this.verbosityLabel.setLabelFor(this.verbosityComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.verbosityLabel, gridBagConstraints);
        this.verbosityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Errors only [SAMPLE]", "Normal [SAMPLE]", "Verbose [SAMPLE]"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.verbosityComboBox, gridBagConstraints);
    }

    private void targetComboBoxActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.targetComboBox.getSelectedItem();
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        ArrayList arrayList = Collections.list(NbCollections.checkedEnumerationByFilter((Enumeration)stringTokenizer, String.class, (boolean)true));
        String string2 = "";
        if (arrayList.size() == 1) {
            String string3 = (String)arrayList.get(0);
            for (TargetLister.Target target : this.allTargets) {
                if (target.isOverridden() || !target.getName().equals(string3)) continue;
                string2 = target.getElement().getAttribute("description");
                break;
            }
        }
        this.targetDescriptionField.setText(string2);
    }

    public void run() throws IOException {
        Object object;
        Object object2;
        Object object3;
        String string = (String)this.targetComboBox.getSelectedItem();
        String[] stringArray = null;
        if (string != null && !(object3 = Collections.list(NbCollections.checkedEnumerationByFilter((Enumeration)(object2 = new StringTokenizer(string, " ,")), String.class, (boolean)true))).isEmpty()) {
            stringArray = object3.toArray(new String[object3.size()]);
        }
        object2 = new Properties();
        object3 = new ByteArrayInputStream(this.propertiesPane.getText().getBytes("ISO-8859-1"));
        ((Properties)object2).load((InputStream)object3);
        int n = 2;
        String string2 = (String)this.verbosityComboBox.getSelectedItem();
        for (int i = 0; i < VERBOSITIES.length; ++i) {
            if (!VERBOSITIES[i].equals(string2)) continue;
            n = VERBOSITY_LEVELS[i];
            break;
        }
        FileObject fileObject = this.project.getFileObject();
        assert (fileObject != null);
        if (stringArray == null || stringArray.length == 1 && stringArray[0].equals(this.defaultTarget)) {
            fileObject.setAttribute(ATTR_TARGETS, null);
        } else {
            object = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object).append(' ');
                }
                ((StringBuffer)object).append(stringArray[i]);
            }
            fileObject.setAttribute(ATTR_TARGETS, (Object)((StringBuffer)object).toString());
        }
        if (((Properties)object2).equals(AntSettings.getProperties())) {
            fileObject.setAttribute(ATTR_PROPERTIES, null);
        } else {
            fileObject.setAttribute(ATTR_PROPERTIES, (Object)this.propertiesPane.getText());
        }
        if (n == AntSettings.getVerbosity()) {
            fileObject.setAttribute(ATTR_VERBOSITY, null);
        } else {
            fileObject.setAttribute(ATTR_VERBOSITY, (Object)n);
        }
        object = new TargetExecutor(this.project, stringArray);
        ((TargetExecutor)object).setProperties(NbCollections.checkedMapByCopy((Map)object2, String.class, String.class, (boolean)true));
        ((TargetExecutor)object).setVerbosity(n);
        ((TargetExecutor)object).execute();
    }
}

