/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.nodes.AdvancedActionPanel;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class RunTargetsAction
extends SystemAction
implements ContextAwareAction {
    public String getName() {
        return NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_targets_action");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false) : "Action should never be called without a context";
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    private static JMenu createMenu(AntProjectCookie antProjectCookie) {
        return new LazyMenu(antProjectCookie);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdvancedAction
    extends AbstractAction {
        private final AntProjectCookie project;
        private final Set<TargetLister.Target> allTargets;

        public AdvancedAction(AntProjectCookie antProjectCookie, Set<TargetLister.Target> set) {
            super(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_advanced"));
            this.project = antProjectCookie;
            this.allTargets = set;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = NbBundle.getMessage(RunTargetsAction.class, (String)"TITLE_run_advanced");
            AdvancedActionPanel advancedActionPanel = new AdvancedActionPanel(this.project, this.allTargets);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)advancedActionPanel, string);
            dialogDescriptor.setOptionType(2);
            JButton jButton = new JButton(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_advanced_run"));
            jButton.setDefaultCapable(true);
            JButton jButton2 = new JButton(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_advanced_cancel"));
            dialogDescriptor.setOptions(new Object[]{jButton, jButton2});
            dialogDescriptor.setModal(true);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object.equals(jButton)) {
                try {
                    advancedActionPanel.run();
                }
                catch (IOException iOException) {
                    AntModule.err.notify((Throwable)iOException);
                }
            }
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final AntProjectCookie project;

        public ContextAction(Lookup lookup) {
            super(((RunTargetsAction)SystemAction.get(RunTargetsAction.class)).getName());
            Collection collection = lookup.lookupAll(AntProjectCookie.class);
            AntProjectCookie antProjectCookie = null;
            if (collection.size() == 1 && (antProjectCookie = (AntProjectCookie)collection.iterator().next()).getParseException() != null) {
                antProjectCookie = null;
            }
            this.project = antProjectCookie;
            super.setEnabled(this.project != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return RunTargetsAction.createMenu(this.project);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public void setEnabled(boolean bl) {
            assert (false) : "No modifications to enablement status permitted";
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final AntProjectCookie project;
        private boolean initialized = false;

        public LazyMenu(AntProjectCookie antProjectCookie) {
            super(((RunTargetsAction)SystemAction.get(RunTargetsAction.class)).getName());
            this.project = antProjectCookie;
        }

        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                Set<TargetLister.Target> set;
                this.initialized = true;
                try {
                    set = TargetLister.getTargets(this.project);
                }
                catch (IOException iOException) {
                    AntModule.err.notify(1, (Throwable)iOException);
                    set = Collections.emptySet();
                }
                String string = null;
                TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
                TreeSet<Object> treeSet2 = new TreeSet<Object>(Collator.getInstance());
                for (TargetLister.Target object2 : set) {
                    if (object2.isOverridden() || object2.isInternal()) continue;
                    Object object = object2.getName();
                    if (object2.isDefault()) {
                        string = object;
                        continue;
                    }
                    if (object2.isDescribed()) {
                        treeSet.add(object);
                        continue;
                    }
                    treeSet2.add(object);
                }
                boolean bl = false;
                if (string != null) {
                    bl = true;
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.addActionListener(new TargetMenuItemHandler(this.project, string));
                    this.add(jMenuItem);
                }
                if (bl) {
                    bl = false;
                    this.addSeparator();
                }
                if (!treeSet.isEmpty()) {
                    bl = true;
                    for (Object object : treeSet) {
                        Object object2 = new JMenuItem((String)object);
                        ((AbstractButton)object2).addActionListener(new TargetMenuItemHandler(this.project, (String)object));
                        this.add((JMenuItem)object2);
                    }
                }
                if (bl) {
                    bl = false;
                    this.addSeparator();
                }
                if (!treeSet2.isEmpty()) {
                    bl = true;
                    JMenu jMenu = new JMenu(NbBundle.getMessage(RunTargetsAction.class, (String)"LBL_run_other_targets"));
                    for (Object object2 : treeSet2) {
                        JMenuItem jMenuItem = new JMenuItem((String)object2);
                        jMenuItem.addActionListener(new TargetMenuItemHandler(this.project, (String)object2));
                        jMenu.add(jMenuItem);
                    }
                    this.add(jMenu);
                }
                if (bl) {
                    bl = false;
                    this.addSeparator();
                }
                this.add(new AdvancedAction(this.project, set));
            }
            return super.getPopupMenu();
        }
    }

    private static final class TargetMenuItemHandler
    implements ActionListener,
    Runnable {
        private final AntProjectCookie project;
        private final String target;

        public TargetMenuItemHandler(AntProjectCookie antProjectCookie, String string) {
            this.project = antProjectCookie;
            this.target = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            try {
                TargetExecutor targetExecutor = new TargetExecutor(this.project, new String[]{this.target});
                targetExecutor.execute();
            }
            catch (IOException iOException) {
                AntModule.err.notify((Throwable)iOException);
            }
        }
    }
}

