/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.module.AntModule;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class Hyperlink
extends Annotation
implements OutputListener,
PropertyChangeListener {
    private static final Set<Hyperlink> hyperlinks = new WeakSet();
    private final URL url;
    private final String message;
    private final int line1;
    private int col1;
    private final int line2;
    private final int col2;
    private Line liveLine;
    private boolean masked;
    private boolean dead = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            Iterator<Hyperlink> iterator = hyperlinks.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hyperlink(URL uRL, String string, int n, int n2, int n3, int n4) {
        this.url = uRL;
        this.message = string;
        this.line1 = n;
        this.col1 = n2;
        this.line2 = n3;
        this.col2 = n4;
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            hyperlinks.add(this);
        }
    }

    public void setColumn1(int n) {
        if (this.col1 == -1) {
            this.col1 = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        this.doDetach();
        this.dead = true;
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            this.liveLine = null;
        }
    }

    public void outputLineAction(OutputEvent outputEvent) {
        block11: {
            if (this.dead) {
                return;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)this.url);
            if (fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null && fileObject == dataObject.getPrimaryFile()) {
                    if (this.line1 == -1) {
                        editorCookie.open();
                        break block11;
                    }
                    editorCookie.openDocument();
                    AntModule.err.log("opened document for " + fileObject);
                    try {
                        Line line = this.updateLines(editorCookie);
                        if (line.isDeleted()) break block11;
                        this.attachAsNeeded(line);
                        if (this.col1 == -1) {
                            line.show(2);
                            break block11;
                        }
                        line.show(2, this.col1 - 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        editorCookie.open();
                    }
                    break block11;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
        if (this.message != null) {
            StatusDisplayer.getDefault().setStatusText(this.message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Line updateLines(EditorCookie editorCookie) {
        Line.Set set = editorCookie.getLineSet();
        Set<Hyperlink> set2 = hyperlinks;
        synchronized (set2) {
            assert (this.line1 != -1);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.liveLine == null) {
                bl = true;
                for (Hyperlink hyperlink : hyperlinks) {
                    if (hyperlink == this) {
                        bl2 = true;
                    }
                    if (hyperlink.liveLine != null || !hyperlink.url.equals(this.url) || hyperlink.line1 == -1) continue;
                    Line line = set.getOriginal(hyperlink.line1 - 1);
                    assert (line != null) : hyperlink;
                    hyperlink.liveLine = line;
                    if (hyperlink != this) continue;
                    bl3 = true;
                }
            }
            assert (this.liveLine != null) : "this=" + this + " ran=" + bl + " encounteredThis=" + bl2 + " modifiedThis=" + bl3 + " hyperlinks=" + hyperlinks + " hyperlinks.contains(this)=" + hyperlinks.contains(this);
            return this.liveLine;
        }
    }

    public void outputLineSelected(OutputEvent outputEvent) {
        if (this.dead) {
            return;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)this.url);
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null) {
                Line line;
                if (editorCookie.getDocument() == null) {
                    AntModule.err.log("no document for " + fileObject);
                    return;
                }
                AntModule.err.log("got document for " + fileObject);
                if (this.line1 != -1 && !(line = this.updateLines(editorCookie)).isDeleted()) {
                    this.attachAsNeeded(line);
                    if (this.col1 == -1) {
                        line.show(0);
                    } else {
                        line.show(0, this.col1 - 1);
                    }
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void attachAsNeeded(Line line) {
        if (this.getAttachedAnnotatable() == null) {
            Line line2;
            boolean bl = AntModule.err.isLoggable(1);
            this.masked |= line.getAnnotationCount() > 0;
            if (this.masked) {
                return;
            }
            String string = line.getText();
            if (bl) {
                AntModule.err.log("Attaching to line " + line.getDisplayName() + " text=`" + string + "' line1=" + this.line1 + " line2=" + this.line2 + " col1=" + this.col1 + " col2=" + this.col2);
            }
            if (string != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                int n = this.convertTabColumnsToCharacterColumns(string, this.col1 - 1, 8);
                int n2 = this.convertTabColumnsToCharacterColumns(string, this.col2 - 1, 8);
                if (bl) {
                    AntModule.err.log("\tfits on one line");
                }
                if (n2 != -1 && n2 >= n && n2 < string.length()) {
                    if (bl) {
                        AntModule.err.log("\tspecified section of the line");
                    }
                    line2 = line.createPart(n, n2 - n + 1);
                } else if (n < string.length()) {
                    if (bl) {
                        AntModule.err.log("\tspecified column to end of line");
                    }
                    line2 = line.createPart(n, string.length() - n - 1);
                } else {
                    if (bl) {
                        AntModule.err.log("\tcolumn numbers are bogus");
                    }
                    line2 = line;
                }
            } else {
                if (bl) {
                    AntModule.err.log("\tmultiple lines, something wrong with line, or no column given");
                }
                line2 = line;
            }
            this.attach((Annotatable)line2);
            Set<Hyperlink> set = hyperlinks;
            synchronized (set) {
                for (Hyperlink hyperlink : hyperlinks) {
                    if (hyperlink == this) continue;
                    hyperlink.doDetach();
                }
            }
            line2.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private int convertTabColumnsToCharacterColumns(String string, int n, int n2) {
        int n3;
        char[] cArray = string.toCharArray();
        int n4 = 0;
        for (n3 = 0; n3 < cArray.length && n4 < n; ++n3) {
            if (cArray[n3] == '\t') {
                n4 += n2 - n4 % n2;
                continue;
            }
            ++n4;
        }
        return n3;
    }

    private synchronized void doDetach() {
        Annotatable annotatable = this.getAttachedAnnotatable();
        if (annotatable != null) {
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("Detaching from " + annotatable + " `" + annotatable.getText() + "'");
            }
            annotatable.removePropertyChangeListener((PropertyChangeListener)this);
            this.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputLineCleared(OutputEvent outputEvent) {
        this.doDetach();
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            this.liveLine = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Annotatable annotatable;
        if (this.dead) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == null || string.equals("text") || string.equals("deleted")) {
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("Received Annotatable property change: " + string);
            }
            this.doDetach();
        }
        if ("annotationCount".equals(string) && (annotatable = this.getAttachedAnnotatable()) != null) {
            int n = annotatable.getAnnotationCount();
            if (annotatable instanceof Line.Part) {
                n += ((Line.Part)annotatable).getLine().getAnnotationCount();
            }
            if (n > 1) {
                this.masked = true;
                this.doDetach();
            }
        }
    }

    public String getAnnotationType() {
        return "org-apache-tools-ant-module-error";
    }

    public String getShortDescription() {
        return this.message;
    }

    public String toString() {
        return "Hyperlink[" + this.url + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
    }
}

