/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastTargetExecuted {
    private static File buildScript;
    private static int verbosity;
    private static String[] targets;
    private static Map<String, String> properties;
    private static final List<ChangeListener> listeners;

    private LastTargetExecuted() {
    }

    static void record(File file, int n, String[] stringArray, Map<String, String> map) {
        buildScript = file;
        verbosity = n;
        targets = stringArray;
        properties = map;
        LastTargetExecuted.fireChange();
    }

    public static AntProjectCookie getLastBuildScript() {
        block4: {
            if (buildScript != null && buildScript.isFile()) {
                FileObject fileObject = FileUtil.toFileObject((File)buildScript);
                assert (fileObject != null);
                try {
                    return (AntProjectCookie)DataObject.find((FileObject)fileObject).getCookie(AntProjectCookie.class);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)dataObjectNotFoundException);
                }
            }
        }
        return null;
    }

    public static String[] getLastTargets() {
        return targets;
    }

    public static String getProcessDisplayName() {
        AntProjectCookie antProjectCookie = LastTargetExecuted.getLastBuildScript();
        if (antProjectCookie != null) {
            return TargetExecutor.getProcessDisplayName(antProjectCookie, targets != null ? Arrays.asList(targets) : null);
        }
        return null;
    }

    public static ExecutorTask rerun() throws IOException {
        AntProjectCookie antProjectCookie = LastTargetExecuted.getLastBuildScript();
        if (antProjectCookie == null) {
            LastTargetExecuted.fireChange();
            return null;
        }
        TargetExecutor targetExecutor = new TargetExecutor(antProjectCookie, targets);
        targetExecutor.setVerbosity(verbosity);
        targetExecutor.setProperties(properties);
        return targetExecutor.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = listeners;
        synchronized (list) {
            listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = listeners;
        synchronized (list) {
            listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(LastTargetExecuted.class);
        ChangeListener[] changeListenerArray = listeners;
        synchronized (listeners) {
            ChangeListener[] changeListenerArray2 = listeners.toArray(new ChangeListener[listeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ChangeListener changeListener : changeListenerArray2) {
                changeListener.stateChanged(changeEvent);
            }
            return;
        }
    }

    static {
        listeners = new ArrayList<ChangeListener>();
    }
}

