/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.run.Hyperlink;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.OutputListener;

public final class StandardLogger
extends AntLogger {
    private static final Logger ERR = Logger.getLogger(StandardLogger.class.getName());
    private static final Pattern CARET_SHOWING_COLUMN = Pattern.compile("^( *)\\^$");
    private static final Pattern CWD_ENTER = Pattern.compile(".*Entering directory [`'\"]?([^`'\"]+)(['\"]|$|\\.\\.\\.$)");
    private static final Pattern CWD_LEAVE = Pattern.compile(".*Leaving directory [`'\"]?([^`'\"]+)(['\"]|$|\\.\\.\\.$)");
    private static final Pattern HYPERLINK = Pattern.compile("\"?(.+?)\"?(?::|, line )(?:(\\d+):(?:(\\d+):(?:(\\d+):(\\d+):)?)?)? +(.+)");
    private final long mockTotalTime;

    public StandardLogger() {
        this.mockTotalTime = 0L;
    }

    StandardLogger(long l) {
        this.mockTotalTime = l;
    }

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return AntLogger.ALL_TASKS;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        int n = antSession.getVerbosity();
        assert (n >= 0 && n <= 4) : n;
        int[] nArray = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private SessionData getSessionData(AntSession antSession) {
        SessionData sessionData = (SessionData)antSession.getCustomData(this);
        if (sessionData == null) {
            sessionData = new SessionData();
            antSession.putCustomData(this, sessionData);
        }
        return sessionData;
    }

    public void buildInitializationFailed(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        Throwable throwable = antEvent.getException();
        if (antEvent.getSession().getVerbosity() >= 3) {
            StandardLogger.deliverStackTrace(throwable, antEvent);
        } else {
            antEvent.getSession().println(throwable.toString(), true, null);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_failed_status", (Object)antEvent.getSession().getDisplayName()));
        antEvent.consume();
    }

    private static void deliverBlockOfTextAsLines(String string, AntEvent antEvent, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            antEvent.getSession().deliverMessageLogged(antEvent, string2, n);
        }
    }

    private static void deliverStackTrace(Throwable throwable, AntEvent antEvent) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        StandardLogger.deliverBlockOfTextAsLines(stringWriter.toString(), antEvent, 0);
    }

    public void buildStarted(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        this.getSessionData((AntSession)antEvent.getSession()).startTime = System.currentTimeMillis();
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_running_ant", (Object)antEvent.getSession().getDisplayName()));
        antEvent.consume();
    }

    public void buildFinished(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        AntSession antSession = antEvent.getSession();
        Throwable throwable = antEvent.getException();
        long l = System.currentTimeMillis() - this.getSessionData((AntSession)antSession).startTime;
        if (this.mockTotalTime != 0L) {
            l = this.mockTotalTime;
        }
        if (throwable == null) {
            antSession.println(StandardLogger.formatMessageWithTime("FMT_finished_target_printed", l), false, null);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_finished_target_status", (Object)antSession.getDisplayName()));
        } else {
            if (throwable.getCause() instanceof ThreadDeath) {
                throwable = throwable.getCause();
            }
            if (!antSession.isExceptionConsumed(throwable)) {
                antSession.consumeException(throwable);
                if (throwable.getClass().getName().equals("org.apache.tools.ant.BuildException") && antSession.getVerbosity() < 3) {
                    String string = throwable.toString();
                    StandardLogger.deliverBlockOfTextAsLines(string, antEvent, 0);
                } else if (!(throwable instanceof ThreadDeath) || antEvent.getSession().getVerbosity() >= 3) {
                    StandardLogger.deliverStackTrace(throwable, antEvent);
                }
            }
            if (throwable instanceof ThreadDeath) {
                antEvent.getSession().println(StandardLogger.formatMessageWithTime("FMT_target_stopped_printed", l), true, null);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_stopped_status", (Object)antEvent.getSession().getDisplayName()));
            } else {
                antEvent.getSession().println(StandardLogger.formatMessageWithTime("FMT_target_failed_printed", l), true, null);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_failed_status", (Object)antEvent.getSession().getDisplayName()));
            }
        }
        antEvent.consume();
    }

    private static String formatMessageWithTime(String string, long l) {
        int n = (int)(l / 1000L);
        int n2 = n / 60;
        int n3 = n % 60;
        return NbBundle.getMessage(StandardLogger.class, (String)string, (Object)new Integer(n2), (Object)new Integer(n3));
    }

    public void targetStarted(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        String string = antEvent.getTargetName();
        if (string != null) {
            int n;
            int n2 = n = string.length() > 0 && string.charAt(0) == '-' ? 3 : 2;
            if (antEvent.getSession().getVerbosity() >= n) {
                antEvent.getSession().println(NbBundle.getMessage(StandardLogger.class, (String)"MSG_target_started_printed", (Object)string), false, null);
            }
        }
        antEvent.consume();
    }

    public void messageLogged(AntEvent antEvent) {
        Stack<File> stack;
        Object object;
        if (antEvent.isConsumed()) {
            return;
        }
        antEvent.consume();
        AntSession antSession = antEvent.getSession();
        String string = antEvent.getMessage();
        ERR.log(Level.FINE, "Received message: {0}", string);
        if (string.indexOf(10) != -1) {
            StandardLogger.deliverBlockOfTextAsLines(string, antEvent, antEvent.getLogLevel());
            return;
        }
        Matcher matcher = CARET_SHOWING_COLUMN.matcher(string);
        if (matcher.matches()) {
            ERR.fine("  Looks like a special caret line");
            object = this.getSessionData(antSession);
            if (((SessionData)object).lastHyperlink != null) {
                ((SessionData)object).lastHyperlink.setColumn1(matcher.group(1).length() + 1);
                ((SessionData)object).lastHyperlink = null;
                return;
            }
        }
        if ((matcher = CWD_ENTER.matcher(string)).matches()) {
            ERR.fine("  Looks like a change of CWD");
            object = new File(matcher.group(1));
            if (((File)object).isDirectory()) {
                stack = this.getSessionData((AntSession)antSession).currentDir;
                stack.push((File)object);
                ERR.log(Level.FINE, "  ...is a change of CWD; stack now: {0}", stack);
            }
        }
        if ((matcher = CWD_LEAVE.matcher(string)).matches()) {
            ERR.fine("  Looks like a change of CWD back out");
            object = new File(matcher.group(1));
            stack = this.getSessionData((AntSession)antSession).currentDir;
            if (stack.empty()) {
                ERR.log(Level.FINE, "  ...but there was nowhere to change out of");
            } else {
                File file = stack.pop();
                if (!file.equals(object)) {
                    ERR.log(Level.FINE, "  ...stack mismatch: {0} vs. {1}", new Object[]{file, object});
                }
            }
        }
        if ((object = this.findHyperlink(antSession, string)) instanceof Hyperlink) {
            this.getSessionData((AntSession)antSession).lastHyperlink = (Hyperlink)object;
        }
        antEvent.getSession().println(string, antEvent.getLogLevel() <= 1, (OutputListener)object);
    }

    public void taskFinished(AntEvent antEvent) {
        this.getSessionData((AntSession)antEvent.getSession()).lastHyperlink = null;
    }

    private OutputListener findHyperlink(AntSession antSession, String string) {
        File file;
        Stack<File> stack = this.getSessionData((AntSession)antSession).currentDir;
        Matcher matcher = HYPERLINK.matcher(string);
        if (!matcher.matches()) {
            ERR.fine("does not look like a hyperlink");
            return null;
        }
        String string2 = matcher.group(1);
        if (string2.startsWith("file:")) {
            try {
                file = new File(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                ERR.log(Level.FINE, "invalid URI, skipping", uRISyntaxException);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ERR.log(Level.FINE, "invalid URI, skipping", illegalArgumentException);
                return null;
            }
        } else {
            file = new File(string2);
            if (!file.isAbsolute()) {
                if (stack.isEmpty()) {
                    ERR.fine("Non-absolute path with no CWD, skipping");
                    return null;
                }
                file = new File(stack.peek(), string2);
            }
        }
        if (!file.exists()) {
            ERR.log(Level.FINE, "no such file {0}, skipping", file);
            return null;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String string3 = matcher.group(2);
        try {
            if (string3 != null) {
                n = Integer.parseInt(string3);
                string3 = matcher.group(3);
                if (string3 != null) {
                    n2 = Integer.parseInt(string3);
                    string3 = matcher.group(4);
                    if (string3 != null) {
                        n3 = Integer.parseInt(string3);
                        n4 = Integer.parseInt(matcher.group(5));
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            ERR.log(Level.FINE, "bad line/col #", numberFormatException);
            return null;
        }
        String string4 = matcher.group(6);
        file = FileUtil.normalizeFile((File)file);
        ERR.log(Level.FINE, "Hyperlink: {0} [{1}:{2}:{3}:{4}]: {5}", new Object[]{file, n, n2, n3, n4, string4});
        try {
            return antSession.createStandardHyperlink(file.toURI().toURL(), string4, n, n2, n3, n4);
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : malformedURLException;
            return null;
        }
    }

    private static final class SessionData {
        public long startTime;
        public Hyperlink lastHyperlink;
        public Stack<File> currentDir = new Stack();
    }
}

