/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.xml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AntProjectSupport
implements AntProjectCookie.ParseStatus,
DocumentListener,
PropertyChangeListener {
    private FileObject fo;
    private Document projDoc = null;
    private Throwable exception = null;
    private boolean parsed = false;
    private Reference<StyledDocument> styledDocRef = null;
    private Object parseLock;
    private Set<ChangeListener> listeners;
    private EditorCookie.Observable editor = null;
    private DocumentBuilder documentBuilder;
    private static final int REPARSE_DELAY = 3000;
    private final RequestProcessor rp;
    private RequestProcessor.Task task = null;

    public AntProjectSupport(FileObject fileObject) {
        this.fo = fileObject;
        this.parseLock = new Object();
        this.listeners = new HashSet<ChangeListener>();
        this.rp = new RequestProcessor("AntProjectSupport[" + fileObject + "]");
    }

    private synchronized EditorCookie.Observable getEditor() {
        FileObject fileObject = this.getFileObject();
        if (fileObject == null) {
            return null;
        }
        if (this.editor == null) {
            try {
                this.editor = (EditorCookie.Observable)DataObject.find((FileObject)fileObject).getCookie(EditorCookie.Observable.class);
                if (this.editor != null) {
                    this.editor.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.editor));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                AntModule.err.notify(1, (Throwable)dataObjectNotFoundException);
            }
        }
        return this.editor;
    }

    public File getFile() {
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            return FileUtil.toFile((FileObject)fileObject);
        }
        return null;
    }

    public FileObject getFileObject() {
        if (this.fo != null && !this.fo.isValid()) {
            return null;
        }
        return this.fo;
    }

    public void setFile(File file) {
        this.fo = FileUtil.toFileObject((File)file);
        this.invalidate();
    }

    public void setFileObject(FileObject fileObject) {
        this.fo = fileObject;
        this.invalidate();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() {
        if (this.parsed) {
            return this.projDoc;
        }
        Object object = this.parseLock;
        synchronized (object) {
            if (this.parsed) {
                return this.projDoc;
            }
            this.parseDocument();
            return this.projDoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getParseException() {
        if (this.parsed) {
            return this.exception;
        }
        Object object = this.parseLock;
        synchronized (object) {
            if (this.parsed) {
                return this.exception;
            }
            this.parseDocument();
            return this.exception;
        }
    }

    private static synchronized DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(ErrHandler.DEFAULT);
        return documentBuilder;
    }

    public static InputSource createInputSource(FileObject fileObject, final StyledDocument styledDocument) throws IOException {
        InputSource inputSource;
        block7: {
            String[] stringArray;
            block6: {
                if (fileObject != null && !(stringArray = DataObject.find((FileObject)fileObject)).isModified()) {
                    try {
                        return new InputSource(fileObject.getURL().toExternalForm());
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError((Object)fileStateInvalidException);
                    }
                }
            }
            stringArray = new String[1];
            styledDocument.render(new Runnable(){

                public void run() {
                    try {
                        stringArray[0] = styledDocument.getText(0, styledDocument.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        throw new AssertionError((Object)badLocationException);
                    }
                }
            });
            inputSource = new InputSource(new StringReader(stringArray[0]));
            if (fileObject != null) {
                try {
                    inputSource.setSystemId(fileObject.getURL().toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)fileStateInvalidException);
                }
            }
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDocument() {
        block14: {
            assert (Thread.holdsLock(this.parseLock));
            FileObject fileObject = this.getFileObject();
            AntModule.err.log("AntProjectSupport.parseDocument: fo=" + fileObject);
            try {
                Document document;
                EditorCookie.Observable observable;
                if (this.documentBuilder == null) {
                    this.documentBuilder = AntProjectSupport.createDocumentBuilder();
                }
                if ((observable = this.getEditor()) != null) {
                    StyledDocument styledDocument = observable.openDocument();
                    if (this.styledDocRef != null && this.styledDocRef.get() != styledDocument || this.styledDocRef == null) {
                        styledDocument.addDocumentListener(this);
                        this.styledDocRef = new WeakReference<StyledDocument>(styledDocument);
                    }
                    InputSource inputSource = AntProjectSupport.createInputSource(fileObject, styledDocument);
                    document = this.documentBuilder.parse(inputSource);
                } else {
                    if (fileObject != null) {
                        InputStream inputStream = fileObject.getInputStream();
                        try {
                            block13: {
                                InputSource inputSource = new InputSource(inputStream);
                                try {
                                    inputSource.setSystemId(fileObject.getURL().toExternalForm());
                                }
                                catch (FileStateInvalidException fileStateInvalidException) {
                                    if ($assertionsDisabled) break block13;
                                    throw new AssertionError((Object)fileStateInvalidException);
                                }
                            }
                            document = this.documentBuilder.parse(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    this.exception = new FileNotFoundException("Ant script probably deleted");
                    return;
                }
                this.projDoc = document;
                this.exception = null;
            }
            catch (Exception exception) {
                this.exception = exception;
                if (this.exception instanceof SAXParseException) break block14;
                AntModule.err.annotate(this.exception, 0, "Strange parse error in " + this, null, null, null);
                AntModule.err.notify(1, this.exception);
            }
        }
        this.fireChangeEvent(false);
        this.parsed = true;
    }

    public Element getProjectElement() {
        Document document = this.getDocument();
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AntProjectSupport)) {
            return false;
        }
        AntProjectSupport antProjectSupport = (AntProjectSupport)object;
        if (this.fo != null) {
            return this.fo.equals(antProjectSupport.fo);
        }
        return false;
    }

    public int hashCode() {
        return 0x6CB1 ^ (this.fo != null ? this.fo.hashCode() : 0);
    }

    public String toString() {
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            return fileObject.toString();
        }
        return "<missing Ant script>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent(boolean bl) {
        Iterator<ChangeListener> iterator;
        AntModule.err.log("AntProjectSupport.fireChangeEvent: fo=" + this.fo);
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        ChangeFirer changeFirer = new ChangeFirer(iterator, (ChangeEvent)object);
        AntProjectSupport antProjectSupport = this;
        synchronized (antProjectSupport) {
            if (this.task == null) {
                this.task = this.rp.post((Runnable)changeFirer, bl ? 3000 : 0);
            } else if (!bl) {
                this.task.schedule(0);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.invalidate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.invalidate();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            this.invalidate();
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        this.invalidate();
    }

    protected final void invalidate() {
        AntModule.err.log("AntProjectSupport.invalidate: fo=" + this.fo);
        this.parsed = false;
        this.fireChangeEvent(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ChangeFirer
    implements Runnable {
        private final Iterator<ChangeListener> it;
        private final ChangeEvent ev;

        public ChangeFirer(Iterator<ChangeListener> iterator, ChangeEvent changeEvent) {
            this.it = iterator;
            this.ev = changeEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AntModule.err.log("AntProjectSupport.ChangeFirer.run");
            AntProjectSupport antProjectSupport = AntProjectSupport.this;
            synchronized (antProjectSupport) {
                if (AntProjectSupport.this.task == null) {
                    return;
                }
                AntProjectSupport.this.task = null;
            }
            while (this.it.hasNext()) {
                try {
                    this.it.next().stateChanged(this.ev);
                }
                catch (RuntimeException runtimeException) {
                    AntModule.err.notify((Throwable)runtimeException);
                }
            }
        }
    }

    private static final class ErrHandler
    implements ErrorHandler {
        static final ErrorHandler DEFAULT = new ErrHandler();

        private ErrHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

