/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.BreakIterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Keymap;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NotifyDescriptor {
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_MESSAGE_TYPE = "messageType";
    public static final String PROP_OPTION_TYPE = "optionType";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_VALUE = "value";
    public static final String PROP_TITLE = "title";
    public static final String PROP_DETAIL = "detail";
    public static final String PROP_VALID = "valid";
    public static final Object YES_OPTION = new Integer(0);
    public static final Object NO_OPTION = new Integer(1);
    public static final Object CANCEL_OPTION = new Integer(2);
    public static final Object OK_OPTION = new Integer(0);
    public static final Object CLOSED_OPTION = new Integer(-1);
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private static final int MAXIMUM_TEXT_WIDTH = 100;
    private static final int SIZE_PREFERRED_WIDTH = 300;
    private static final int SIZE_PREFERRED_HEIGHT = 100;
    private Object message;
    private int messageType = -1;
    private int optionType;
    private Object[] options;
    private Object[] adOptions;
    private Object value;
    private Object defaultValue;
    private String title;
    private boolean valid = true;
    private PropertyChangeSupport changeSupport;

    public NotifyDescriptor(Object object, String string, int n, int n2, Object[] objectArray, Object object2) {
        this.message = object;
        this.messageType = n2;
        this.options = objectArray;
        this.optionType = n;
        this.title = string;
        this.value = object2;
        this.defaultValue = object2;
    }

    protected void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getterCalled() {
        boolean bl = false;
        NotifyDescriptor notifyDescriptor = this;
        synchronized (notifyDescriptor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
                bl = true;
            }
        }
        if (bl) {
            this.initialize();
        }
    }

    public final boolean isValid() {
        this.getterCalled();
        return this.valid;
    }

    public final void setValid(boolean bl) {
        boolean bl2 = this.valid;
        this.valid = bl;
        this.firePropertyChange(PROP_VALID, bl2 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setMessage(Object object) {
        Object object2 = this.message;
        if (object instanceof String) {
            JTextArea jTextArea = new JTextArea((String)object);
            jTextArea.setPreferredSize(new Dimension(300, 100));
            jTextArea.setBackground(UIManager.getColor("Label.background"));
            jTextArea.setBorder(BorderFactory.createEmptyBorder());
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACN_NotifyDescriptor_MessageJTextArea"));
            jTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACD_NotifyDescriptor_MessageJTextArea"));
            object = jTextArea;
        }
        this.message = object;
        this.firePropertyChange(PROP_MESSAGE, object2, object);
    }

    public Object getMessage() {
        this.getterCalled();
        return this.message;
    }

    public void setMessageType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != -1) {
            throw new IllegalArgumentException("Message type must be one of the following: ERROR_MESSAGE, INFORMATION_MESSAGE, WARNING_MESSAGE, QUESTION_MESSAGE or PLAIN_MESSAGE.");
        }
        int n2 = this.messageType;
        this.messageType = n;
        this.firePropertyChange(PROP_MESSAGE_TYPE, new Integer(n2), new Integer(this.messageType));
    }

    public int getMessageType() {
        this.getterCalled();
        return this.messageType;
    }

    public void setOptionType(int n) {
        if (n != -1 && n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Option type must be one of the following: DEFAULT_OPTION, YES_NO_OPTION, YES_NO_CANCEL_OPTION or OK_CANCEL_OPTION.");
        }
        int n2 = this.optionType;
        this.optionType = n;
        this.firePropertyChange(PROP_OPTION_TYPE, new Integer(n2), new Integer(this.optionType));
    }

    public int getOptionType() {
        this.getterCalled();
        return this.optionType;
    }

    public void setOptions(Object[] objectArray) {
        Object[] objectArray2 = this.options;
        this.options = objectArray;
        this.firePropertyChange(PROP_OPTIONS, objectArray2, objectArray);
    }

    public Object[] getOptions() {
        this.getterCalled();
        if (this.options != null) {
            return (Object[])this.options.clone();
        }
        return this.options;
    }

    public void setAdditionalOptions(Object[] objectArray) {
        Object[] objectArray2 = this.adOptions;
        this.adOptions = objectArray;
        this.firePropertyChange(PROP_OPTIONS, objectArray2, objectArray);
    }

    public Object[] getAdditionalOptions() {
        this.getterCalled();
        if (this.adOptions != null) {
            return (Object[])this.adOptions.clone();
        }
        return null;
    }

    void setValueWithoutPCH(Object object) {
        this.value = object;
    }

    public void setValue(Object object) {
        Object object2 = this.value;
        this.setValueWithoutPCH(object);
        this.firePropertyChange(PROP_VALUE, object2, object);
    }

    public Object getValue() {
        this.getterCalled();
        return this.value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(PROP_TITLE, string2, string);
    }

    public String getTitle() {
        this.getterCalled();
        return this.title;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getterCalled();
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected static String getTitleForType(int n) {
        switch (n) {
            case 0: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_ErrorTitle");
            }
            case 2: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_WarningTitle");
            }
            case 3: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_QuestionTitle");
            }
            case 1: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_InformationTitle");
            }
            case -1: {
                return NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_PlainTitle");
            }
        }
        return "";
    }

    public static class Confirmation
    extends NotifyDescriptor {
        public Confirmation(Object object) {
            this(object, 1);
        }

        public Confirmation(Object object, String string) {
            this(object, string, 1);
        }

        public Confirmation(Object object, int n) {
            this(object, n, 3);
        }

        public Confirmation(Object object, String string, int n) {
            this(object, string, n, 3);
        }

        public Confirmation(Object object, int n, int n2) {
            Object[] objectArray;
            String string = NotifyDescriptor.getTitleForType(n2);
            if (n == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = OK_OPTION;
            } else {
                objectArray = null;
            }
            super(object, string, n, n2, objectArray, OK_OPTION);
        }

        public Confirmation(Object object, String string, int n, int n2) {
            Object[] objectArray;
            if (n == -1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = OK_OPTION;
            } else {
                objectArray = null;
            }
            super(object, string, n, n2, objectArray, OK_OPTION);
        }
    }

    public static final class Exception
    extends Confirmation {
        static final long serialVersionUID = -3387516993124229948L;

        public Exception(Throwable throwable) {
            this(throwable, (Object)throwable.getMessage());
            Object object;
            if (throwable instanceof InvocationTargetException) {
                object = ((InvocationTargetException)throwable).getTargetException();
                this.setMessage(object);
                Object object2 = this.getMessage();
                if (object2 == null || "".equals(object2)) {
                    String string = ((Throwable)object).getMessage();
                    string = Utilities.wrapString((String)string, (int)100, (BreakIterator)BreakIterator.getCharacterInstance(), (boolean)false);
                    this.setMessage(string);
                }
            }
            if ((object = this.getMessage()) == null || "".equals(object)) {
                this.setMessage(NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_ExceptionalException", (Object)throwable.getClass().getName(), (Object)(System.getProperty("netbeans.user") + File.separator + "system")));
                this.setTitle(NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_ExceptionalExceptionTitle"));
            }
        }

        public Exception(Throwable throwable, Object object) {
            super(object, -1, 0);
            this.setTitle(NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_ExceptionTitle"));
        }
    }

    public static class InputLine
    extends NotifyDescriptor {
        protected JTextField textField;

        public InputLine(String string, String string2) {
            this(string, string2, 2, -1);
        }

        public InputLine(String string, String string2, int n, int n2) {
            super(null, string2, n, n2, null, null);
            super.setMessage(this.createDesign(string));
        }

        public String getInputText() {
            return this.textField.getText();
        }

        public void setInputText(String string) {
            this.textField.setText(string);
            this.textField.selectAll();
        }

        protected Component createDesign(String string) {
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
            jLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(11, 12, 1, 11));
            this.textField = new JTextField(25);
            jPanel.add("West", jLabel);
            jPanel.add("Center", this.textField);
            jLabel.setLabelFor(this.textField);
            this.textField.setBorder(new CompoundBorder(this.textField.getBorder(), new EmptyBorder(2, 0, 2, 0)));
            this.textField.requestFocus();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            Keymap keymap = this.textField.getKeymap();
            keymap.removeKeyStrokeBinding(keyStroke);
            jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
            return jPanel;
        }
    }

    public static class Message
    extends NotifyDescriptor {
        public Message(Object object) {
            this(object, 1);
        }

        public Message(Object object, int n) {
            super(object, NotifyDescriptor.getTitleForType(n), -1, n, new Object[]{OK_OPTION}, OK_OPTION);
        }
    }
}

