/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.options.OptionsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public class OptionsDisplayerImpl {
    private static Dialog dialog;
    private static WeakReference<DialogDescriptor> descriptorRef;
    private static String title;
    private static Logger log;
    private boolean modal;

    public OptionsDisplayerImpl(boolean bl) {
        this.modal = bl;
    }

    public boolean isOpen() {
        return dialog != null;
    }

    public void showOptionsDialog(String string) {
        if (this.isOpen()) {
            dialog.setVisible(true);
            dialog.toFront();
            log.fine("Front Options Dialog");
            return;
        }
        DialogDescriptor dialogDescriptor = (DialogDescriptor)descriptorRef.get();
        OptionsPanel optionsPanel = null;
        if (dialogDescriptor == null) {
            optionsPanel = string == null ? new OptionsPanel() : new OptionsPanel(string);
            JButton jButton = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_OK");
            JButton jButton2 = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Classic");
            boolean bl = Utilities.isMac();
            Object[] objectArray = new Object[]{bl ? DialogDescriptor.CANCEL_OPTION : jButton, bl ? jButton : DialogDescriptor.CANCEL_OPTION};
            dialogDescriptor = new DialogDescriptor((Object)optionsPanel, title, this.modal, objectArray, DialogDescriptor.OK_OPTION, 0, null, null);
            dialogDescriptor.setAdditionalOptions(new Object[]{jButton2});
            dialogDescriptor.setHelpCtx(optionsPanel.getHelpCtx());
            OptionsPanelListener optionsPanelListener = new OptionsPanelListener(dialogDescriptor, optionsPanel, jButton, jButton2);
            dialogDescriptor.setButtonListener((ActionListener)optionsPanelListener);
            optionsPanel.addPropertyChangeListener(optionsPanelListener);
            descriptorRef = new WeakReference<DialogDescriptor>(dialogDescriptor);
            log.fine("Create new Options Dialog");
        } else {
            optionsPanel = (OptionsPanel)dialogDescriptor.getMessage();
            optionsPanel.update();
            log.fine("Reopen Options Dialog");
        }
        dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        optionsPanel.initCurrentCategory(string);
        dialog.addWindowListener(new MyWindowListener(optionsPanel));
        dialog.setVisible(true);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(OptionsDisplayerImpl.class, (String)string);
    }

    private static Component loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)OptionsDisplayerImpl.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)OptionsDisplayerImpl.loc(string));
        }
        return component;
    }

    static {
        descriptorRef = new WeakReference<Object>(null);
        title = OptionsDisplayerImpl.loc("CTL_Options_Dialog_Title");
        log = Logger.getLogger(OptionsDisplayerImpl.class.getName());
    }

    private class MyWindowListener
    implements WindowListener {
        private OptionsPanel optionsPanel;
        private Dialog originalDialog;

        MyWindowListener(OptionsPanel optionsPanel) {
            this.optionsPanel = optionsPanel;
            this.originalDialog = dialog;
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (dialog == null) {
                return;
            }
            log.fine("Options Dialog - windowClosing ");
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    MyWindowListener.this.optionsPanel.cancel();
                }
            });
            if (this.originalDialog == dialog) {
                OptionsDisplayerImpl.dialog = null;
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.optionsPanel.storeUserSize();
            if (this.optionsPanel.needsReinit()) {
                descriptorRef = new WeakReference<Object>(null);
            }
            if (this.originalDialog == dialog) {
                OptionsDisplayerImpl.dialog = null;
            }
            log.fine("Options Dialog - windowClosed");
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }
    }

    class OpenOptionsListener
    implements ActionListener {
        OpenOptionsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            log.fine("Options Dialog - Back to modern.");
                            OptionsDisplayer.getDefault().open();
                        }
                    });
                }
            });
        }
    }

    private class OptionsPanelListener
    implements PropertyChangeListener,
    ActionListener {
        private DialogDescriptor descriptor;
        private OptionsPanel optionsPanel;
        private JButton bOK;
        private JButton bClassic;

        OptionsPanelListener(DialogDescriptor dialogDescriptor, OptionsPanel optionsPanel, JButton jButton, JButton jButton2) {
            this.descriptor = dialogDescriptor;
            this.optionsPanel = optionsPanel;
            this.bOK = jButton;
            this.bClassic = jButton2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("buranhelpCtx")) {
                this.descriptor.setHelpCtx(this.optionsPanel.getHelpCtx());
            } else if (propertyChangeEvent.getPropertyName().equals("buranvalid")) {
                this.bOK.setEnabled(this.optionsPanel.dataValid());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Class<?> clazz;
            Object object;
            if (!OptionsDisplayerImpl.this.isOpen()) {
                return;
            }
            if (actionEvent.getSource() == this.bOK) {
                log.fine("Options Dialog - Ok pressed.");
                Dialog dialog = dialog;
                OptionsDisplayerImpl.dialog = null;
                dialog.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.save();
                    }
                });
                return;
            }
            if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION || actionEvent.getSource() == DialogDescriptor.CLOSED_OPTION) {
                log.fine("Options Dialog - Cancel pressed.");
                Dialog dialog = dialog;
                OptionsDisplayerImpl.dialog = null;
                dialog.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.cancel();
                    }
                });
                return;
            }
            if (actionEvent.getSource() != this.bClassic) return;
            log.fine("Options Dialog - Classic pressed.");
            Dialog dialog = dialog;
            OptionsDisplayerImpl.dialog = null;
            if (this.optionsPanel.isChanged()) {
                object = new NotifyDescriptor.Confirmation((Object)OptionsDisplayerImpl.loc("CTL_Some_values_changed"), 1, 3);
                clazz = DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                if (clazz == NotifyDescriptor.YES_OPTION) {
                    dialog.dispose();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OptionsPanelListener.this.optionsPanel.save();
                        }
                    });
                } else {
                    if (clazz != NotifyDescriptor.NO_OPTION) {
                        OptionsDisplayerImpl.dialog = dialog;
                        return;
                    }
                    dialog.dispose();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OptionsPanelListener.this.optionsPanel.cancel();
                        }
                    });
                }
            } else {
                dialog.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.cancel();
                    }
                });
            }
            try {
                object = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                clazz = ((ClassLoader)object).loadClass("org.netbeans.core.actions.OptionsAction");
                CallableSystemAction callableSystemAction = (CallableSystemAction)SystemAction.findObject(clazz, (boolean)true);
                callableSystemAction.putValue("additionalActionName", (Object)OptionsDisplayerImpl.loc("CTL_Modern"));
                callableSystemAction.putValue("optionsDialogTitle", (Object)OptionsDisplayerImpl.loc("CTL_Classic_Title"));
                callableSystemAction.putValue("additionalActionListener", (Object)new OpenOptionsListener());
                callableSystemAction.performAction();
                return;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }
}

