/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import org.netbeans.beaninfo.editors.DataFolderPanel;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

public class DataFolderEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private DataFolderPanel dfPanel;
    PropertyEnv env;

    public String getAsText() {
        DataFolder dataFolder = (DataFolder)this.getValue();
        String string = dataFolder == null ? DataFolderEditor.getString("LAB_DefaultDataFolder") : dataFolder.getName();
        if (string.length() == 0) {
            string = File.pathSeparator;
        }
        return string;
    }

    public void setAsText(String string) {
        if (!(string == null || "".equals(string) || string.equals(DataFolderEditor.getString("LAB_DefaultDataFolder")) || File.pathSeparator.equals(string))) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            String string2 = MessageFormat.format(NbBundle.getMessage(DataFolderEditor.class, (String)"FMT_DF_UNKNOWN"), string);
            UIExceptions.annotateUser(illegalArgumentException, illegalArgumentException.getMessage(), string2, null, new Date());
            throw illegalArgumentException;
        }
        this.setValue(null);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.dfPanel = this.getDFPanel();
        Object object = this.getValue();
        if (object instanceof DataFolder) {
            this.dfPanel.setTargetFolder((DataFolder)object);
        }
        return this.dfPanel;
    }

    public void setValue(Object object) {
        Object object2 = this.getValue();
        super.setValue(object);
        DataFolderPanel dataFolderPanel = this.getDFPanel();
        if (object != object2 && dataFolderPanel != null && object instanceof DataFolder) {
            dataFolderPanel.setTargetFolder((DataFolder)object);
        }
    }

    void setDataFolder(DataFolder dataFolder) {
        super.setValue(dataFolder);
    }

    public DataFolderPanel getDFPanel() {
        if (this.dfPanel == null) {
            this.dfPanel = new DataFolderPanel(this);
        }
        return this.dfPanel;
    }

    private static String getString(String string) {
        return NbBundle.getBundle(DataFolderEditor.class).getString(string);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
    }
}

