/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LookupCache {
    private static final boolean ENABLED = Boolean.valueOf(System.getProperty("netbeans.cache.lookup", "true"));
    private static final Logger err = Logger.getLogger("org.netbeans.core.LookupCache");

    LookupCache() {
    }

    public static Lookup load() {
        err.fine("enabled=" + ENABLED);
        if (ENABLED && LookupCache.cacheHit()) {
            try {
                return LookupCache.loadCache();
            }
            catch (Exception exception) {
                Logger.getLogger(LookupCache.class.getName()).log(Level.INFO, null, exception);
            }
        }
        return LookupCache.loadDirect();
    }

    private static Lookup loadDirect() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services");
        if (fileObject != null) {
            DataFolder dataFolder;
            StartLog.logProgress((String)"Got Services folder");
            try {
                dataFolder = DataFolder.findFolder((FileObject)fileObject);
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(LookupCache.class.getName()).log(Level.INFO, null, runtimeException);
                return Lookup.EMPTY;
            }
            FolderLookup folderLookup = new FolderLookup((DataObject.Container)dataFolder, "SL[");
            StartLog.logProgress((String)"created FolderLookup");
            err.fine("loadDirect from Services");
            return folderLookup.getLookup();
        }
        err.fine("loadDirect, but no Services");
        return Lookup.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cacheHit() {
        boolean bl;
        File file = LookupCache.cacheFile();
        if (file == null || !file.exists()) {
            err.fine("no cache file");
            return false;
        }
        File file2 = LookupCache.stampFile();
        if (file2 == null || !file2.exists()) {
            err.fine("no stamp file");
            return false;
        }
        StartLog.logStart((String)"check for lookup cache hit");
        List<File> list = LookupCache.relevantFiles();
        if (err.isLoggable(Level.FINE)) {
            err.fine("checking against " + file2 + " for files " + list);
        }
        try {
            Stamp stamp = new Stamp(list);
            long l = stamp.getHash();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
            try {
                long l2;
                String string = bufferedReader.readLine();
                try {
                    l2 = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(numberFormatException.toString());
                }
                if (l2 == l) {
                    err.fine("Cache hit! with hash " + l2);
                    bl = true;
                } else {
                    err.fine("Cache miss, " + l2 + " -> " + l);
                    bl = false;
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(LookupCache.class.getName()).log(Level.INFO, null, iOException);
            bl = false;
        }
        StartLog.logEnd((String)"check for lookup cache hit");
        return bl;
    }

    private static File cacheFile() {
        String string = System.getProperty("netbeans.user");
        if (string != null && !"memory".equals(string)) {
            File file = new File(new File(string, "var"), "cache");
            file.mkdirs();
            return new File(file, "folder-lookup.ser");
        }
        return null;
    }

    private static File stampFile() {
        String string = System.getProperty("netbeans.user");
        if (string != null && !"memory".equals(string)) {
            File file = new File(new File(string, "var"), "cache");
            file.mkdirs();
            return new File(file, "lookup-stamp.txt");
        }
        return null;
    }

    private static List<File> relevantFiles() {
        final ArrayList<File> arrayList = new ArrayList<File>(250);
        final ModuleManager moduleManager = Main.getModuleSystem().getManager();
        moduleManager.mutex().readAccess(new Runnable(){

            public void run() {
                for (Module module : moduleManager.getEnabledModules()) {
                    String string = (String)module.getAttribute("OpenIDE-Module-Layer");
                    if (string == null) continue;
                    if (module.getJarFile() != null) {
                        arrayList.add(module.getJarFile());
                        continue;
                    }
                    URL uRL = module.getClassLoader().getResource(string);
                    if (uRL != null) {
                        String string2 = uRL.toExternalForm();
                        if (string2.startsWith("jar:")) {
                            int n = string2.lastIndexOf("!/");
                            if (n != -1) {
                                try {
                                    URI uRI = new URI(string2.substring(4, n));
                                    if ("file".equals(uRI.getScheme())) {
                                        arrayList.add(new File(uRI));
                                        continue;
                                    }
                                    err.warning("Weird jar: URL: " + uRI);
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    Logger.getLogger(LookupCache.class.getName()).log(Level.WARNING, null, uRISyntaxException);
                                }
                                continue;
                            }
                            err.warning("Malformed jar: URL: " + string2);
                            continue;
                        }
                        err.warning("Not a jar: URL: " + string2);
                        continue;
                    }
                    err.warning("Could not find " + string + " in " + module);
                }
            }
        });
        LookupCache.relevantFilesFromInst(arrayList, System.getProperty("netbeans.home"));
        LookupCache.relevantFilesFromInst(arrayList, System.getProperty("netbeans.user"));
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                LookupCache.relevantFilesFromInst(arrayList, stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private static void relevantFilesFromInst(List<File> list, String string) {
        if (string == null) {
            return;
        }
        LookupCache.relevantFilesFrom(list, new File(new File(new File(string), "system"), "Services"));
    }

    private static void relevantFilesFrom(List<File> list, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isFile()) {
                    list.add(file2);
                    continue;
                }
                LookupCache.relevantFilesFrom(list, file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lookup loadCache() throws Exception {
        StartLog.logStart((String)"load lookup cache");
        File file = LookupCache.cacheFile();
        err.fine("loading from " + file);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            NbObjectInputStream nbObjectInputStream = new NbObjectInputStream((InputStream)new BufferedInputStream(fileInputStream));
            Lookup lookup = (Lookup)nbObjectInputStream.readObject();
            StartLog.logEnd((String)"load lookup cache");
            Lookup lookup2 = lookup;
            return lookup2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Lookup lookup) throws IOException {
        if (!ENABLED) {
            return;
        }
        File file = LookupCache.cacheFile();
        if (file == null) {
            return;
        }
        File file2 = LookupCache.stampFile();
        if (file2 == null) {
            return;
        }
        StartLog.logStart((String)"store lookup cache");
        err.fine("storing to " + file + " with stamp in " + file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            Object object;
            try {
                object = new NbObjectOutputStream((OutputStream)new BufferedOutputStream(fileOutputStream));
                ((ObjectOutputStream)object).writeObject(lookup);
                ((ObjectOutputStream)object).flush();
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
            object = new Stamp(LookupCache.relevantFiles());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
            try {
                outputStreamWriter.write(Long.toString(((Stamp)object).getHash()));
                outputStreamWriter.write("\nLine above is identifying hash key, do not edit!\nBelow is metadata about folder lookup cache, for debugging purposes.\n");
                outputStreamWriter.write(((Stamp)object).toString());
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
            StartLog.logEnd((String)"store lookup cache");
        }
        catch (IOException iOException) {
            if (file.exists()) {
                file.delete();
            }
            if (file2.exists()) {
                file2.delete();
            }
            throw iOException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Stamp {
        private final List<File> files;
        private final long[] times;
        private final long hash;

        public Stamp(List<File> list) throws IOException {
            this.files = new ArrayList<File>(list);
            Collections.sort(this.files);
            this.times = new long[this.files.size()];
            long l = 17L;
            Iterator<File> iterator = this.files.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                File file = iterator.next();
                l ^= (long)file.hashCode();
                l += 98679245L;
                String string = file.getName().toLowerCase(Locale.US);
                long l2 = string.endsWith(".jar") || ".nbattrs".equals(string) ? file.lastModified() : 0L;
                int n2 = n++;
                long l3 = l2;
                this.times[n2] = l3;
                l ^= l3;
            }
            this.hash = l;
        }

        public long getHash() {
            return this.hash;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<File> iterator = this.files.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                long l;
                if ((l = this.times[n++]) != 0L) {
                    stringBuilder.append(new Date(l));
                } else {
                    stringBuilder.append("<ignoring file contents>");
                }
                stringBuilder.append('\t');
                stringBuilder.append(iterator.next());
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
    }
}

