/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.NotifyExcPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbErrorManager
extends Handler {
    static Exc createExc(Throwable throwable, Level level, LogRecord logRecord) {
        LogRecord[] logRecordArray = NbErrorManager.findAnnotations(throwable, logRecord);
        return new Exc(throwable, level, logRecordArray, NbErrorManager.findAnnotations0(throwable, logRecord, true, new HashSet<Throwable>()));
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getThrown() != null) {
            Level level = logRecord.getLevel();
            if (level.intValue() == Level.WARNING.intValue() + 1) {
                level = null;
            }
            if (level != null && level.intValue() == Level.SEVERE.intValue() + 1) {
                level = null;
            }
            Exc exc = NbErrorManager.createExc(logRecord.getThrown(), level, logRecord.getLevel().intValue() == 1973 ? logRecord : null);
            NotifyExcPanel.notify(exc);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private static final String getLocalizedMessage(LogRecord logRecord) {
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle == null) {
            return null;
        }
        String string = logRecord.getMessage();
        if (string == null) {
            return null;
        }
        String string2 = resourceBundle.getString(string);
        Object[] objectArray = logRecord.getParameters();
        if (objectArray == null) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }

    private static LogRecord[] findAnnotations(Throwable throwable, LogRecord logRecord) {
        return NbErrorManager.findAnnotations0(throwable, logRecord, false, new HashSet<Throwable>());
    }

    private static LogRecord[] findAnnotations0(Throwable throwable, LogRecord logRecord, boolean bl, Set<Throwable> set) {
        LogRecord[] logRecordArray;
        Serializable serializable;
        ArrayList<LogRecord> arrayList = new ArrayList<LogRecord>();
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof Callable)) continue;
            serializable = null;
            try {
                serializable = ((Callable)((Object)throwable2)).call();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!(serializable instanceof LogRecord[])) continue;
            logRecordArray = (LogRecord[])serializable;
            arrayList.addAll(Arrays.asList(logRecordArray));
        }
        if (logRecord != null) {
            arrayList.add(logRecord);
        }
        if (bl) {
            serializable = new ArrayList();
            logRecordArray = arrayList.iterator();
            while (logRecordArray.hasNext()) {
                LogRecord logRecord2 = (LogRecord)logRecordArray.next();
                Throwable throwable3 = logRecord2.getThrown();
                if (throwable3 == null || set.contains(throwable3)) continue;
                set.add(throwable3);
                LogRecord[] logRecordArray2 = NbErrorManager.findAnnotations0(throwable3, null, true, set);
                if (logRecordArray2 == null || logRecordArray2.length <= 0) continue;
                ((ArrayList)serializable).addAll(Arrays.asList(logRecordArray2));
            }
            arrayList.addAll((Collection<LogRecord>)((Object)serializable));
        }
        if ((serializable = throwable.getCause()) != null && (logRecordArray = NbErrorManager.findAnnotations0((Throwable)serializable, null, true, set)) != null && logRecordArray.length > 0) {
            arrayList.addAll(Arrays.asList(logRecordArray));
        }
        logRecordArray = new LogRecord[arrayList.size()];
        arrayList.toArray(logRecordArray);
        return logRecordArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Exc {
        private Throwable t;
        private Date d;
        private LogRecord[] arr;
        private LogRecord[] arrAll;
        private Level severity;

        Exc(Throwable throwable, Level level, LogRecord[] logRecordArray, LogRecord[] logRecordArray2) {
            this.t = throwable;
            this.severity = level;
            this.arr = logRecordArray == null ? new LogRecord[]{} : logRecordArray;
            this.arrAll = logRecordArray2 == null ? new LogRecord[]{} : logRecordArray2;
        }

        String getMessage() {
            String string = this.t.getMessage();
            if (string != null) {
                return string;
            }
            return (String)this.find(1);
        }

        String getLocalizedMessage() {
            String string = this.t.getLocalizedMessage();
            if (string != null && !string.equals(this.t.getMessage())) {
                return string;
            }
            if (this.arrAll == null) {
                return (String)this.find(2);
            }
            for (int i = 0; i < this.arrAll.length; ++i) {
                String string2 = NbErrorManager.getLocalizedMessage(this.arrAll[i]);
                if (string2 == null) continue;
                return string2;
            }
            return string;
        }

        boolean isLocalized() {
            String string = this.t.getLocalizedMessage();
            if (string != null && !string.equals(this.t.getMessage())) {
                return true;
            }
            if (this.arrAll == null) {
                return (String)this.find(2) != null;
            }
            for (int i = 0; i < this.arrAll.length; ++i) {
                String string2 = NbErrorManager.getLocalizedMessage(this.arrAll[i]);
                if (string2 == null) continue;
                return true;
            }
            return false;
        }

        String getClassName() {
            return (String)this.find(3);
        }

        Level getSeverity() {
            if (this.severity != null) {
                return this.severity;
            }
            LogRecord[] logRecordArray = this.arrAll != null ? this.arrAll : this.arr;
            for (int i = 0; i < logRecordArray.length; ++i) {
                Level level = logRecordArray[i].getLevel();
                if (this.severity != null && level.intValue() <= this.severity.intValue()) continue;
                this.severity = level;
            }
            if (this.severity == null || this.severity == Level.ALL) {
                this.severity = this.t instanceof Error ? Level.SEVERE : Level.WARNING;
            }
            return this.severity;
        }

        Date getDate() {
            if (this.d == null) {
                this.d = (Date)this.find(4);
            }
            return this.d;
        }

        void printStackTrace(PrintStream printStream) {
            this.printStackTrace(new PrintWriter(new OutputStreamWriter(printStream)));
        }

        void printStackTrace(PrintWriter printWriter) {
            this.printStackTrace(printWriter, new HashSet<Throwable>(10));
        }

        private void printStackTrace(PrintWriter printWriter, Set<Throwable> set) {
            Object object;
            Object object2;
            if (this.t != null && !set.add(this.t)) {
                Logger logger = Logger.getAnonymousLogger();
                logger.warning("WARNING - ErrorManager detected cyclic exception nesting:");
                for (Throwable throwable : set) {
                    logger.warning("\t" + throwable);
                    LogRecord[] logRecordArray = NbErrorManager.findAnnotations(throwable, null);
                    if (logRecordArray == null) continue;
                    for (int i = 0; i < logRecordArray.length; ++i) {
                        Throwable throwable2 = logRecordArray[i].getThrown();
                        if (throwable2 == null) continue;
                        logger.warning("\t=> " + throwable2);
                    }
                }
                logger.warning("Be sure not to annotate an exception with itself, directly or indirectly.");
                return;
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == null) continue;
                object2 = this.arr[i].getThrown();
                String string = NbErrorManager.getLocalizedMessage(this.arr[i]);
                if (string == null) {
                    string = this.arr[i].getMessage();
                }
                if (string == null || object2 != null) continue;
                printWriter.println("Annotation: " + string);
            }
            if (this.t instanceof VirtualMachineError) {
                this.t.printStackTrace(printWriter);
            } else {
                StackTraceElement[] stackTraceElementArray = this.t.getStackTrace();
                object2 = new Throwable().getStackTrace();
                int n = -1;
                for (int i = 1; i <= Math.min(stackTraceElementArray.length, ((StackTraceElement[])object2).length); ++i) {
                    if (stackTraceElementArray[stackTraceElementArray.length - i].equals(object2[((StackTraceElement[])object2).length - i])) continue;
                    n = stackTraceElementArray.length - i + 1;
                    break;
                }
                object = this.decompose(this.t);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (i == n) {
                        printWriter.print("[catch]");
                        if (object[i].charAt(0) == '\t') {
                            printWriter.print(' ');
                            object[i] = ((String)object[i]).substring(1);
                        }
                    }
                    printWriter.println(object[i]);
                }
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == null || (object2 = this.arr[i].getThrown()) == null) continue;
                LogRecord[] logRecordArray = NbErrorManager.findAnnotations((Throwable)object2, null);
                object = new Exc((Throwable)object2, null, logRecordArray, null);
                printWriter.println("==>");
                super.printStackTrace(printWriter, set);
            }
        }

        private String[] decompose(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString().split("(\r\n?|\n)($|(?=\\s*at ))");
        }

        private Object find(int n) {
            return this.find(n, true);
        }

        private Object find(int n, boolean bl) {
            for (int i = 0; i < this.arr.length; ++i) {
                LogRecord logRecord = this.arr[i];
                Object object = null;
                switch (n) {
                    case 1: {
                        object = logRecord.getMessage();
                        break;
                    }
                    case 2: {
                        object = NbErrorManager.getLocalizedMessage(logRecord);
                        break;
                    }
                    case 3: {
                        Throwable throwable = logRecord.getThrown();
                        object = throwable == null ? null : throwable.getClass().getName();
                        break;
                    }
                    case 4: {
                        object = new Date(logRecord.getMillis());
                    }
                }
                if (object == null) continue;
                return object;
            }
            if (!bl) {
                return null;
            }
            switch (n) {
                case 1: {
                    return this.t.getMessage();
                }
                case 2: {
                    return this.t.getLocalizedMessage();
                }
                case 3: {
                    return this.t.getClass().getName();
                }
                case 4: {
                    return new Date();
                }
            }
            throw new IllegalArgumentException("Unknown " + Integer.valueOf(n));
        }
    }
}

