/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.core.actions.CopyProductInfoAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;

public class ProductInformationPanel
extends JPanel {
    private static final int FONT_SIZE_PLUS = 5;
    private static final Color COLOR = Color.black;
    private static Clipboard clipboard;
    private static Action copyAction;
    private JButton copyButton;
    private JLabel currentDirLabel;
    private JTextArea currentDirValueLabel;
    private JLabel homeDirLabel;
    private JTextArea homeDirValueLabel;
    private JLabel ideImageLabel;
    private JLabel ideInstallLabel;
    private JTextArea ideInstallValueField;
    private JPanel jPanel1;
    private JLabel javaHomeLabel;
    private JTextArea javaHomeValueLabel;
    private JLabel javaLabel;
    private JTextArea javaValueLabel;
    private JLabel operatingSystemLabel;
    private JTextArea operatingSystemValueLabel;
    private JLabel productInformationLabel;
    private JLabel productVersionLabel;
    private JTextArea productVersionValueLabel;
    private JLabel systemLocaleLabel;
    private JTextArea systemLocaleValueLabel;
    private JLabel userDirLabel;
    private JTextArea userDirValueLabel;
    private JLabel vendorLabel;
    private JTextArea vendorValueLabel;
    private JLabel vmLabel;
    private JTextArea vmValueLabel;

    public ProductInformationPanel() {
        this.initComponents();
        this.initAccessibility();
        this.updateLabelFont(this.productInformationLabel, 1, 5, COLOR);
        this.updateLabelFont(this.productVersionLabel, 1, COLOR);
        this.updateLabelFont(this.operatingSystemLabel, 1, COLOR);
        this.updateLabelFont(this.javaLabel, 1, COLOR);
        this.updateLabelFont(this.vmLabel, 1, COLOR);
        this.updateLabelFont(this.vendorLabel, 1, COLOR);
        this.updateLabelFont(this.javaHomeLabel, 1, COLOR);
        this.updateLabelFont(this.systemLocaleLabel, 1, COLOR);
        this.updateLabelFont(this.homeDirLabel, 1, COLOR);
        this.updateLabelFont(this.currentDirLabel, 1, COLOR);
        this.updateLabelFont(this.ideInstallLabel, 1, COLOR);
        this.updateLabelFont(this.userDirLabel, 1, COLOR);
        this.updateLabelFont(this.productVersionValueLabel, COLOR);
        this.updateLabelFont(this.operatingSystemValueLabel, COLOR);
        this.updateLabelFont(this.javaValueLabel, COLOR);
        this.updateLabelFont(this.vmValueLabel, COLOR);
        this.updateLabelFont(this.vendorValueLabel, COLOR);
        this.updateLabelFont(this.javaHomeValueLabel, COLOR);
        this.updateLabelFont(this.systemLocaleValueLabel, COLOR);
        this.updateLabelFont(this.homeDirValueLabel, COLOR);
        this.updateLabelFont(this.currentDirValueLabel, COLOR);
        this.updateLabelFont(this.ideInstallValueField, COLOR);
        this.updateLabelFont(this.userDirValueLabel, COLOR);
        if (this.ideInstallValueField.getText().length() == 0) {
            this.ideInstallLabel.setVisible(false);
            this.ideInstallValueField.setVisible(false);
        }
    }

    private void initComponents() {
        this.ideImageLabel = new JLabel();
        this.productVersionLabel = new JLabel();
        this.operatingSystemLabel = new JLabel();
        this.javaLabel = new JLabel();
        this.vmLabel = new JLabel();
        this.vendorLabel = new JLabel();
        this.javaHomeLabel = new JLabel();
        this.systemLocaleLabel = new JLabel();
        this.homeDirLabel = new JLabel();
        this.currentDirLabel = new JLabel();
        this.ideInstallLabel = new JLabel();
        this.userDirLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.productInformationLabel = new FocusableLabel();
        this.ideInstallValueField = new JTextArea();
        this.copyButton = new JButton();
        this.productVersionValueLabel = new JTextArea();
        this.operatingSystemValueLabel = new JTextArea();
        this.javaValueLabel = new JTextArea();
        this.vmValueLabel = new JTextArea();
        this.vendorValueLabel = new JTextArea();
        this.javaHomeValueLabel = new JTextArea();
        this.systemLocaleValueLabel = new JTextArea();
        this.homeDirValueLabel = new JTextArea();
        this.currentDirValueLabel = new JTextArea();
        this.userDirValueLabel = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.ideImageLabel.setIcon(this.getIcon());
        this.ideImageLabel.setLabelFor(this.productInformationLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.ideImageLabel, gridBagConstraints);
        this.productVersionLabel.setLabelFor(this.productVersionValueLabel);
        this.productVersionLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_ProductVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.productVersionLabel, gridBagConstraints);
        this.operatingSystemLabel.setLabelFor(this.operatingSystemValueLabel);
        this.operatingSystemLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_OperationgSystem"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.operatingSystemLabel, gridBagConstraints);
        this.javaLabel.setLabelFor(this.javaValueLabel);
        this.javaLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_Java"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.javaLabel, gridBagConstraints);
        this.vmLabel.setLabelFor(this.vmValueLabel);
        this.vmLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_VM"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.vmLabel, gridBagConstraints);
        this.vendorLabel.setLabelFor(this.vendorValueLabel);
        this.vendorLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_Vendor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.vendorLabel, gridBagConstraints);
        this.javaHomeLabel.setLabelFor(this.javaHomeValueLabel);
        this.javaHomeLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_JavaHome"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.javaHomeLabel, gridBagConstraints);
        this.systemLocaleLabel.setLabelFor(this.systemLocaleValueLabel);
        this.systemLocaleLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_SystemLocale"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.systemLocaleLabel, gridBagConstraints);
        this.homeDirLabel.setLabelFor(this.homeDirValueLabel);
        this.homeDirLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_HomeDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.homeDirLabel, gridBagConstraints);
        this.currentDirLabel.setLabelFor(this.currentDirValueLabel);
        this.currentDirLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_CurrentDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.currentDirLabel, gridBagConstraints);
        this.ideInstallLabel.setLabelFor(this.ideInstallValueField);
        this.ideInstallLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_IDEInstall"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 5, 0);
        this.add((Component)this.ideInstallLabel, gridBagConstraints);
        this.userDirLabel.setLabelFor(this.userDirValueLabel);
        this.userDirLabel.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_UserDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.userDirLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.productInformationLabel.setText(this.getProductInformationTitle());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.productInformationLabel, gridBagConstraints);
        this.ideInstallValueField.setEditable(false);
        this.ideInstallValueField.setText(this.getIDEInstallValue());
        this.ideInstallValueField.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 12, 5, 11);
        this.add((Component)this.ideInstallValueField, gridBagConstraints);
        this.copyButton.setAction((Action)CopyProductInfoAction.findObject(CopyProductInfoAction.class, (boolean)true));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.copyButton, gridBagConstraints);
        this.productVersionValueLabel.setEditable(false);
        this.productVersionValueLabel.setText(ProductInformationPanel.getProductVersionValue());
        this.productVersionValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.add((Component)this.productVersionValueLabel, gridBagConstraints);
        this.operatingSystemValueLabel.setEditable(false);
        this.operatingSystemValueLabel.setText(ProductInformationPanel.getOperatingSystemValue());
        this.operatingSystemValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.operatingSystemValueLabel, gridBagConstraints);
        this.javaValueLabel.setEditable(false);
        this.javaValueLabel.setText(ProductInformationPanel.getJavaValue());
        this.javaValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.javaValueLabel, gridBagConstraints);
        this.vmValueLabel.setEditable(false);
        this.vmValueLabel.setText(ProductInformationPanel.getVMValue());
        this.vmValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.vmValueLabel, gridBagConstraints);
        this.vendorValueLabel.setEditable(false);
        this.vendorValueLabel.setText(this.getVendorValue());
        this.vendorValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.vendorValueLabel, gridBagConstraints);
        this.javaHomeValueLabel.setEditable(false);
        this.javaHomeValueLabel.setText(this.getJavaHomeValue());
        this.javaHomeValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.javaHomeValueLabel, gridBagConstraints);
        this.systemLocaleValueLabel.setEditable(false);
        this.systemLocaleValueLabel.setText(ProductInformationPanel.getSystemLocaleValue());
        this.systemLocaleValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.systemLocaleValueLabel, gridBagConstraints);
        this.homeDirValueLabel.setEditable(false);
        this.homeDirValueLabel.setText(this.getHomeDirValue());
        this.homeDirValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.homeDirValueLabel, gridBagConstraints);
        this.currentDirValueLabel.setEditable(false);
        this.currentDirValueLabel.setText(this.getCurrentDirValue());
        this.currentDirValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.currentDirValueLabel, gridBagConstraints);
        this.userDirValueLabel.setEditable(false);
        this.userDirValueLabel.setText(this.getUserDirValue());
        this.userDirValueLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.userDirValueLabel, gridBagConstraints);
    }

    private void updateLabelFont(JComponent jComponent, Color color) {
        this.updateLabelFont(jComponent, 0, 0, color);
    }

    private void updateLabelFont(JComponent jComponent, int n, Color color) {
        this.updateLabelFont(jComponent, n, 0, color);
    }

    private void updateLabelFont(JComponent jComponent, int n, int n2, Color color) {
        Font font = jComponent.getFont();
        if (n != 0) {
            font = Utilities.isMac() ? new Font(jComponent.getFont().getName(), 1, jComponent.getFont().getSize()) : jComponent.getFont().deriveFont(1);
            jComponent.setFont(font);
        }
        if ((float)n2 != 0.0f) {
            font = new Font(font.getName(), font.getStyle(), font.getSize() + n2);
            jComponent.setFont(font);
        }
        if (color != null) {
            jComponent.setForeground(color);
        }
    }

    private ImageIcon getIcon() {
        return new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/startup/frame48.gif", (boolean)true));
    }

    private String getProductInformationTitle() {
        return NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_ProductInformation");
    }

    public static String getProductVersionValue() {
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
    }

    public static String getOperatingSystemValue() {
        return NbBundle.getMessage(ProductInformationPanel.class, (String)"Format_OperatingSystem_Value", (Object)System.getProperty("os.name", "unknown"), (Object)System.getProperty("os.version", "unknown"), (Object)System.getProperty("os.arch", "unknown"));
    }

    public static String getJavaValue() {
        return System.getProperty("java.version", "unknown");
    }

    public static String getVMValue() {
        return System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "");
    }

    private String getVendorValue() {
        return System.getProperty("java.vendor", "unknown");
    }

    private String getJavaHomeValue() {
        return System.getProperty("java.home", "unknown");
    }

    public static String getSystemLocaleValue() {
        String string;
        return Locale.getDefault().toString() + ((string = NbBundle.getBranding()) == null ? "" : " (" + string + ")");
    }

    private String getHomeDirValue() {
        return System.getProperty("user.home", "unknown");
    }

    private String getCurrentDirValue() {
        return System.getProperty("user.dir", "unknown");
    }

    private String getIDEInstallValue() {
        String string = System.getProperty("netbeans.home");
        String string2 = System.getProperty("netbeans.dirs");
        Enumeration<Object> enumeration = string2 != null ? new StringTokenizer(string2, File.pathSeparator) : Enumerations.empty();
        Enumeration enumeration2 = Enumerations.concat((Enumeration)Enumerations.singleton((Object)string), (Enumeration)enumeration);
        HashSet<File> hashSet = new HashSet<File>();
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "";
        while (enumeration2.hasMoreElements()) {
            File file;
            String string4 = (String)enumeration2.nextElement();
            if (string4 == null || !hashSet.add(file = FileUtil.normalizeFile((File)new File(string4)))) continue;
            stringBuilder.append(string3);
            stringBuilder.append(file.getAbsolutePath());
            string3 = "\n";
        }
        return stringBuilder.toString();
    }

    private String getUserDirValue() {
        return System.getProperty("netbeans.user");
    }

    public static String getEncodingValue() {
        return System.getProperty("file.encoding", "unknown");
    }

    public static Clipboard getExClipboard() {
        if (clipboard == null && (clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class)) == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    private void initAccessibility() {
        this.productVersionValueLabel.getAccessibleContext().setAccessibleName(this.productVersionLabel.getText() + " " + this.productVersionValueLabel.getText());
        this.productVersionValueLabel.getAccessibleContext().setAccessibleDescription(this.productVersionValueLabel.getText());
        this.operatingSystemValueLabel.getAccessibleContext().setAccessibleName(this.operatingSystemLabel.getText() + " " + this.operatingSystemValueLabel.getText());
        this.operatingSystemValueLabel.getAccessibleContext().setAccessibleDescription(this.operatingSystemValueLabel.getText());
        this.javaValueLabel.getAccessibleContext().setAccessibleName(this.javaLabel.getText() + " " + this.javaValueLabel.getText());
        this.javaValueLabel.getAccessibleContext().setAccessibleDescription(this.javaValueLabel.getText());
        this.vmValueLabel.getAccessibleContext().setAccessibleName(this.vmLabel.getText() + " " + this.vmValueLabel.getText());
        this.vmValueLabel.getAccessibleContext().setAccessibleDescription(this.vmValueLabel.getText());
        this.vendorValueLabel.getAccessibleContext().setAccessibleName(this.vendorLabel.getText() + " " + this.vendorValueLabel.getText());
        this.vendorValueLabel.getAccessibleContext().setAccessibleDescription(this.vendorValueLabel.getText());
        this.javaHomeValueLabel.getAccessibleContext().setAccessibleName(this.javaHomeLabel.getText() + " " + this.javaHomeValueLabel.getText());
        this.javaHomeValueLabel.getAccessibleContext().setAccessibleDescription(this.javaHomeValueLabel.getText());
        this.systemLocaleValueLabel.getAccessibleContext().setAccessibleName(this.systemLocaleLabel.getText() + " " + this.systemLocaleValueLabel.getText());
        this.systemLocaleValueLabel.getAccessibleContext().setAccessibleDescription(this.systemLocaleValueLabel.getText());
        this.homeDirValueLabel.getAccessibleContext().setAccessibleName(this.homeDirLabel.getText() + " " + this.homeDirValueLabel.getText());
        this.homeDirValueLabel.getAccessibleContext().setAccessibleDescription(this.homeDirValueLabel.getText());
        this.currentDirValueLabel.getAccessibleContext().setAccessibleName(this.currentDirLabel.getText() + " " + this.currentDirValueLabel.getText());
        this.currentDirValueLabel.getAccessibleContext().setAccessibleDescription(this.currentDirValueLabel.getText());
        this.ideInstallValueField.getAccessibleContext().setAccessibleName(this.ideInstallLabel.getText() + " " + this.ideInstallValueField.getText());
        this.ideInstallValueField.getAccessibleContext().setAccessibleDescription(this.ideInstallValueField.getText());
        this.userDirValueLabel.getAccessibleContext().setAccessibleName(this.userDirLabel.getText() + " " + this.userDirValueLabel.getText());
        this.userDirValueLabel.getAccessibleContext().setAccessibleDescription(this.userDirValueLabel.getText());
    }

    static class FocusableLabel
    extends JLabel {
        private boolean isFocused = false;

        public FocusableLabel() {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    FocusableLabel.this.isFocused = true;
                    FocusableLabel.this.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    FocusableLabel.this.isFocused = false;
                    FocusableLabel.this.repaint();
                }
            });
            this.getAccessibleContext().setAccessibleDescription(this.getText());
            this.getAccessibleContext().setAccessibleName(this.getText());
        }

        public boolean isFocusable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics graphics) {
            if (this.ui != null) {
                try {
                    this.ui.update(graphics, this);
                }
                finally {
                    graphics.dispose();
                }
            }
            if (this.isFocused) {
                Dimension dimension = this.getSize();
                graphics.setColor(UIManager.getColor("Button.focus"));
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }
    }
}

