/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.modules.java.hints.AddParameterOrLocalFix;
import org.netbeans.modules.java.hints.JavaHintsProvider;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateElement
implements ErrorRule<Void> {
    private static final Set<Tree.Kind> STOP_LOOKING_FOR_METHOD = EnumSet.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.COMPILATION_UNIT);

    @Override
    public Set<String> getCodes() {
        return Collections.singleton("compiler.err.cant.resolve.location");
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        return CreateElement.analyze(compilationInfo, n);
    }

    static List<Fix> analyze(CompilationInfo compilationInfo, int n) {
        Element element;
        TypeMirror typeMirror;
        Object object;
        Object object2;
        Iterable<Tree> iterable;
        TreePath treePath = JavaHintsProvider.findUnresolvedElement(compilationInfo, n);
        if (treePath == null) {
            return Collections.emptyList();
        }
        TreePath treePath2 = null;
        TreePath treePath3 = null;
        TreePath treePath4 = null;
        TreePath treePath5 = null;
        for (TreePath treePath6 = compilationInfo.getTreeUtilities().pathFor(n + 1); treePath6 != null; treePath6 = treePath6.getParentPath()) {
            if (treePath2 != null && treePath2.getLeaf() == treePath.getLeaf()) {
                treePath2 = treePath6;
            }
            if (treePath6.getLeaf() == treePath.getLeaf() && treePath2 == null) {
                treePath2 = treePath6;
            }
            if (treePath6.getLeaf().getKind() == Tree.Kind.CLASS && treePath3 == null) {
                treePath3 = treePath6;
            }
            if (treePath6.getLeaf().getKind() == Tree.Kind.METHOD && treePath4 == null && treePath3 == null) {
                treePath4 = treePath6;
            }
            if (treePath6.getLeaf().getKind() != Tree.Kind.BLOCK || treePath6.getParentPath().getLeaf().getKind() != Tree.Kind.CLASS || treePath4 != null || treePath3 != null) continue;
            treePath5 = treePath6;
        }
        if (treePath2 == null || treePath2.getLeaf() == treePath.getLeaf() || treePath3 == null) {
            return Collections.emptyList();
        }
        Element element2 = compilationInfo.getTrees().getElement(treePath);
        if (element2 == null) {
            return Collections.emptyList();
        }
        EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
        String string = element2.getSimpleName().toString();
        TypeElement typeElement = (TypeElement)compilationInfo.getTrees().getElement(treePath3);
        TypeElement typeElement2 = null;
        boolean bl = true;
        if (treePath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            iterable = new TreePath(treePath, ((MemberSelectTree)treePath.getLeaf()).getExpression());
            object2 = compilationInfo.getTrees().getElement((TreePath)iterable);
            object = compilationInfo.getTrees().getTypeMirror((TreePath)iterable);
            if (object2 != null && object != null && object.getKind() != TypeKind.ERROR) {
                switch (object2.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        typeElement2 = (TypeElement)object2;
                        enumSet.add(Modifier.STATIC);
                        break;
                    }
                    case FIELD: 
                    case ENUM_CONSTANT: 
                    case LOCAL_VARIABLE: 
                    case PARAMETER: 
                    case EXCEPTION_PARAMETER: {
                        typeMirror = object2.asType();
                        if (typeMirror.getKind() != TypeKind.DECLARED) break;
                        typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement();
                        break;
                    }
                    case METHOD: {
                        element = compilationInfo.getTypes().asElement(((ExecutableElement)object2).getReturnType());
                        if (element == null || !element.getKind().isClass() && !element.getKind().isInterface()) break;
                        typeElement2 = (TypeElement)element;
                        break;
                    }
                    case CONSTRUCTOR: {
                        typeElement2 = (TypeElement)object2.getEnclosingElement();
                    }
                }
            }
            bl = false;
        } else if (treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
            typeElement2 = typeElement;
            if (treePath4 != null && ((MethodTree)treePath4.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                enumSet.add(Modifier.STATIC);
            }
        }
        if (typeElement2 == null) {
            if (JavaHintsProvider.ERR.isLoggable(1)) {
                JavaHintsProvider.ERR.log(1, "target=null");
                JavaHintsProvider.ERR.log(1, "offset=" + n);
                JavaHintsProvider.ERR.log(1, "errorTree=" + treePath.getLeaf());
            }
            return Collections.emptyList();
        }
        enumSet.addAll(CreateElement.getAccessModifiers(typeElement, typeElement2));
        iterable = new ArrayList();
        object2 = EnumSet.noneOf(FixTypes.class);
        object = CreateElement.resolveType((Set<FixTypes>)object2, compilationInfo, treePath2, treePath.getLeaf(), n);
        if (object == null || object.isEmpty()) {
            return Collections.emptyList();
        }
        typeMirror = (TypeMirror)object.get(0);
        if (typeMirror == null || typeMirror.getKind() == TypeKind.VOID) {
            return Collections.emptyList();
        }
        if (CreateElement.containsErrorsOrTypevarsRecursively(typeMirror)) {
            return Collections.emptyList();
        }
        if (object2.contains((Object)FixTypes.FIELD)) {
            iterable.add(new CreateFieldFix(compilationInfo, string, enumSet, typeElement2, typeMirror));
        }
        if (bl && (object2.contains((Object)FixTypes.LOCAL) || object.contains((Object)FixTypes.PARAM))) {
            element = null;
            if (treePath4 != null) {
                element = (ExecutableElement)compilationInfo.getTrees().getElement(treePath4);
            }
            if (element != null && typeMirror != null) {
                int n2 = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
                if (element != null && object2.contains((Object)FixTypes.PARAM)) {
                    iterable.add((AddParameterOrLocalFix)new AddParameterOrLocalFix(compilationInfo, typeMirror, string, true, n2));
                }
                if (object2.contains((Object)FixTypes.LOCAL)) {
                    iterable.add((AddParameterOrLocalFix)new AddParameterOrLocalFix(compilationInfo, typeMirror, string, false, n2));
                }
            }
        }
        return iterable;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return CreateElement.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Create Field Fix";
    }

    @Override
    public String getDescription() {
        return "Create Field Fix";
    }

    private static boolean containsErrorsOrTypevarsRecursively(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case WILDCARD: 
            case TYPEVAR: 
            case ERROR: {
                return true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    if (!CreateElement.containsErrorsOrTypevarsRecursively(typeMirror2)) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                return CreateElement.containsErrorsOrTypevarsRecursively(((ArrayType)typeMirror).getComponentType());
            }
        }
        return false;
    }

    private static EnumSet<Modifier> getAccessModifiers(TypeElement typeElement, TypeElement typeElement2) {
        Element element;
        TypeElement typeElement3;
        TypeElement typeElement4 = SourceUtils.getOutermostEnclosingTypeElement((Element)typeElement);
        if (typeElement4.equals(typeElement3 = SourceUtils.getOutermostEnclosingTypeElement((Element)typeElement2))) {
            return EnumSet.of(Modifier.PRIVATE);
        }
        Element element2 = typeElement4.getEnclosingElement();
        if (((Object)element2).equals(element = typeElement3.getEnclosingElement())) {
            return EnumSet.noneOf(Modifier.class);
        }
        return EnumSet.of(Modifier.PUBLIC);
    }

    private static List<? extends TypeMirror> resolveType(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        switch (treePath.getLeaf().getKind()) {
            case METHOD: {
                return CreateElement.computeMethod(set, compilationInfo, treePath, tree, n);
            }
            case MEMBER_SELECT: {
                return CreateElement.computeMemberSelect(set, compilationInfo, treePath, tree, n);
            }
            case ASSIGNMENT: {
                return CreateElement.computeAssignment(set, compilationInfo, treePath, tree, n);
            }
            case ENHANCED_FOR_LOOP: {
                return CreateElement.computeEnhancedForLoop(set, compilationInfo, treePath, tree, n);
            }
            case ARRAY_ACCESS: {
                return CreateElement.computeArrayAccess(set, compilationInfo, treePath, tree, n);
            }
            case VARIABLE: {
                return CreateElement.computeVariableDeclaration(set, compilationInfo, treePath, tree, n);
            }
            case ASSERT: {
                return CreateElement.computeAssert(set, compilationInfo, treePath, tree, n);
            }
            case PARENTHESIZED: {
                return CreateElement.computeParenthesis(set, compilationInfo, treePath, tree, n);
            }
            case DO_WHILE_LOOP: {
                return CreateElement.computePrimitiveType(set, compilationInfo, ((DoWhileLoopTree)treePath.getLeaf()).getCondition(), tree, TypeKind.BOOLEAN);
            }
            case FOR_LOOP: {
                return CreateElement.computePrimitiveType(set, compilationInfo, ((ForLoopTree)treePath.getLeaf()).getCondition(), tree, TypeKind.BOOLEAN);
            }
            case IF: {
                return CreateElement.computePrimitiveType(set, compilationInfo, ((IfTree)treePath.getLeaf()).getCondition(), tree, TypeKind.BOOLEAN);
            }
            case WHILE_LOOP: {
                return CreateElement.computePrimitiveType(set, compilationInfo, ((WhileLoopTree)treePath.getLeaf()).getCondition(), tree, TypeKind.BOOLEAN);
            }
            case SYNCHRONIZED: {
                return CreateElement.computeReferenceType(set, compilationInfo, ((SynchronizedTree)treePath.getLeaf()).getExpression(), tree, "java.lang.Object");
            }
            case THROW: {
                return CreateElement.computeReferenceType(set, compilationInfo, ((ThrowTree)treePath.getLeaf()).getExpression(), tree, "java.lang.Exception");
            }
            case INSTANCE_OF: {
                return CreateElement.computeReferenceType(set, compilationInfo, ((InstanceOfTree)treePath.getLeaf()).getExpression(), tree, "java.lang.Object");
            }
            case SWITCH: {
                return CreateElement.computePrimitiveType(set, compilationInfo, ((SwitchTree)treePath.getLeaf()).getExpression(), tree, TypeKind.INT);
            }
            case RETURN: {
                return CreateElement.computeReturn(set, compilationInfo, treePath, tree, n);
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                return CreateElement.computeUnary(set, compilationInfo, treePath, tree, n);
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                return CreateElement.computeBinaryOperator(set, compilationInfo, treePath, tree, n);
            }
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                return null;
            }
            case ARRAY_TYPE: 
            case BLOCK: 
            case BREAK: 
            case CATCH: 
            case CLASS: 
            case COMPILATION_UNIT: 
            case CONTINUE: 
            case EXPRESSION_STATEMENT: 
            case IMPORT: 
            case IDENTIFIER: 
            case TYPE_CAST: 
            case PARAMETERIZED_TYPE: 
            case TRY: 
            case EMPTY_STATEMENT: 
            case PRIMITIVE_TYPE: 
            case LABELED_STATEMENT: 
            case MODIFIERS: 
            case ERRONEOUS: 
            case OTHER: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: 
            case TYPE_PARAMETER: {
                return null;
            }
            case CASE: 
            case ANNOTATION: 
            case CONDITIONAL_EXPRESSION: 
            case NEW_ARRAY: 
            case NEW_CLASS: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: {
                return null;
            }
        }
        return null;
    }

    private static List<? extends TypeMirror> computeBinaryOperator(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        BinaryTree binaryTree = (BinaryTree)treePath.getLeaf();
        TreePath treePath2 = null;
        if (binaryTree.getLeftOperand() == tree) {
            treePath2 = new TreePath(treePath, binaryTree.getRightOperand());
        }
        if (binaryTree.getRightOperand() == tree) {
            treePath2 = new TreePath(treePath, binaryTree.getLeftOperand());
        }
        set.add(FixTypes.PARAM);
        set.add(FixTypes.LOCAL);
        set.add(FixTypes.FIELD);
        return treePath2 != null ? Collections.singletonList(compilationInfo.getTrees().getTypeMirror(treePath2)) : null;
    }

    private static List<? extends TypeMirror> computeMethod(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        MethodTree methodTree = (MethodTree)treePath.getLeaf();
        if (methodTree.getBody() == null) {
            return null;
        }
        try {
            int n2 = Utilities.findBodyStart((Tree)treePath.getLeaf(), (CompilationUnitTree)compilationInfo.getCompilationUnit(), (SourcePositions)compilationInfo.getTrees().getSourcePositions(), (Document)compilationInfo.getDocument());
            int n3 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
            set.add(FixTypes.PARAM);
            set.add(FixTypes.LOCAL);
            set.add(FixTypes.FIELD);
            if (n2 <= n && n <= n3) {
                return Collections.singletonList(compilationInfo.getElements().getTypeElement("java.lang.Object").asType());
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, iOException.getMessage(), iOException);
        }
        return null;
    }

    private static List<? extends TypeMirror> computeMemberSelect(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        MemberSelectTree memberSelectTree = (MemberSelectTree)treePath.getLeaf();
        if (!"class".equals(memberSelectTree.getIdentifier().toString())) {
            set.add(FixTypes.FIELD);
            return Collections.singletonList(compilationInfo.getElements().getTypeElement("java.lang.Object").asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeAssignment(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        AssignmentTree assignmentTree = (AssignmentTree)treePath.getLeaf();
        TypeMirror typeMirror = null;
        if (assignmentTree.getVariable() == tree && (typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, assignmentTree.getExpression()))).getKind() == TypeKind.EXECUTABLE) {
            typeMirror = ((ExecutableType)typeMirror).getReturnType();
        }
        if (assignmentTree.getExpression() == tree) {
            typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, assignmentTree.getVariable()));
        }
        if (typeMirror == null) {
            if (JavaHintsProvider.ERR.isLoggable(1)) {
                JavaHintsProvider.ERR.log(1, "offset=" + n);
                JavaHintsProvider.ERR.log(1, "errorTree=" + tree);
                JavaHintsProvider.ERR.log(1, "type=null");
            }
            return null;
        }
        set.add(FixTypes.PARAM);
        set.add(FixTypes.LOCAL);
        set.add(FixTypes.FIELD);
        return Collections.singletonList(typeMirror);
    }

    private static List<? extends TypeMirror> computeEnhancedForLoop(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)treePath.getLeaf();
        if (enhancedForLoopTree.getExpression() != tree) {
            return null;
        }
        set.add(FixTypes.PARAM);
        set.add(FixTypes.LOCAL);
        set.add(FixTypes.FIELD);
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Iterable");
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(new TreePath(treePath, enhancedForLoopTree.getVariable()), enhancedForLoopTree.getVariable().getType()));
        return Collections.singletonList(compilationInfo.getTypes().getDeclaredType(typeElement, typeMirror));
    }

    private static List<? extends TypeMirror> computeArrayAccess(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        ArrayAccessTree arrayAccessTree = (ArrayAccessTree)treePath.getLeaf();
        if (arrayAccessTree.getExpression() == tree) {
            TreePath treePath2 = treePath.getParentPath();
            List<? extends TypeMirror> list = CreateElement.resolveType(set, compilationInfo, treePath2, arrayAccessTree, n);
            if (list == null) {
                return null;
            }
            ArrayList<ArrayType> arrayList = new ArrayList<ArrayType>();
            for (TypeMirror typeMirror : list) {
                arrayList.add(compilationInfo.getTypes().getArrayType(typeMirror));
            }
            return arrayList;
        }
        if (arrayAccessTree.getIndex() == tree) {
            set.add(FixTypes.PARAM);
            set.add(FixTypes.LOCAL);
            set.add(FixTypes.FIELD);
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(TypeKind.INT));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeVariableDeclaration(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        VariableTree variableTree = (VariableTree)treePath.getLeaf();
        if (variableTree.getInitializer() != tree) {
            return null;
        }
        set.add(FixTypes.PARAM);
        set.add(FixTypes.LOCAL);
        set.add(FixTypes.FIELD);
        return Collections.singletonList(compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, variableTree.getType())));
    }

    private static List<? extends TypeMirror> computeAssert(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        AssertTree assertTree = (AssertTree)treePath.getLeaf();
        set.add(FixTypes.PARAM);
        set.add(FixTypes.LOCAL);
        set.add(FixTypes.FIELD);
        if (assertTree.getCondition() == tree) {
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(TypeKind.BOOLEAN));
        }
        if (assertTree.getDetail() == tree) {
            return Collections.singletonList(compilationInfo.getElements().getTypeElement("java.lang.Object").asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeParenthesis(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        ParenthesizedTree parenthesizedTree = (ParenthesizedTree)treePath.getLeaf();
        if (parenthesizedTree.getExpression() != tree) {
            return null;
        }
        TreePath treePath2 = treePath.getParentPath();
        List<? extends TypeMirror> list = CreateElement.resolveType(set, compilationInfo, treePath2, parenthesizedTree, n);
        if (list == null) {
            return null;
        }
        return list;
    }

    private static List<? extends TypeMirror> computePrimitiveType(Set<FixTypes> set, CompilationInfo compilationInfo, Tree tree, Tree tree2, TypeKind typeKind) {
        if (tree == tree2) {
            set.add(FixTypes.PARAM);
            set.add(FixTypes.LOCAL);
            set.add(FixTypes.FIELD);
            return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(typeKind));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeReferenceType(Set<FixTypes> set, CompilationInfo compilationInfo, Tree tree, Tree tree2, String string) {
        if (tree == tree2) {
            set.add(FixTypes.PARAM);
            set.add(FixTypes.LOCAL);
            set.add(FixTypes.FIELD);
            return Collections.singletonList(compilationInfo.getElements().getTypeElement(string).asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeUnary(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        UnaryTree unaryTree = (UnaryTree)treePath.getLeaf();
        if (unaryTree.getExpression() == tree) {
            List<? extends TypeMirror> list = CreateElement.resolveType(set, compilationInfo, treePath.getParentPath(), unaryTree, n);
            if (list == null) {
                set.add(FixTypes.PARAM);
                set.add(FixTypes.LOCAL);
                set.add(FixTypes.FIELD);
                return Collections.singletonList(compilationInfo.getTypes().getPrimitiveType(TypeKind.INT));
            }
            return list;
        }
        return null;
    }

    private static List<? extends TypeMirror> computeReturn(Set<FixTypes> set, CompilationInfo compilationInfo, TreePath treePath, Tree tree, int n) {
        ReturnTree returnTree = (ReturnTree)treePath.getLeaf();
        if (returnTree.getExpression() == tree) {
            TreePath treePath2 = CreateElement.findMethod(treePath);
            if (treePath2 == null) {
                return null;
            }
            Element element = compilationInfo.getTrees().getElement(treePath2);
            if (element == null || element.getKind() != ElementKind.METHOD) {
                return null;
            }
            set.add(FixTypes.PARAM);
            set.add(FixTypes.LOCAL);
            set.add(FixTypes.FIELD);
            return Collections.singletonList(((ExecutableElement)element).getReturnType());
        }
        return null;
    }

    private static TreePath findMethod(TreePath treePath) {
        while (!STOP_LOOKING_FOR_METHOD.contains((Object)treePath.getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
            return treePath;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CreateFieldFix
    implements Fix {
        private FileObject targetFile;
        private ElementHandle<TypeElement> target;
        private TypeMirrorHandle proposedType;
        private ClasspathInfo cpInfo;
        private Set<Modifier> modifiers;
        private String name;
        private String inFQN;

        public CreateFieldFix(CompilationInfo compilationInfo, String string, Set<Modifier> set, TypeElement typeElement, TypeMirror typeMirror) {
            this.name = string;
            this.inFQN = typeElement.getQualifiedName().toString();
            this.cpInfo = compilationInfo.getClasspathInfo();
            this.modifiers = set;
            this.targetFile = SourceUtils.getFile((Element)typeElement, (ClasspathInfo)this.cpInfo);
            this.target = ElementHandle.create((Element)typeElement);
            if (typeMirror.getKind() == TypeKind.NULL) {
                typeMirror = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
            }
            this.proposedType = TypeMirrorHandle.create((TypeMirror)typeMirror);
        }

        public String getText() {
            return "Create field " + this.name + " in " + this.inFQN;
        }

        public ChangeInfo implement() {
            try {
                JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
                javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement typeElement = (TypeElement)CreateFieldFix.this.target.resolve((CompilationInfo)workingCopy);
                        if (typeElement == null) {
                            JavaHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                            return;
                        }
                        ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                        if (classTree == null) {
                            JavaHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + typeElement.getQualifiedName() + ".");
                            return;
                        }
                        TypeMirror typeMirror = CreateFieldFix.this.proposedType.resolve((CompilationInfo)workingCopy);
                        if (typeMirror == null) {
                            JavaHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                            return;
                        }
                        TreeMaker treeMaker = workingCopy.getTreeMaker();
                        TypeMirror typeMirror2 = typeMirror;
                        VariableTree variableTree = null;
                        if (typeMirror2.getKind() == TypeKind.DECLARED || typeMirror2.getKind() == TypeKind.ARRAY) {
                            variableTree = treeMaker.Variable(treeMaker.Modifiers(CreateFieldFix.this.modifiers), (CharSequence)CreateFieldFix.this.name, treeMaker.Type(typeMirror2), null);
                        }
                        if (typeMirror2.getKind().isPrimitive()) {
                            variableTree = treeMaker.Variable(treeMaker.Modifiers(CreateFieldFix.this.modifiers), (CharSequence)CreateFieldFix.this.name, treeMaker.Type(typeMirror2), null);
                        }
                        assert (variableTree != null) : typeMirror2.getKind();
                        ClassTree classTree2 = treeMaker.addClassMember(classTree, variableTree);
                        workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                    }
                }).commit();
            }
            catch (IOException iOException) {
                throw (IllegalStateException)new IllegalStateException().initCause(iOException);
            }
            return null;
        }

        String toDebugString(CompilationInfo compilationInfo) {
            return "CreateFieldFix:" + this.name + ":" + this.target.getQualifiedName() + ":" + ((Object)this.proposedType.resolve(compilationInfo)).toString() + ":" + this.modifiers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FixTypes {
        PARAM,
        LOCAL,
        FIELD;

    }
}

