/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HintsTask
extends ScanningCancellableTask<CompilationInfo> {
    public void run(CompilationInfo compilationInfo) throws Exception {
        Map<Tree.Kind, List<TreeRule>> map = RulesManager.getInstance().getHints();
        if (map.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.scan(new ScannerImpl(compilationInfo, map), compilationInfo.getCompilationUnit(), arrayList);
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)HintsTask.class.getName(), arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScannerImpl
    extends CancellableTreePathScanner<Void, List<ErrorDescription>> {
        private CompilationInfo info;
        private Map<Tree.Kind, List<TreeRule>> hints;

        public ScannerImpl(CompilationInfo compilationInfo, Map<Tree.Kind, List<TreeRule>> map) {
            this.info = compilationInfo;
            this.hints = map;
        }

        private void runAndAdd(TreePath treePath, List<TreeRule> list, List<ErrorDescription> list2) {
            if (list != null) {
                for (TreeRule treeRule : list) {
                    if (this.isCanceled()) {
                        return;
                    }
                    List<ErrorDescription> list3 = treeRule.run(this.info, treePath);
                    if (list3 == null) continue;
                    list2.addAll(list3);
                }
            }
        }

        public Void scan(Tree tree, List<ErrorDescription> list) {
            if (tree == null) {
                return null;
            }
            TreePath treePath = new TreePath(this.getCurrentPath(), tree);
            Tree.Kind kind = tree.getKind();
            this.runAndAdd(treePath, this.hints.get((Object)kind), list);
            if (this.isCanceled()) {
                return null;
            }
            return (Void)super.scan(tree, list);
        }

        public Void scan(TreePath treePath, List<ErrorDescription> list) {
            Tree.Kind kind = treePath.getLeaf().getKind();
            this.runAndAdd(treePath, this.hints.get((Object)kind), list);
            if (this.isCanceled()) {
                return null;
            }
            return (Void)super.scan(treePath, list);
        }
    }
}

