/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.netbeans.modules.java.hints.Pair;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.Rule;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesManager {
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private static final String INSTANCE_EXT = ".instance";
    private static final String RULES_FOLDER = "org-netbeans-modules-java-hints/rules/";
    private static final String ERRORS = "errors";
    private static final String HINTS = "hints";
    private static final String SUGGESTIONS = "suggestions";
    private static Map<String, List<ErrorRule>> errors = new HashMap<String, List<ErrorRule>>();
    private static Map<Tree.Kind, List<TreeRule>> hints = new HashMap<Tree.Kind, List<TreeRule>>();
    private static Map<Tree.Kind, List<TreeRule>> suggestions = new HashMap<Tree.Kind, List<TreeRule>>();
    private static TreeModel errorsTreeModel;
    private static TreeModel hintsTreeModel;
    private static TreeModel suggestionsTreeModel;
    private static RulesManager INSTANCE;

    private RulesManager() {
        RulesManager.initErrors();
        RulesManager.initHints();
        RulesManager.initSuggestions();
    }

    public static synchronized RulesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RulesManager();
        }
        return INSTANCE;
    }

    public Map<String, List<ErrorRule>> getErrors() {
        return errors;
    }

    public Map<Tree.Kind, List<TreeRule>> getHints() {
        return hints;
    }

    public Map<Tree.Kind, List<TreeRule>> getSuggestions() {
        return suggestions;
    }

    public TreeModel getErrorsTreeModel() {
        return errorsTreeModel;
    }

    public TreeModel getHintsTreeModel() {
        return hintsTreeModel;
    }

    public TreeModel getSuggestionsTreeModel() {
        return suggestionsTreeModel;
    }

    private static void initErrors() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        errorsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/errors");
        List<Pair<Rule, FileObject>> list = RulesManager.readRules(fileObject);
        RulesManager.categorizeErrorRules(list, errors, fileObject, defaultMutableTreeNode);
    }

    private static void initHints() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        hintsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/hints");
        List<Pair<Rule, FileObject>> list = RulesManager.readRules(fileObject);
        RulesManager.categorizeTreeRules(list, hints, fileObject, defaultMutableTreeNode);
    }

    private static void initSuggestions() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        suggestionsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/suggestions");
        List<Pair<Rule, FileObject>> list = RulesManager.readRules(fileObject);
        RulesManager.categorizeTreeRules(list, suggestions, fileObject, defaultMutableTreeNode);
    }

    private static List<Pair<Rule, FileObject>> readRules(FileObject fileObject) {
        LinkedList<Pair<Rule, FileObject>> linkedList = new LinkedList<Pair<Rule, FileObject>>();
        if (fileObject == null) {
            return linkedList;
        }
        HashMap hashMap = new HashMap();
        Enumeration enumeration = fileObject.getData(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            String string = fileObject2.getNameExt().toLowerCase();
            if (!fileObject2.canRead()) continue;
            Rule rule = null;
            if (string.endsWith(INSTANCE_EXT)) {
                rule = RulesManager.instantiateRule(fileObject2);
            }
            if (rule == null) continue;
            linkedList.add(new Pair<Rule, FileObject>(rule, fileObject2));
        }
        return linkedList;
    }

    private static void categorizeErrorRules(List<Pair<Rule, FileObject>> list, Map<String, List<ErrorRule>> map, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof ErrorRule) {
                RulesManager.addRule((ErrorRule)rule, map);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of ErrorRule");
        }
    }

    private static void categorizeTreeRules(List<Pair<Rule, FileObject>> list, Map<Tree.Kind, List<TreeRule>> map, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof TreeRule) {
                RulesManager.addRule((TreeRule)rule, map);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of TreeRule");
        }
    }

    private static void addRule(TreeRule treeRule, Map<Tree.Kind, List<TreeRule>> map) {
        for (Tree.Kind kind : treeRule.getTreeKinds()) {
            List<TreeRule> list = map.get((Object)kind);
            if (list == null) {
                list = new LinkedList<TreeRule>();
                map.put(kind, list);
            }
            list.add(treeRule);
        }
    }

    private static void addRule(ErrorRule errorRule, Map<String, List<ErrorRule>> map) {
        for (String string : errorRule.getCodes()) {
            List<ErrorRule> list = map.get(string);
            if (list == null) {
                list = new LinkedList<ErrorRule>();
                map.put(string, list);
            }
            list.add(errorRule);
        }
    }

    private static Rule instantiateRule(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            Object object = instanceCookie.instanceCreate();
            if (object instanceof Rule) {
                return (Rule)object;
            }
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.INFO, null, classNotFoundException);
        }
        return null;
    }
}

