/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsTask
extends ScanningCancellableTask<CompilationInfo> {
    public void run(CompilationInfo compilationInfo) throws Exception {
        Map<Tree.Kind, List<TreeRule>> map = RulesManager.getInstance().getSuggestions();
        if (map.isEmpty()) {
            return;
        }
        int n = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject());
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (n != -1) {
            for (TreePath treePath = compilationInfo.getTreeUtilities().pathFor(n); treePath != null; treePath = treePath.getParentPath()) {
                if (this.isCancelled()) {
                    return;
                }
                Tree.Kind kind = treePath.getLeaf().getKind();
                List<TreeRule> list = map.get((Object)kind);
                if (list == null) continue;
                for (TreeRule treeRule : list) {
                    if (this.isCancelled()) {
                        return;
                    }
                    List<ErrorDescription> list2 = treeRule.run(compilationInfo, treePath);
                    if (list2 == null) continue;
                    arrayList.addAll(list2);
                }
            }
        }
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)SuggestionsTask.class.getName(), arrayList);
    }
}

