/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.EventListener;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public final class MimePathLookup
extends ProxyLookup
implements LookupListener {
    private MimePath mimePath;
    private Lookup.Result<MimeDataProvider> dataProviders;
    private Lookup.Result<MimeLookupInitializer> mimeInitializers;

    public MimePathLookup(MimePath mimePath) {
        if (mimePath == null) {
            throw new NullPointerException("Mime path can't be null.");
        }
        this.mimePath = mimePath;
        this.dataProviders = Lookup.getDefault().lookup(new Lookup.Template(MimeDataProvider.class));
        this.dataProviders.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.dataProviders));
        this.mimeInitializers = Lookup.getDefault().lookup(new Lookup.Template(MimeLookupInitializer.class));
        this.mimeInitializers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.mimeInitializers));
        this.rebuild();
    }

    public MimePath getMimePath() {
        return this.mimePath;
    }

    private void rebuild() {
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        for (Object object : this.dataProviders.allInstances()) {
            Lookup lookup = object.getLookup(this.mimePath);
            if (lookup == null) continue;
            arrayList.add(lookup);
        }
        for (Object object : this.mimeInitializers.allInstances()) {
            for (int i = 0; i < this.mimePath.size(); ++i) {
                Lookup.Result result = object.child(this.mimePath.getMimeType(i));
                for (MimeLookupInitializer mimeLookupInitializer : result.allInstances()) {
                    Lookup lookup = mimeLookupInitializer.lookup();
                    if (lookup == null) continue;
                    arrayList.add(lookup);
                }
            }
        }
        this.setLookups(arrayList.toArray(new Lookup[arrayList.size()]));
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.rebuild();
    }
}

