/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SVNRevision {
    protected static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssZ");
    protected int revKind;
    public static final SVNRevision HEAD = new SVNRevision(7);
    public static final SVNRevision START = new SVNRevision(0);
    public static final SVNRevision COMMITTED = new SVNRevision(3);
    public static final SVNRevision PREVIOUS = new SVNRevision(4);
    public static final SVNRevision BASE = new SVNRevision(5);
    public static final SVNRevision WORKING = new SVNRevision(6);
    public static final int SVN_INVALID_REVNUM = -1;
    public static final Number INVALID_REVISION = new Number(-1L);

    public SVNRevision(int kind) {
        this.revKind = kind;
    }

    public int getKind() {
        return this.revKind;
    }

    public String toString() {
        switch (this.revKind) {
            case 0: {
                return "START";
            }
            case 5: {
                return "BASE";
            }
            case 3: {
                return "COMMITTED";
            }
            case 7: {
                return "HEAD";
            }
            case 4: {
                return "PREV";
            }
            case 6: {
                return "WORKING";
            }
        }
        return super.toString();
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof SVNRevision)) {
            return false;
        }
        return ((SVNRevision)target).revKind == this.revKind;
    }

    public int hashCode() {
        return this.revKind;
    }

    public static SVNRevision getRevision(String revision, SimpleDateFormat aDateFormat) throws ParseException {
        if (revision == null || revision.equals("")) {
            return null;
        }
        if (revision.compareToIgnoreCase("HEAD") == 0) {
            return HEAD;
        }
        if (revision.compareToIgnoreCase("BASE") == 0) {
            return new SVNRevision(5);
        }
        if (revision.compareToIgnoreCase("COMMITED") == 0) {
            return new SVNRevision(3);
        }
        if (revision.compareToIgnoreCase("PREV") == 0) {
            return new SVNRevision(4);
        }
        try {
            int revisionNumber = Integer.parseInt(revision);
            if (revisionNumber >= 0) {
                return new Number((long)revisionNumber);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        SimpleDateFormat df = aDateFormat != null ? aDateFormat : new SimpleDateFormat("MM/dd/yyyy hh:mm a", Locale.US);
        try {
            Date revisionDate = df.parse(revision);
            return new DateSpec(revisionDate);
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid revision. Revision should be a number, a date in " + df.toPattern() + " format or HEAD, BASE, COMMITED or PREV", 0);
        }
    }

    public static SVNRevision getRevision(String revision) throws ParseException {
        return SVNRevision.getRevision(revision, new SimpleDateFormat("MM/dd/yyyy hh:mm a", Locale.US));
    }

    public static class DateSpec
    extends SVNRevision {
        protected Date revDate;

        public DateSpec(Date date) {
            super(2);
            this.revDate = date;
        }

        public Date getDate() {
            return this.revDate;
        }

        public String toString() {
            return '{' + dateFormat.format(this.revDate) + '}';
        }

        public boolean equals(Object target) {
            if (!super.equals(target)) {
                return false;
            }
            return ((DateSpec)target).revDate.equals(this.revDate);
        }

        public int hashCode() {
            return this.revDate.hashCode();
        }
    }

    public static final class Kind {
        public static final int unspecified = 0;
        public static final int number = 1;
        public static final int date = 2;
        public static final int committed = 3;
        public static final int previous = 4;
        public static final int base = 5;
        public static final int working = 6;
        public static final int head = 7;
    }

    public static class Number
    extends SVNRevision {
        protected long revNumber;

        public Number(long number) {
            super(1);
            this.revNumber = number;
        }

        public long getNumber() {
            return this.revNumber;
        }

        public String toString() {
            return Long.toString(this.revNumber);
        }

        public boolean equals(Object target) {
            if (!super.equals(target)) {
                return false;
            }
            return ((Number)target).revNumber == this.revNumber;
        }

        public int hashCode() {
            return (int)this.revNumber;
        }
    }
}

