/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter12;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;

public class CmdLineClientAdapterFactory
extends SVNClientAdapterFactory {
    public static final String COMMANDLINE_CLIENT = "commandline";
    private static boolean is13ClientAvailable = false;
    private String subversionPath;

    private CmdLineClientAdapterFactory(String subversionPath) {
        this.subversionPath = subversionPath;
    }

    protected ISVNClientAdapter createSVNClientImpl() {
        if (is13ClientAvailable) {
            return new CmdLineClientAdapter(this.subversionPath, new CmdLineNotificationHandler());
        }
        return new CmdLineClientAdapter12(this.subversionPath, new CmdLineNotificationHandler());
    }

    protected String getClientType() {
        return COMMANDLINE_CLIENT;
    }

    public static void setup() throws SVNClientException {
        CmdLineClientAdapterFactory.setup(null);
    }

    public static void setup(String subversionPath) throws SVNClientException {
        if (subversionPath.length() > 0 && !subversionPath.endsWith(File.separator)) {
            subversionPath = subversionPath + File.separator;
        }
        if (!CmdLineClientAdapter12.isAvailable(subversionPath)) {
            throw new SVNClientException("Command line client adapter is not available");
        }
        is13ClientAvailable = CmdLineClientAdapter.isAvailable(subversionPath);
        SVNClientAdapterFactory.registerAdapterFactory(new CmdLineClientAdapterFactory(subversionPath));
    }
}

