/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.utils;

import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class SVNStatusUtils {
    public static boolean isManaged(SVNStatusKind textStatus) {
        return !textStatus.equals(SVNStatusKind.UNVERSIONED) && !textStatus.equals(SVNStatusKind.NONE) && !textStatus.equals(SVNStatusKind.IGNORED);
    }

    public static boolean isManaged(ISVNStatus status) {
        return SVNStatusUtils.isManaged(status.getTextStatus());
    }

    public static boolean hasRemote(SVNStatusKind textStatus) {
        return SVNStatusUtils.isManaged(textStatus) && !textStatus.equals(SVNStatusKind.ADDED);
    }

    public static boolean hasRemote(ISVNStatus status) {
        return SVNStatusUtils.hasRemote(status.getTextStatus());
    }

    public static boolean isAdded(ISVNStatus status) {
        return status.getTextStatus().equals(SVNStatusKind.ADDED);
    }

    public static boolean isDeleted(ISVNStatus status) {
        return status.getTextStatus().equals(SVNStatusKind.DELETED);
    }

    public static boolean isReplaced(ISVNStatus status) {
        return status.getTextStatus().equals(SVNStatusKind.REPLACED);
    }

    public static boolean isMissing(ISVNStatus status) {
        return status.getTextStatus().equals(SVNStatusKind.MISSING);
    }

    public static boolean isIgnored(ISVNStatus status) {
        return status.getTextStatus().equals(SVNStatusKind.IGNORED);
    }

    public static boolean isTextMerged(ISVNStatus status) {
        return status.getTextStatus().equals(SVNStatusKind.MERGED);
    }

    public static boolean isTextModified(ISVNStatus status) {
        return status.getTextStatus().equals(SVNStatusKind.MODIFIED);
    }

    public static boolean isTextConflicted(ISVNStatus status) {
        return status.getTextStatus().equals(SVNStatusKind.CONFLICTED);
    }

    public static boolean isPropModified(ISVNStatus status) {
        return status.getPropStatus().equals(SVNStatusKind.MODIFIED);
    }

    public static boolean isPropConflicted(ISVNStatus status) {
        return status.getPropStatus().equals(SVNStatusKind.CONFLICTED);
    }

    public static boolean isReadyForCommit(ISVNStatus status) {
        return SVNStatusUtils.isTextModified(status) || SVNStatusUtils.isAdded(status) || SVNStatusUtils.isDeleted(status) || SVNStatusUtils.isReplaced(status) || SVNStatusUtils.isPropModified(status) || SVNStatusUtils.isTextConflicted(status) || SVNStatusUtils.isPropConflicted(status) || !SVNStatusUtils.isManaged(status) && !SVNStatusUtils.isIgnored(status);
    }

    public static boolean isReadyForRevert(ISVNStatus status) {
        return SVNStatusUtils.isTextModified(status) || SVNStatusUtils.isAdded(status) || SVNStatusUtils.isDeleted(status) || SVNStatusUtils.isMissing(status) || SVNStatusUtils.isReplaced(status) || SVNStatusUtils.isPropModified(status) || SVNStatusUtils.isTextConflicted(status) || SVNStatusUtils.isPropConflicted(status);
    }
}

