/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.settings;

import java.beans.IntrospectionException;
import java.util.prefs.Preferences;
import org.netbeans.modules.xml.core.settings.Util;
import org.openide.nodes.BeanNode;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;

public class CoreSettings {
    private static final CoreSettings INSTANCE = new CoreSettings();
    public static final String PROP_AUTO_PARSING_DELAY = "autoParsingDelay";
    public static final String PROP_DEFAULT_ACTION = "defaultAction";
    public static final String PROP_PREFERED_SHORT_EMPTY_ELEMENT = "preferedShortEmptyElement";

    private static Preferences getPreferences() {
        return NbPreferences.forModule((Class)CoreSettings.class);
    }

    public static CoreSettings getDefault() {
        return INSTANCE;
    }

    private CoreSettings() {
    }

    public String displayName() {
        String string = Util.THIS.getString("CTL_XML_option");
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::displayName = " + string);
        }
        return string;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public int getAutoParsingDelay() {
        int n = CoreSettings.getPreferences().getInt(PROP_AUTO_PARSING_DELAY, 3000);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::getAutoParsingDelay: " + n);
        }
        return n;
    }

    public void setAutoParsingDelay(int n) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CoreSettings::setAutoParsingDelay: " + n);
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        CoreSettings.getPreferences().putInt(PROP_AUTO_PARSING_DELAY, n);
    }

    public String getDefaultAction() {
        return CoreSettings.getPreferences().get(PROP_DEFAULT_ACTION, null);
    }

    public void setDefaultAction(String string) {
        CoreSettings.getPreferences().put(PROP_DEFAULT_ACTION, string);
    }

    public SystemAction getDefaultAction(SystemAction[] systemActionArray, SystemAction systemAction) {
        String string = this.getDefaultAction();
        if (string == null) {
            return systemAction;
        }
        if (systemActionArray == null) {
            return systemAction;
        }
        for (int i = 0; i < systemActionArray.length; ++i) {
            Class<?> clazz;
            String string2;
            SystemAction systemAction2 = systemActionArray[i];
            if (systemAction2 == null || !(string2 = (clazz = systemAction2.getClass()).getName()).equals(string)) continue;
            return systemAction2;
        }
        return systemAction;
    }

    public boolean isPreferedShortEmptyElement() {
        return CoreSettings.getPreferences().getBoolean(PROP_PREFERED_SHORT_EMPTY_ELEMENT, false);
    }

    public void setPreferedShortEmptyElement(boolean bl) {
        CoreSettings.getPreferences().putBoolean(PROP_PREFERED_SHORT_EMPTY_ELEMENT, bl);
    }

    private static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)CoreSettings.getDefault());
    }
}

