/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.JavaHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

public class AddParameterOrLocalFix
implements Fix {
    private FileObject file;
    private TypeMirrorHandle type;
    private String name;
    private boolean parameter;
    private int unresolvedVariable;

    public AddParameterOrLocalFix(CompilationInfo compilationInfo, TypeMirror typeMirror, String string, boolean bl, int n) {
        this.file = compilationInfo.getFileObject();
        if (typeMirror.getKind() == TypeKind.NULL) {
            typeMirror = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
        }
        this.type = TypeMirrorHandle.create((TypeMirror)typeMirror);
        this.name = string;
        this.parameter = bl;
        this.unresolvedVariable = n;
    }

    public String getText() {
        return this.parameter ? "Create parameter " + this.name : "Create local variable " + this.name;
    }

    public ChangeInfo implement() {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TypeMirror typeMirror = AddParameterOrLocalFix.this.type.resolve((CompilationInfo)workingCopy);
                    if (typeMirror == null) {
                        JavaHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                        return;
                    }
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    TreePath treePath = workingCopy.getTreeUtilities().pathFor(AddParameterOrLocalFix.this.unresolvedVariable + 1);
                    assert (treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER);
                    MethodTree methodTree = AddParameterOrLocalFix.this.findMethod(treePath);
                    if (AddParameterOrLocalFix.this.parameter) {
                        if (methodTree == null) {
                            Logger.getLogger("global").log(Level.WARNING, "Add parameter - cannot find the method.");
                        }
                        MethodTree methodTree2 = treeMaker.addMethodParameter(methodTree, treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)AddParameterOrLocalFix.this.name, treeMaker.Type(typeMirror), null));
                        workingCopy.rewrite((Tree)methodTree, (Tree)methodTree2);
                    } else {
                        AddParameterOrLocalFix.this.resolveLocalVariable(workingCopy, treePath, treeMaker, typeMirror);
                    }
                }
            }).commit();
        }
        catch (IOException iOException) {
            throw (IllegalStateException)new IllegalStateException().initCause(iOException);
        }
        return null;
    }

    private void resolveLocalVariable(WorkingCopy workingCopy, TreePath treePath, TreeMaker treeMaker, TypeMirror typeMirror) {
        Tree tree;
        String string = ((IdentifierTree)treePath.getLeaf()).getName().toString();
        final Element element = workingCopy.getTrees().getElement(treePath);
        TreePath treePath2 = treePath;
        while (treePath2.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && treePath2.getLeaf().getKind() != Tree.Kind.METHOD) {
            treePath2 = treePath2.getParentPath();
        }
        if (treePath2.getLeaf().getKind() != Tree.Kind.METHOD) {
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FirstUsage
        extends TreePathScanner<TreePath, Void> {
            private TreePath found;

            FirstUsage() {
            }

            @Override
            public TreePath visitIdentifier(IdentifierTree identifierTree, Void void_) {
                if (identifierTree.getName().contentEquals(element.getSimpleName())) {
                    if (this.found == null) {
                        this.found = this.getCurrentPath();
                    }
                    return AddParameterOrLocalFix.this.findStatement(this.getCurrentPath());
                }
                return null;
            }

            @Override
            public TreePath visitBlock(BlockTree blockTree, Void void_) {
                TreePath treePath = null;
                TreePath treePath2 = null;
                for (StatementTree statementTree : blockTree.getStatements()) {
                    TreePath treePath3 = (TreePath)this.scan(statementTree, null);
                    if (treePath3 != null && treePath == null) {
                        treePath = treePath3;
                        treePath2 = new TreePath(this.getCurrentPath(), statementTree);
                    }
                    if (treePath3 == statementTree || treePath == null || treePath.getLeaf() == treePath2.getLeaf()) continue;
                    treePath = treePath2;
                }
                super.visitBlock(blockTree, void_);
                return treePath;
            }

            @Override
            public TreePath reduce(TreePath treePath, TreePath treePath2) {
                if (treePath2 == null) {
                    return treePath;
                }
                return treePath2;
            }
        }
        FirstUsage firstUsage = new FirstUsage();
        TreePath treePath3 = (TreePath)firstUsage.scan(treePath2, null);
        if (treePath3 == null || !this.isStatement(treePath3.getLeaf())) {
            Logger.getLogger("global").log(Level.WARNING, "Add local variable - cannot find a statement.");
            return;
        }
        StatementTree statementTree = (StatementTree)treePath3.getLeaf();
        if (statementTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (tree = ((ExpressionStatementTree)statementTree).getExpression()).getKind() == Tree.Kind.ASSIGNMENT) {
            AssignmentTree assignmentTree = (AssignmentTree)tree;
            VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)string, treeMaker.Type(typeMirror), assignmentTree.getExpression());
            workingCopy.rewrite((Tree)statementTree, (Tree)variableTree);
            return;
        }
        tree = treePath3.getParentPath().getLeaf();
        VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)string, treeMaker.Type(typeMirror), null);
        if (tree.getKind() == Tree.Kind.BLOCK) {
            BlockTree blockTree = (BlockTree)tree;
            BlockTree blockTree2 = treeMaker.insertBlockStatement(blockTree, blockTree.getStatements().indexOf(statementTree), (StatementTree)variableTree);
            workingCopy.rewrite((Tree)blockTree, (Tree)blockTree2);
        } else {
            BlockTree blockTree = treeMaker.Block(Arrays.asList(variableTree, statementTree), false);
            workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
        }
    }

    private TreePath findStatement(TreePath treePath) {
        TreePath treePath2 = treePath;
        while (treePath2.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (this.isStatement(treePath2.getLeaf())) {
                return treePath2;
            }
            treePath2 = treePath2.getParentPath();
        }
        return null;
    }

    private MethodTree findMethod(TreePath treePath) {
        TreePath treePath2 = treePath;
        while (treePath2.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (treePath2.getLeaf().getKind() == Tree.Kind.METHOD) {
                return (MethodTree)treePath2.getLeaf();
            }
            treePath2 = treePath2.getParentPath();
        }
        return null;
    }

    private boolean isStatement(Tree tree) {
        Class<? extends Tree> clazz = tree.getKind().asInterface();
        return StatementTree.class.isAssignableFrom(clazz);
    }

    String toDebugString(CompilationInfo compilationInfo) {
        return "AddParameterOrLocalFix:" + this.name + ":" + ((Object)this.type.resolve(compilationInfo)).toString() + ":" + this.parameter;
    }
}

