/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.util.TreePath;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.LazyHintComputationFactory;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatorBasedLazyFixList
implements LazyFixList {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean computed;
    private boolean computing;
    private boolean cancelled;
    private List<Fix> fixes;
    private FileObject file;
    private String diagnosticKey;
    private int offset;
    private final Collection<ErrorRule> c;
    private final Map<Class, ErrorRule.Data> class2Data;
    private ErrorRule<?> currentRule;

    public CreatorBasedLazyFixList(FileObject fileObject, String string, int n, Collection<ErrorRule> collection, Map<Class, ErrorRule.Data> map) {
        this.file = fileObject;
        this.diagnosticKey = string;
        this.offset = n;
        this.c = collection;
        this.class2Data = map;
        this.fixes = Collections.emptyList();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean probablyContainsFixes() {
        return true;
    }

    public synchronized List<Fix> getFixes() {
        if (!this.computed && !this.computing) {
            LazyHintComputationFactory.addToCompute(this.file, this);
            this.computing = true;
        }
        return this.fixes;
    }

    public synchronized boolean isComputed() {
        return this.computed;
    }

    private synchronized void setCurrentRule(ErrorRule errorRule) {
        this.currentRule = errorRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(CompilationInfo compilationInfo) {
        Object object = this;
        synchronized (object) {
            this.cancelled = false;
            if (this.computed) {
                return;
            }
        }
        object = new ArrayList();
        TreePath treePath = compilationInfo.getTreeUtilities().pathFor(this.offset + 1);
        for (ErrorRule errorRule : this.c) {
            ErrorRule.Data data = this;
            synchronized (data) {
                if (this.cancelled) {
                    return;
                }
            }
            this.setCurrentRule(errorRule);
            try {
                List<Fix> list;
                data = this.class2Data.get(errorRule.getClass());
                if (data == null) {
                    data = new ErrorRule.Data();
                    this.class2Data.put(errorRule.getClass(), data);
                }
                if ((list = errorRule.run(compilationInfo, this.diagnosticKey, this.offset, treePath, data)) == null) continue;
                object.addAll(list);
            }
            finally {
                this.setCurrentRule(null);
            }
        }
        CreatorBasedLazyFixList creatorBasedLazyFixList = this;
        synchronized (creatorBasedLazyFixList) {
            if (this.cancelled) {
                return;
            }
            this.fixes = object;
            this.computed = true;
        }
        this.pcs.firePropertyChange("fixes", null, null);
        this.pcs.firePropertyChange("computed", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        CreatorBasedLazyFixList creatorBasedLazyFixList = this;
        synchronized (creatorBasedLazyFixList) {
            this.cancelled = true;
            if (this.currentRule != null) {
                this.currentRule.cancel();
            }
        }
    }
}

