/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImplementAllAbstractMethodsCreator
implements ErrorRule<Void> {
    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.abstract.cant.be.instantiated", "compiler.err.does.not.override.abstract", "compiler.err.abstract.cant.be.instantiated"));
    }

    @Override
    public List<Fix> run(final CompilationInfo compilationInfo, String string, final int n, TreePath treePath, ErrorRule.Data<Void> data) {
        final ArrayList<Fix> arrayList = new ArrayList<Fix>();
        ImplementAllAbstractMethodsCreator.analyze(compilationInfo.getJavaSource(), n, compilationInfo, new Performer(){

            public void fixAllAbstractMethods(TreePath treePath, Tree tree) {
                arrayList.add(new FixImpl(compilationInfo.getJavaSource(), n, null));
            }

            public void makeClassAbstract(Tree tree, String string) {
                arrayList.add(new FixImpl(compilationInfo.getJavaSource(), n, string));
            }
        });
        return arrayList;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return ImplementAllAbstractMethodsCreator.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Implement All Abstract Methods Fix";
    }

    @Override
    public String getDescription() {
        return "Implement All Abstract Methods Fix";
    }

    private static void analyze(JavaSource javaSource, int n, CompilationInfo compilationInfo, Performer performer) {
        boolean bl;
        final TreePath treePath = compilationInfo.getTreeUtilities().pathFor(n + 1);
        Element element = compilationInfo.getTrees().getElement(treePath);
        boolean bl2 = bl = element != null && (element.getKind().isClass() || element.getKind().isInterface());
        if (bl) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                if (!executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                performer.makeClassAbstract(treePath.getLeaf(), element.getSimpleName().toString());
                return;
            }
            performer.fixAllAbstractMethods(treePath, treePath.getLeaf());
        } else if (treePath.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            final boolean[] blArray = new boolean[]{false};
            new TreePathScanner(){

                public Object visitNewClass(NewClassTree newClassTree, Object object) {
                    if (treePath.getLeaf() == newClassTree) {
                        blArray[0] = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ERRONEOUS;
                    }
                    return super.visitNewClass(newClassTree, object);
                }
            }.scan(treePath.getParentPath(), null);
            if (!blArray[0]) {
                performer.fixAllAbstractMethods(treePath, treePath.getLeaf());
            }
        }
    }

    private static final class FixImpl
    implements Fix {
        private JavaSource js;
        private int offset;
        private String makeClassAbstractName;

        public FixImpl(JavaSource javaSource, int n, String string) {
            this.js = javaSource;
            this.offset = n;
            this.makeClassAbstractName = string;
        }

        public String getText() {
            return this.makeClassAbstractName == null ? "Implement all abstract methods" : "Make class " + this.makeClassAbstractName + " abstract";
        }

        public ChangeInfo implement() {
            try {
                final boolean[] blArray = new boolean[]{true};
                while (blArray[0]) {
                    blArray[0] = false;
                    this.js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                        public void cancel() {
                        }

                        public void run(final WorkingCopy workingCopy) throws IOException {
                            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                            ImplementAllAbstractMethodsCreator.analyze(FixImpl.this.js, FixImpl.this.offset, (CompilationInfo)workingCopy, new Performer(){

                                public void fixAllAbstractMethods(TreePath treePath, Tree tree) {
                                    if (tree.getKind() == Tree.Kind.NEW_CLASS) {
                                        int n = (int)workingCopy.getTrees().getSourcePositions().getEndPosition(workingCopy.getCompilationUnit(), tree);
                                        if (n != -1) {
                                            try {
                                                workingCopy.getDocument().insertString(n, " {}", null);
                                                FixImpl.this.offset = n + 1;
                                                blArray[0] = true;
                                            }
                                            catch (BadLocationException badLocationException) {
                                                Exceptions.printStackTrace((Throwable)badLocationException);
                                            }
                                            catch (IOException iOException) {
                                                Exceptions.printStackTrace((Throwable)iOException);
                                            }
                                        }
                                    } else {
                                        GeneratorUtils.generateAllAbstractMethodImplementations((WorkingCopy)workingCopy, (TreePath)treePath);
                                    }
                                }

                                public void makeClassAbstract(Tree tree, String string) {
                                    if (tree.getKind() == Tree.Kind.CLASS) {
                                        ClassTree classTree = (ClassTree)tree;
                                        ModifiersTree modifiersTree = classTree.getModifiers();
                                        HashSet<Modifier> hashSet = new HashSet<Modifier>(modifiersTree.getFlags());
                                        hashSet.add(Modifier.ABSTRACT);
                                        workingCopy.rewrite((Tree)modifiersTree, (Tree)workingCopy.getTreeMaker().Modifiers(hashSet, modifiersTree.getAnnotations()));
                                    }
                                }
                            });
                        }
                    }).commit();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return null;
        }
    }

    private static interface Performer {
        public void fixAllAbstractMethods(TreePath var1, Tree var2);

        public void makeClassAbstract(Tree var1, String var2);
    }
}

