/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.hints.JavaHintsProvider;
import org.netbeans.modules.java.hints.Pair;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportClassEnabler
implements ErrorRule<ImportCandidatesHolder> {
    static RequestProcessor WORKER = new RequestProcessor("ImportClassEnabler", 1);
    private boolean cancelled;
    private ComputeImports compImports;

    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist", "compiler.err.not.stmt"));
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<ImportCandidatesHolder> data) {
        Object object;
        this.resume();
        int n2 = n + 1;
        if (n2 == -1) {
            JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create errorPosition=-1");
            return Collections.emptyList();
        }
        TreePath treePath2 = compilationInfo.getTreeUtilities().pathFor(n2);
        if (treePath2.getParentPath() != null && treePath2.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && !(object = (MethodInvocationTree)treePath2.getParentPath().getLeaf()).getTypeArguments().contains(treePath2.getLeaf())) {
            return Collections.emptyList();
        }
        object = JavaHintsProvider.findUnresolvedElementToken(compilationInfo, n);
        JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create ident={0}", object);
        if (object == null) {
            return Collections.emptyList();
        }
        FileObject fileObject = compilationInfo.getFileObject();
        String string2 = ((Object)object.text()).toString();
        Pair<List<String>, List<String>> pair = this.getCandidateFQNs(compilationInfo, fileObject, string2, data);
        if (this.isCancelled()) {
            JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancelled.");
            return Collections.emptyList();
        }
        List<String> list = pair.getA();
        List<String> list2 = pair.getB();
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        if (list2 != null && list != null) {
            for (String string3 : list) {
                arrayList.add(new FixImport(fileObject, string3, true));
            }
            for (String string3 : list2) {
                if (list.contains(string3)) continue;
                arrayList.add(new FixImport(fileObject, string3, false));
            }
        }
        JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create finished.");
        return arrayList;
    }

    @Override
    public synchronized void cancel() {
        JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancel called.");
        this.cancelled = true;
        if (this.compImports != null) {
            this.compImports.cancel();
        }
    }

    @Override
    public String getId() {
        return ImportClassEnabler.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Add Import Fix";
    }

    @Override
    public String getDescription() {
        return "Add Import Fix";
    }

    private synchronized void resume() {
        JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.resume called.");
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized void setComputeImports(ComputeImports computeImports) {
        this.compImports = computeImports;
    }

    public Pair<List<String>, List<String>> getCandidateFQNs(CompilationInfo compilationInfo, FileObject fileObject, String string, ErrorRule.Data<ImportCandidatesHolder> data) {
        Object object;
        Object object2;
        Pair<Object, Object> pair;
        ImportCandidatesHolder importCandidatesHolder = data.getData();
        if (importCandidatesHolder == null) {
            importCandidatesHolder = new ImportCandidatesHolder();
            data.setData(importCandidatesHolder);
        }
        if ((pair = importCandidatesHolder.getCandidates()) == null || pair.getA() == null || pair.getB() == null) {
            object2 = new HashMap();
            object = new ComputeImports();
            this.setComputeImports((ComputeImports)object);
            ComputeImports.Pair pair2 = object.computeCandidates(compilationInfo);
            this.setComputeImports(null);
            if (this.isCancelled()) {
                JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.getCandidateFQNs cancelled, returning.");
                return null;
            }
            for (Object object3 : ((Map)pair2.a).keySet()) {
                Object object4 = new ArrayList();
                for (Object object5 : (List)((Map)pair2.a).get(object3)) {
                    object4.add(object5.getQualifiedName().toString());
                }
                object2.put(object3, object4);
            }
            HashMap hashMap = new HashMap();
            for (Object object4 : ((Map)pair2.b).keySet()) {
                ArrayList arrayList = new ArrayList();
                for (TypeElement typeElement : (List)((Map)pair2.b).get(object4)) {
                    arrayList.add(typeElement.getQualifiedName().toString());
                }
                hashMap.put(object4, arrayList);
            }
            pair = new Pair<Object, Object>(object2, hashMap);
            importCandidatesHolder.setCandidates(pair);
        }
        object2 = pair.getA().get(string);
        object = pair.getB().get(string);
        return new Pair<Object, ComputeImports>(object2, (ComputeImports)object);
    }

    static final class FixImport
    implements Fix {
        private FileObject file;
        private String fqn;
        private boolean isValid;

        public FixImport(FileObject fileObject, String string, boolean bl) {
            this.file = fileObject;
            this.fqn = string;
            this.isValid = bl;
        }

        public String getText() {
            if (this.isValid) {
                return NbBundle.getMessage(ImportClassEnabler.class, (String)"Add_import_for_X", (Object[])new Object[]{this.fqn});
            }
            return "<html><font color='#808080'><s>" + NbBundle.getMessage(ImportClassEnabler.class, (String)"Add_import_for_X", (Object[])new Object[]{this.fqn});
        }

        public ChangeInfo implement() {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    if (workingCopy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TypeElement typeElement = workingCopy.getElements().getTypeElement(FixImport.this.fqn);
                    if (typeElement == null) {
                        Logger.getAnonymousLogger().warning(String.format("Attempt to fix import for FQN: %s, which does not have a TypeElement in currect context", FixImport.this.fqn));
                        return;
                    }
                    CompilationUnitTree compilationUnitTree = SourceUtils.addImports((CompilationUnitTree)workingCopy.getCompilationUnit(), Collections.singletonList(typeElement.getQualifiedName().toString()), (TreeMaker)workingCopy.getTreeMaker());
                    workingCopy.rewrite((Tree)workingCopy.getCompilationUnit(), (Tree)compilationUnitTree);
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runModificationTask((CancellableTask)cancellableTask).commit();
                return null;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return null;
            }
        }

        public int hashCode() {
            return this.fqn.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof FixImport) {
                return this.fqn.equals(((FixImport)object).fqn);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportCandidatesHolder {
        private Pair<Map<String, List<String>>, Map<String, List<String>>> candidates;

        public Pair<Map<String, List<String>>, Map<String, List<String>>> getCandidates() {
            return this.candidates;
        }

        public void setCandidates(Pair<Map<String, List<String>>, Map<String, List<String>>> pair) {
            this.candidates = pair;
        }
    }
}

