/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.java.hints.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.LazyHintComputationFactory;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaHintsProvider
implements CancellableTask<CompilationInfo> {
    public static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private FileObject file;
    private static final Map<Diagnostic.Kind, Severity> errorKind2Severity = new EnumMap<Diagnostic.Kind, Severity>(Diagnostic.Kind.class);
    private static final Set<String> CANNOT_RESOLVE;
    private static final Set<String> UNDERLINE_IDENTIFIER;
    private boolean cancel;

    JavaHintsProvider(FileObject fileObject) {
        this.file = fileObject;
    }

    List<ErrorDescription> computeErrors(CompilationInfo compilationInfo, Document document) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
        List list = compilationInfo.getDiagnostics();
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "errors = " + list);
        }
        HashMap<Class, ErrorRule.Data> hashMap = new HashMap<Class, ErrorRule.Data>();
        for (Diagnostic diagnostic : list) {
            if (this.isCanceled()) {
                return null;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "d = " + diagnostic);
            }
            Map<String, List<ErrorRule>> map = RulesManager.getInstance().getErrors();
            List<ErrorRule> list2 = map.get(diagnostic.getCode());
            if (ERR.isLoggable(1)) {
                ERR.log(1, "code= " + diagnostic.getCode());
                ERR.log(1, "rules = " + list2);
            }
            LazyFixList lazyFixList = list2 != null ? new CreatorBasedLazyFixList(compilationInfo.getFileObject(), diagnostic.getCode(), (int)this.getPrefferedPosition(compilationInfo, diagnostic), list2, hashMap) : ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
            if (ERR.isLoggable(1)) {
                ERR.log(1, "ehm=" + lazyFixList);
            }
            String string = diagnostic.getMessage(null);
            Position[] positionArray = this.getLine(compilationInfo, diagnostic, document, (int)diagnostic.getStartPosition(), (int)diagnostic.getEndPosition());
            if (this.isCanceled()) {
                return null;
            }
            if (positionArray[0] == null || positionArray[1] == null) continue;
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)errorKind2Severity.get((Object)diagnostic.getKind()), (String)string, (LazyFixList)lazyFixList, (Document)document, (Position)positionArray[0], (Position)positionArray[1]));
        }
        if (this.isCanceled()) {
            return null;
        }
        LazyHintComputationFactory.getAndClearToCompute(this.file);
        return arrayList;
    }

    public Document getDocument() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.file);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return null;
            }
            return editorCookie.getDocument();
        }
        catch (IOException iOException) {
            Logger.getLogger(JavaHintsProvider.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), iOException);
            return null;
        }
    }

    public static Token findUnresolvedElementToken(CompilationInfo compilationInfo, int n) {
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence();
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id() == JavaTokenId.DOT) {
                tokenSequence.moveNext();
                token = tokenSequence.token();
            } else if (token.id() == JavaTokenId.LT) {
                tokenSequence.moveNext();
                token = tokenSequence.token();
            }
            if (token.id() == JavaTokenId.IDENTIFIER) {
                return tokenSequence.offsetToken();
            }
        }
        return null;
    }

    private static int[] findUnresolvedElementSpan(CompilationInfo compilationInfo, int n) {
        TokenHierarchy tokenHierarchy = compilationInfo.getTokenHierarchy();
        Token token = JavaHintsProvider.findUnresolvedElementToken(compilationInfo, n);
        if (token != null) {
            return new int[]{token.offset(tokenHierarchy), token.offset(tokenHierarchy) + token.length()};
        }
        return null;
    }

    static TreePath findUnresolvedElement(CompilationInfo compilationInfo, int n) {
        int[] nArray = JavaHintsProvider.findUnresolvedElementSpan(compilationInfo, n);
        if (nArray != null) {
            return compilationInfo.getTreeUtilities().pathFor(nArray[0] + 1);
        }
        return null;
    }

    private Position[] getLine(CompilationInfo compilationInfo, Diagnostic diagnostic, final Document document, int object, int object2) {
        Token token;
        int n;
        Object object3;
        StyledDocument styledDocument = (StyledDocument)document;
        DataObject dataObject = (DataObject)document.getProperty("stream");
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)object);
        int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2);
        Line line = lineCookie.getLineSet().getCurrent(n2);
        boolean bl = false;
        if (CANNOT_RESOLVE.contains(diagnostic.getCode()) && (object3 = JavaHintsProvider.findUnresolvedElementSpan(compilationInfo, (int)this.getPrefferedPosition(compilationInfo, diagnostic))) != null && object3[0] != -1 && object3[1] != -1) {
            object = object3[0];
            object2 = object3[1];
            bl = true;
        }
        if (UNDERLINE_IDENTIFIER.contains(diagnostic.getCode())) {
            object3 = compilationInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            n = object3.move((int)this.getPrefferedPosition(compilationInfo, diagnostic));
            if (object3.moveNext() && n >= 0 && n < object3.token().length() && (token = object3.token()).id() == JavaTokenId.IDENTIFIER) {
                object = object3.offset();
                object2 = object + token.length();
                bl = true;
            }
        }
        if (!bl) {
            object3 = line.getText();
            int n4 = ((String)object3).length();
            for (n = 0; n < ((String)object3).length() && Character.isWhitespace(((String)object3).charAt(n)); ++n) {
            }
            while (n4 > 0 && Character.isWhitespace(((String)object3).charAt(n4 - 1))) {
                --n4;
            }
            object = n3 + n;
            object2 = n3 + n4;
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "startOffset = " + object);
            ERR.log(1, "endOffset = " + object2);
        }
        final int n5 = object;
        n = object2;
        token = new Position[2];
        document.render(new Runnable((Position[])token){
            final /* synthetic */ Position[] val$result;
            {
                this.val$result = positionArray;
            }

            public void run() {
                if (JavaHintsProvider.this.isCanceled()) {
                    return;
                }
                int n2 = document.getLength();
                if (n5 >= n2 || n >= n2) {
                    if (!JavaHintsProvider.this.isCanceled() && ERR.isLoggable(16)) {
                        ERR.log(16, "document changed, but not canceled?");
                        ERR.log(16, "len = " + n2);
                        ERR.log(16, "startOffset = " + n5);
                        ERR.log(16, "endOffset = " + n);
                    }
                    JavaHintsProvider.this.cancel();
                    return;
                }
                try {
                    this.val$result[0] = NbDocument.createPosition((Document)document, (int)n5, (Position.Bias)Position.Bias.Forward);
                    this.val$result[1] = NbDocument.createPosition((Document)document, (int)n, (Position.Bias)Position.Bias.Backward);
                }
                catch (BadLocationException badLocationException) {
                    ERR.notify(65536, (Throwable)badLocationException);
                }
            }
        });
        return token;
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.getLogger(JavaHintsProvider.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        long l = System.currentTimeMillis();
        List<ErrorDescription> list = this.computeErrors(compilationInfo, document);
        if (list == null) {
            return;
        }
        HintsController.setErrors((Document)document, (String)"java-hints", list);
        long l2 = System.currentTimeMillis();
        TimesCollector.getDefault().reportTime(compilationInfo.getFileObject(), "java-hints", "Java Hints", l2 - l);
    }

    private long getPrefferedPosition(CompilationInfo compilationInfo, Diagnostic diagnostic) {
        if ("compiler.err.doesnt.exist".equals(diagnostic.getCode())) {
            return diagnostic.getStartPosition();
        }
        if ("compiler.err.not.stmt".equals(diagnostic.getCode())) {
            Element element;
            TreePath treePath = JavaHintsProvider.findUnresolvedElement(compilationInfo, (int)diagnostic.getStartPosition() - 1);
            Element element2 = element = treePath != null ? compilationInfo.getTrees().getElement(treePath) : null;
            if (element == null || element.asType().getKind() == TypeKind.ERROR) {
                return diagnostic.getStartPosition() - 1L;
            }
            if (element.asType().getKind() == TypeKind.PACKAGE) {
                String string = ((PackageElement)element).getQualifiedName().toString();
                if (compilationInfo.getElements().getPackageElement(string) == null) {
                    return diagnostic.getStartPosition() - 1L;
                }
            }
            return diagnostic.getStartPosition();
        }
        return diagnostic.getPosition();
    }

    static {
        errorKind2Severity.put(Diagnostic.Kind.ERROR, Severity.ERROR);
        errorKind2Severity.put(Diagnostic.Kind.MANDATORY_WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.NOTE, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.OTHER, Severity.WARNING);
        CANNOT_RESOLVE = new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist"));
        UNDERLINE_IDENTIFIER = new HashSet<String>(Arrays.asList("compiler.err.local.var.accessed.from.icls.needs.final", "compiler.err.var.might.not.have.been.initialized"));
    }
}

